/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISizeProvider;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.EditorManager;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.dnd.IDragOverListener;
import org.eclipse.ui.internal.dnd.IDropTarget;
import org.eclipse.ui.internal.presentations.util.AbstractTabFolder;
import org.eclipse.ui.internal.presentations.util.TabFolderEvent;
import org.eclipse.ui.internal.presentations.util.TabFolderListener;
import org.eclipse.ui.internal.presentations.util.TabbedStackPresentation;
import org.eclipse.ui.presentations.StackDropResult;

public class DetachedWindow
implements IDragOverListener {
    public static final int INFINITE = Integer.MAX_VALUE;
    private PartStack folder;
    private WorkbenchPage page;
    private Rectangle bounds = new Rectangle(0, 0, 0, 0);
    private Shell windowShell;
    private boolean hideViewsOnClose = true;
    private ShellListener shellListener = new ShellAdapter(){

        public void shellClosed(ShellEvent shellEvent) {
            shellEvent.doit = DetachedWindow.this.handleClose();
        }
    };
    private Listener resizeListener = new Listener(){

        public void handleEvent(Event event) {
            Shell shell = (Shell)event.widget;
            DetachedWindow.this.folder.setBounds(shell.getClientArea());
        }
    };
    private Listener activationListener = new Listener(){

        public void handleEvent(Event event) {
            switch (event.type) {
                case 26: {
                    ((DetachedWindow)DetachedWindow.this).page.window.liftRestrictions();
                    break;
                }
                case 27: {
                    ((DetachedWindow)DetachedWindow.this).page.window.imposeRestrictions();
                }
            }
        }
    };
    private IPropertyListener propertyListener = new IPropertyListener(){

        @Override
        public void propertyChanged(Object object, int n) {
            if (n == 66) {
                DetachedWindow.this.activePartChanged(DetachedWindow.getPartReference(DetachedWindow.this.folder.getSelection()));
            }
        }
    };
    private IWorkbenchPartReference activePart;
    private IPropertyListener partPropertyListener = new IPropertyListener(){

        @Override
        public void propertyChanged(Object object, int n) {
            if (n == 1) {
                DetachedWindow.this.updateTitle();
            }
        }
    };

    public DetachedWindow(WorkbenchPage workbenchPage) {
        this.page = workbenchPage;
        this.folder = new ViewStack(this.page, false, 2, null);
        this.folder.addListener(this.propertyListener);
    }

    protected void activePartChanged(IWorkbenchPartReference iWorkbenchPartReference) {
        if (this.activePart == iWorkbenchPartReference) {
            return;
        }
        if (this.activePart != null) {
            this.activePart.removePropertyListener(this.partPropertyListener);
        }
        this.activePart = iWorkbenchPartReference;
        if (iWorkbenchPartReference != null) {
            iWorkbenchPartReference.addPropertyListener(this.partPropertyListener);
        }
        this.updateTitle();
    }

    private void updateTitle() {
    }

    private void updateMinimumSize() {
        TabbedStackPresentation tabbedStackPresentation;
        if (this.folder.getPresentation() instanceof TabbedStackPresentation && (tabbedStackPresentation = (TabbedStackPresentation)this.folder.getPresentation()).getPartList().length == 1) {
            int n = tabbedStackPresentation.computePreferredSize(true, Integer.MAX_VALUE, Integer.MAX_VALUE, 0);
            int n2 = tabbedStackPresentation.computePreferredSize(false, Integer.MAX_VALUE, Integer.MAX_VALUE, 0);
            int n3 = this.windowShell.getBounds().height - this.windowShell.getClientArea().height;
            int n4 = this.windowShell.getBounds().width - this.windowShell.getClientArea().width;
            this.windowShell.setMinimumSize(n + n4, n2 + n3);
        }
    }

    private static IWorkbenchPartReference getPartReference(PartPane partPane) {
        if (partPane == null) {
            return null;
        }
        return partPane.getPartReference();
    }

    public Shell getShell() {
        return this.windowShell;
    }

    public void create() {
        Rectangle rectangle;
        this.windowShell = ((WorkbenchWindow)this.page.getWorkbenchWindow()).getDetachedWindowPool().allocateShell(this.shellListener);
        this.windowShell.setData((Object)this);
        this.windowShell.setText("");
        DragUtil.addDragTarget((Control)this.windowShell, this);
        this.hideViewsOnClose = true;
        if (this.bounds.isEmpty()) {
            rectangle = Geometry.centerPoint((Rectangle)this.page.getWorkbenchWindow().getShell().getBounds());
            Point point = new Point(300, 200);
            Point point2 = Geometry.subtract((Point)rectangle, (Point)Geometry.divide((Point)point, (int)2));
            this.bounds = Geometry.createRectangle((Point)point2, (Point)point);
        }
        rectangle = this.getShell().getDisplay().getBounds();
        if (this.bounds.width > rectangle.width) {
            this.bounds.width = rectangle.width;
        }
        if (this.bounds.height > rectangle.height) {
            this.bounds.height = rectangle.height;
        }
        if (this.bounds.x + this.bounds.width > rectangle.width) {
            this.bounds.x = rectangle.width - this.bounds.width;
        }
        if (this.bounds.y + this.bounds.height > rectangle.height) {
            this.bounds.y = rectangle.height - this.bounds.height;
        }
        this.getShell().setBounds(this.bounds);
        this.configureShell(this.windowShell);
        this.createContents((Composite)this.windowShell);
        this.windowShell.layout(true);
        this.folder.setBounds(this.windowShell.getClientArea());
    }

    public void add(ViewPane viewPane) {
        Shell shell = this.getShell();
        if (shell != null) {
            viewPane.reparent((Composite)shell);
        }
        this.folder.add(viewPane);
        this.updateMinimumSize();
    }

    public boolean belongsToWorkbenchPage(IWorkbenchPage iWorkbenchPage) {
        return this.page == iWorkbenchPage;
    }

    public boolean close() {
        this.hideViewsOnClose = false;
        Shell shell = this.getShell();
        if (shell != null) {
            shell.close();
        }
        return true;
    }

    private boolean handleClose() {
        Object object;
        if (this.hideViewsOnClose) {
            object = new ArrayList();
            this.collectViewPanes((List)object, this.getChildren());
            if (!this.handleSaves((List)object)) {
                return false;
            }
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ViewPane viewPane = (ViewPane)iterator.next();
                if (viewPane.isCloseable()) {
                    this.page.hideView(viewPane.getViewReference());
                    if (viewPane.container == null) continue;
                    return false;
                }
                this.page.attachView(viewPane.getViewReference());
            }
        }
        if (this.folder != null) {
            this.folder.dispose();
        }
        if (this.windowShell != null) {
            this.windowShell.removeListener(11, this.resizeListener);
            this.windowShell.removeListener(26, this.activationListener);
            this.windowShell.removeListener(27, this.activationListener);
            DragUtil.removeDragTarget((Control)this.windowShell, this);
            this.bounds = this.windowShell.getBounds();
            object = (IContextService)this.getWorkbenchPage().getWorkbenchWindow().getWorkbench().getService(IContextService.class);
            object.unregisterShell(this.windowShell);
            this.windowShell.setData(null);
            this.windowShell = null;
        }
        return true;
    }

    private boolean handleSaves(List list) {
        boolean bl;
        ArrayList<IViewPart> arrayList = new ArrayList<IViewPart>();
        Object object = list.iterator();
        while (object.hasNext()) {
            ISaveablePart iSaveablePart;
            ViewPane viewPane = (ViewPane)object.next();
            IViewReference iViewReference = viewPane.getViewReference();
            IViewPart iViewPart = iViewReference.getView(false);
            if (!(iViewPart instanceof ISaveablePart) || !(iSaveablePart = (ISaveablePart)((Object)iViewPart)).isDirty() || !iSaveablePart.isSaveOnCloseNeeded()) continue;
            arrayList.add(iViewPart);
        }
        return arrayList.size() <= 0 || (bl = EditorManager.saveAll(arrayList, true, true, false, (IWorkbenchWindow)(object = this.page.getWorkbenchWindow())));
    }

    @Override
    public IDropTarget drag(Control control, Object object, Point point, Rectangle rectangle) {
        if (!(object instanceof PartPane)) {
            return null;
        }
        PartPane partPane = (PartPane)object;
        if (partPane.getWorkbenchWindow() != this.page.getWorkbenchWindow()) {
            return null;
        }
        IDropTarget iDropTarget = null;
        if (this.folder.allowsDrop(partPane) && (iDropTarget = this.folder.getDropTarget(object, point)) == null) {
            Rectangle rectangle2 = DragUtil.getDisplayBounds(this.folder.getControl());
            if (rectangle2.contains(point)) {
                iDropTarget = this.folder.createDropTarget(partPane, new StackDropResult(rectangle2, null));
            } else {
                return null;
            }
        }
        return iDropTarget;
    }

    private void collectViewPanes(List list, LayoutPart[] layoutPartArray) {
        int n = 0;
        int n2 = layoutPartArray.length;
        while (n < n2) {
            LayoutPart layoutPart = layoutPartArray[n];
            if (layoutPart instanceof ViewPane) {
                list.add(layoutPart);
            }
            ++n;
        }
    }

    protected void configureShell(Shell shell) {
        this.updateTitle();
        shell.addListener(11, this.resizeListener);
        shell.addListener(26, this.activationListener);
        shell.addListener(27, this.activationListener);
        IContextService iContextService = (IContextService)this.getWorkbenchPage().getWorkbenchWindow().getWorkbench().getService(IContextService.class);
        iContextService.registerShell(shell, 2);
        this.page.getWorkbenchWindow().getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.detached_window_context");
    }

    protected Control createContents(Composite composite) {
        ISizeProvider iSizeProvider;
        this.folder.createControl(composite);
        Vector vector = new Vector();
        this.collectViewPanes(vector, this.getChildren());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            iSizeProvider = (LayoutPart)enumeration.nextElement();
            ((LayoutPart)iSizeProvider).reparent(composite);
        }
        if (this.folder.getPresentation() instanceof TabbedStackPresentation) {
            iSizeProvider = (TabbedStackPresentation)this.folder.getPresentation();
            AbstractTabFolder abstractTabFolder = ((TabbedStackPresentation)iSizeProvider).getTabFolder();
            abstractTabFolder.addListener(new TabFolderListener(){

                @Override
                public void handleEvent(TabFolderEvent tabFolderEvent) {
                    switch (tabFolderEvent.type) {
                        case 6: {
                            DetachedWindow.this.updateMinimumSize();
                            break;
                        }
                        case 13: {
                            DetachedWindow.this.updateMinimumSize();
                        }
                    }
                }
            });
        }
        return this.folder.getControl();
    }

    public LayoutPart[] getChildren() {
        return this.folder.getChildren();
    }

    public WorkbenchPage getWorkbenchPage() {
        return this.page;
    }

    public void restoreState(IMemento iMemento) {
        IMemento iMemento2;
        Integer n = iMemento.getInteger("x");
        int n2 = n;
        n = iMemento.getInteger("y");
        int n3 = n;
        n = iMemento.getInteger("width");
        int n4 = n;
        n = iMemento.getInteger("height");
        int n5 = n;
        n = iMemento.getInteger("float");
        this.bounds = new Rectangle(n2, n3, n4, n5);
        if (this.getShell() != null) {
            this.getShell().setBounds(this.bounds);
        }
        if ((iMemento2 = iMemento.getChild("folder")) != null) {
            this.folder.restoreState(iMemento2);
        }
    }

    public void saveState(IMemento iMemento) {
        if (this.getShell() != null) {
            this.bounds = this.getShell().getBounds();
        }
        iMemento.putInteger("x", this.bounds.x);
        iMemento.putInteger("y", this.bounds.y);
        iMemento.putInteger("width", this.bounds.width);
        iMemento.putInteger("height", this.bounds.height);
        IMemento iMemento2 = iMemento.createChild("folder");
        this.folder.saveState(iMemento2);
    }

    public Control getControl() {
        return this.folder.getControl();
    }

    public int open() {
        if (this.getShell() == null) {
            this.create();
        }
        Rectangle rectangle = this.getShell().getBounds();
        this.getShell().setVisible(true);
        if (!rectangle.equals((Object)this.getShell().getBounds())) {
            this.getShell().setBounds(rectangle);
        }
        return 0;
    }
}

