/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartPlaceholder;

public class DetachedPlaceHolder
extends PartPlaceholder
implements ILayoutContainer {
    ArrayList children = new ArrayList();
    Rectangle bounds;

    public DetachedPlaceHolder(String string, Rectangle rectangle) {
        super(string);
        this.bounds = rectangle;
    }

    @Override
    public void add(LayoutPart layoutPart) {
        if (!(layoutPart instanceof PartPlaceholder)) {
            return;
        }
        this.children.add(layoutPart);
    }

    public boolean allowsBorder() {
        return false;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public LayoutPart[] getChildren() {
        LayoutPart[] layoutPartArray = new LayoutPart[this.children.size()];
        this.children.toArray(layoutPartArray);
        return layoutPartArray;
    }

    @Override
    public void remove(LayoutPart layoutPart) {
        this.children.remove(layoutPart);
    }

    @Override
    public void replace(LayoutPart layoutPart, LayoutPart layoutPart2) {
        this.remove(layoutPart);
        this.add(layoutPart2);
    }

    public void restoreState(IMemento iMemento) {
        Integer n = iMemento.getInteger("x");
        int n2 = n;
        n = iMemento.getInteger("y");
        int n3 = n;
        n = iMemento.getInteger("width");
        int n4 = n;
        n = iMemento.getInteger("height");
        int n5 = n;
        this.bounds = new Rectangle(n2, n3, n4, n5);
        IMemento[] iMementoArray = iMemento.getChildren("view");
        int n6 = 0;
        while (n6 < iMementoArray.length) {
            PartPlaceholder partPlaceholder = new PartPlaceholder(iMementoArray[n6].getString("id"));
            partPlaceholder.setContainer(this);
            this.children.add(partPlaceholder);
            ++n6;
        }
    }

    public void saveState(IMemento iMemento) {
        iMemento.putInteger("x", this.bounds.x);
        iMemento.putInteger("y", this.bounds.y);
        iMemento.putInteger("width", this.bounds.width);
        iMemento.putInteger("height", this.bounds.height);
        int n = 0;
        while (n < this.children.size()) {
            IMemento iMemento2 = iMemento.createChild("view");
            LayoutPart layoutPart = (LayoutPart)this.children.get(n);
            iMemento2.putString("id", layoutPart.getID());
            ++n;
        }
    }

    @Override
    public void findSashes(LayoutPart layoutPart, PartPane.Sashes sashes) {
        ILayoutContainer iLayoutContainer = this.getContainer();
        if (iLayoutContainer != null) {
            iLayoutContainer.findSashes(this, sashes);
        }
    }

    @Override
    public boolean allowsAutoFocus() {
        return false;
    }
}

