/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPart2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.Saveable;

public class DefaultSaveable
extends Saveable {
    private IWorkbenchPart part;

    public DefaultSaveable(IWorkbenchPart iWorkbenchPart) {
        this.part = iWorkbenchPart;
    }

    @Override
    public void doSave(IProgressMonitor iProgressMonitor) {
        if (this.part instanceof ISaveablePart) {
            ISaveablePart iSaveablePart = (ISaveablePart)((Object)this.part);
            iSaveablePart.doSave(iProgressMonitor);
        }
    }

    @Override
    public String getName() {
        if (this.part instanceof IWorkbenchPart2) {
            return ((IWorkbenchPart2)this.part).getPartName();
        }
        return this.part.getTitle();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        Image image = this.part.getTitleImage();
        if (image == null) {
            return null;
        }
        return ImageDescriptor.createFromImage((Image)image);
    }

    @Override
    public String getToolTipText() {
        return this.part.getTitleToolTip();
    }

    @Override
    public boolean isDirty() {
        if (this.part instanceof ISaveablePart) {
            return ((ISaveablePart)((Object)this.part)).isDirty();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.part.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DefaultSaveable defaultSaveable = (DefaultSaveable)object;
        return !(this.part == null ? defaultSaveable.part != null : !this.part.equals(defaultSaveable.part));
    }

    @Override
    public boolean show(IWorkbenchPage iWorkbenchPage) {
        IWorkbenchPartReference iWorkbenchPartReference = iWorkbenchPage.getReference(this.part);
        if (iWorkbenchPartReference != null) {
            iWorkbenchPage.activate(this.part);
            return true;
        }
        if (this.part instanceof IViewPart) {
            IViewPart iViewPart = (IViewPart)this.part;
            try {
                iWorkbenchPage.showView(iViewPart.getViewSite().getId(), iViewPart.getViewSite().getSecondaryId(), 1);
            }
            catch (PartInitException partInitException) {
                return false;
            }
            return true;
        }
        return false;
    }
}

