/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.RectangleAnimation;

public class DefaultAnimationFeedback {
    private static final int LINE_WIDTH = 1;
    private Display display;
    private Shell theShell;
    private Region shellRegion;
    private List startRects = new ArrayList();
    private List endRects = new ArrayList();

    public void initialize(Shell shell, Rectangle rectangle, Rectangle rectangle2) {
        this.addStartRect(rectangle);
        this.addEndRect(rectangle2);
        this.theShell = new Shell(shell, 16392);
        this.display = this.theShell.getDisplay();
        Color color = this.display.getSystemColor(21);
        this.theShell.setBackground(color);
        this.shellRegion = new Region((Device)this.display);
        this.theShell.setRegion(this.shellRegion);
    }

    public void addStartRect(Rectangle rectangle) {
        if (rectangle != null) {
            this.startRects.add(rectangle);
        }
    }

    public void addEndRect(Rectangle rectangle) {
        if (rectangle != null) {
            this.endRects.add(rectangle);
        }
    }

    public List getStartRects() {
        return this.startRects;
    }

    public List getEndRects() {
        return this.endRects;
    }

    public void renderStep(double d) {
        if (this.shellRegion != null) {
            this.shellRegion.dispose();
            this.shellRegion = new Region((Device)this.display);
        }
        Iterator iterator = this.startRects.iterator();
        Iterator iterator2 = this.endRects.iterator();
        while (iterator.hasNext()) {
            Rectangle rectangle = (Rectangle)iterator.next();
            Rectangle rectangle2 = (Rectangle)iterator2.next();
            Rectangle rectangle3 = RectangleAnimation.interpolate(rectangle, rectangle2, d);
            Rectangle rectangle4 = Geometry.toControl((Control)this.theShell, (Rectangle)rectangle3);
            this.shellRegion.add(rectangle4);
            ++rectangle4.x;
            ++rectangle4.y;
            rectangle4.width = Math.max(0, rectangle4.width - 2);
            rectangle4.height = Math.max(0, rectangle4.height - 2);
            this.shellRegion.subtract(rectangle4);
        }
        this.theShell.setRegion(this.shellRegion);
        this.display.update();
    }

    public void dispose() {
        this.theShell.setVisible(false);
        this.theShell.dispose();
        this.shellRegion.dispose();
    }

    public void jobInit() {
        Rectangle rectangle = Geometry.copy((Rectangle)((Rectangle)this.startRects.get(0)));
        Iterator iterator = this.startRects.iterator();
        Iterator iterator2 = this.endRects.iterator();
        while (iterator.hasNext()) {
            rectangle.add((Rectangle)iterator.next());
            rectangle.add((Rectangle)iterator2.next());
        }
        this.theShell.setBounds(rectangle);
        this.theShell.setVisible(true);
    }
}

