/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.CycleBaseHandler;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.model.PerspectiveLabelProvider;

public class CyclePerspectiveHandler
extends CycleBaseHandler {
    private PerspectiveLabelProvider labelProvider = new PerspectiveLabelProvider(false);

    @Override
    protected void addItems(Table table, WorkbenchPage workbenchPage) {
        IPerspectiveDescriptor[] iPerspectiveDescriptorArray = workbenchPage.getSortedPerspectives();
        int n = iPerspectiveDescriptorArray.length - 1;
        while (n >= 0) {
            TableItem tableItem = new TableItem(table, 0);
            IPerspectiveDescriptor iPerspectiveDescriptor = iPerspectiveDescriptorArray[n];
            String string = this.labelProvider.getText(iPerspectiveDescriptor);
            if (string == null) {
                string = "";
            }
            tableItem.setText(string);
            tableItem.setImage(this.labelProvider.getImage(iPerspectiveDescriptor));
            tableItem.setData((Object)iPerspectiveDescriptor);
            --n;
        }
    }

    @Override
    protected ParameterizedCommand getBackwardCommand() {
        ICommandService iCommandService = (ICommandService)this.window.getWorkbench().getService(ICommandService.class);
        Command command = iCommandService.getCommand("org.eclipse.ui.window.previousPerspective");
        ParameterizedCommand parameterizedCommand = new ParameterizedCommand(command, null);
        return parameterizedCommand;
    }

    @Override
    protected ParameterizedCommand getForwardCommand() {
        ICommandService iCommandService = (ICommandService)this.window.getWorkbench().getService(ICommandService.class);
        Command command = iCommandService.getCommand("org.eclipse.ui.window.nextPerspective");
        ParameterizedCommand parameterizedCommand = new ParameterizedCommand(command, null);
        return parameterizedCommand;
    }

    @Override
    protected String getTableHeader(IWorkbenchPart iWorkbenchPart) {
        return WorkbenchMessages.CyclePerspectiveAction_header;
    }

    public void dispose() {
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
            this.labelProvider = null;
        }
        super.dispose();
    }
}

