/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.CycleBaseHandler;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;

public class CycleEditorHandler
extends CycleBaseHandler {
    @Override
    protected void addItems(Table table, WorkbenchPage workbenchPage) {
        IEditorReference[] iEditorReferenceArray = workbenchPage.getSortedEditors();
        int n = iEditorReferenceArray.length - 1;
        while (n >= 0) {
            TableItem tableItem = null;
            tableItem = new TableItem(table, 0);
            if (iEditorReferenceArray[n].isDirty()) {
                tableItem.setText("*" + iEditorReferenceArray[n].getTitle());
            } else {
                tableItem.setText(iEditorReferenceArray[n].getTitle());
            }
            tableItem.setImage(iEditorReferenceArray[n].getTitleImage());
            tableItem.setData((Object)iEditorReferenceArray[n]);
            --n;
        }
    }

    @Override
    protected ParameterizedCommand getBackwardCommand() {
        ICommandService iCommandService = (ICommandService)this.window.getWorkbench().getService(ICommandService.class);
        Command command = iCommandService.getCommand("org.eclipse.ui.window.previousEditor");
        ParameterizedCommand parameterizedCommand = new ParameterizedCommand(command, null);
        return parameterizedCommand;
    }

    @Override
    protected ParameterizedCommand getForwardCommand() {
        ICommandService iCommandService = (ICommandService)this.window.getWorkbench().getService(ICommandService.class);
        Command command = iCommandService.getCommand("org.eclipse.ui.window.nextEditor");
        ParameterizedCommand parameterizedCommand = new ParameterizedCommand(command, null);
        return parameterizedCommand;
    }

    @Override
    protected String getTableHeader(IWorkbenchPart iWorkbenchPart) {
        return WorkbenchMessages.CycleEditorAction_header;
    }
}

