/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.keys.IBindingService;

public abstract class CycleBaseHandler
extends AbstractHandler
implements IExecutableExtension {
    private Object selection;
    protected IWorkbenchWindow window;
    protected boolean gotoDirection;
    private TriggerSequence[] backwardTriggerSequences = null;
    protected ParameterizedCommand commandBackward = null;
    protected ParameterizedCommand commandForward = null;
    private TriggerSequence[] forwardTriggerSequences = null;

    protected abstract void addItems(Table var1, WorkbenchPage var2);

    protected int getCurrentItemIndex() {
        return 0;
    }

    protected abstract ParameterizedCommand getBackwardCommand();

    protected abstract ParameterizedCommand getForwardCommand();

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        this.window = HandlerUtil.getActiveWorkbenchWindowChecked(executionEvent);
        IWorkbenchPage iWorkbenchPage = this.window.getActivePage();
        IWorkbenchPart iWorkbenchPart = iWorkbenchPage.getActivePart();
        this.getTriggers();
        this.openDialog((WorkbenchPage)iWorkbenchPage, iWorkbenchPart);
        this.clearTriggers();
        this.activate(iWorkbenchPage, this.selection);
        return null;
    }

    protected void openDialog(WorkbenchPage workbenchPage, IWorkbenchPart iWorkbenchPart) {
        Shell shell = null;
        this.selection = null;
        if (iWorkbenchPart != null) {
            shell = iWorkbenchPart.getSite().getShell();
        }
        if (shell == null) {
            shell = this.window.getShell();
        }
        final Shell shell2 = new Shell(shell, 0);
        Display display = shell2.getDisplay();
        shell2.setLayout((Layout)new FillLayout());
        final Table table = new Table((Composite)shell2, 65540);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setResizable(false);
        tableColumn.setText(this.getTableHeader(iWorkbenchPart));
        this.addItems(table, workbenchPage);
        int n = table.getItemCount();
        switch (n) {
            case 0: {
                this.cancel(shell2);
                return;
            }
            case 1: {
                table.setSelection(0);
                break;
            }
            default: {
                int n2;
                if (this.gotoDirection) {
                    n2 = this.getCurrentItemIndex() + 1;
                    if (n2 >= n) {
                        n2 = 0;
                    }
                } else {
                    n2 = this.getCurrentItemIndex() - 1;
                    if (n2 < 0) {
                        n2 = n - 1;
                    }
                }
                table.setSelection(n2);
            }
        }
        tableColumn.pack();
        table.pack();
        shell2.pack();
        Rectangle rectangle = table.getBounds();
        rectangle.height = Math.min(rectangle.height, table.getItemHeight() * 22);
        table.setBounds(rectangle);
        shell2.setBounds(shell2.computeTrim(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
        tableColumn.setWidth(table.getClientArea().width);
        table.setFocus();
        table.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                CycleBaseHandler.this.cancel(shell2);
            }
        });
        table.addMouseMoveListener(new MouseMoveListener(){
            TableItem lastItem = null;

            public void mouseMove(MouseEvent mouseEvent) {
                if (table.equals(mouseEvent.getSource())) {
                    TableItem tableItem;
                    if (this.lastItem == null ^ (tableItem = table.getItem(new Point(mouseEvent.x, mouseEvent.y))) == null) {
                        table.setCursor(tableItem == null ? null : table.getDisplay().getSystemCursor(21));
                    }
                    if (tableItem instanceof TableItem) {
                        if (!tableItem.equals(this.lastItem)) {
                            this.lastItem = tableItem;
                            table.setSelection(new TableItem[]{this.lastItem});
                        }
                    } else if (tableItem == null) {
                        this.lastItem = null;
                    }
                }
            }
        });
        this.setDialogLocation(shell2, iWorkbenchPart);
        IContextService iContextService = (IContextService)this.window.getWorkbench().getService(IContextService.class);
        try {
            shell2.open();
            this.addMouseListener(table, shell2);
            iContextService.registerShell(shell2, 1);
            this.addKeyListener(table, shell2);
            this.addTraverseListener(table);
            while (!shell2.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        finally {
            if (!shell2.isDisposed()) {
                this.cancel(shell2);
            }
            iContextService.unregisterShell(shell2);
        }
    }

    protected void setDialogLocation(Shell shell, IWorkbenchPart iWorkbenchPart) {
        Display display = shell.getDisplay();
        Rectangle rectangle = shell.getBounds();
        Rectangle rectangle2 = shell.getParent().getBounds();
        Rectangle rectangle3 = iWorkbenchPart == null ? display.getPrimaryMonitor().getBounds() : ((PartSite)iWorkbenchPart.getSite()).getPane().getControl().getMonitor().getBounds();
        rectangle.x = rectangle2.x + (rectangle2.width - rectangle.width) / 2;
        rectangle.y = rectangle2.y + (rectangle2.height - rectangle.height) / 2;
        if (!rectangle3.contains(rectangle.x, rectangle.y) || !rectangle3.contains(rectangle.x + rectangle.width, rectangle.y + rectangle.height)) {
            rectangle.x = Math.max(0, rectangle3.x + (rectangle3.width - rectangle.width) / 2);
            rectangle.y = Math.max(0, rectangle3.y + (rectangle3.height - rectangle.height) / 2);
        }
        shell.setLocation(rectangle.x, rectangle.y);
    }

    protected void clearTriggers() {
        this.forwardTriggerSequences = null;
        this.backwardTriggerSequences = null;
    }

    protected void getTriggers() {
        this.commandForward = this.getForwardCommand();
        this.commandBackward = this.getBackwardCommand();
        IBindingService iBindingService = (IBindingService)this.window.getWorkbench().getService(IBindingService.class);
        this.forwardTriggerSequences = iBindingService.getActiveBindingsFor(this.commandForward);
        this.backwardTriggerSequences = iBindingService.getActiveBindingsFor(this.commandBackward);
    }

    protected void addKeyListener(final Table table, final Shell shell) {
        table.addKeyListener(new KeyListener(){
            private boolean firstKey = true;
            private boolean quickReleaseMode = false;

            public void keyPressed(KeyEvent keyEvent) {
                int n;
                Trigger[] triggerArray;
                TriggerSequence triggerSequence;
                int n2;
                int n3;
                int n4 = keyEvent.keyCode;
                char c = keyEvent.character;
                int n5 = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)keyEvent);
                KeyStroke keyStroke = SWTKeySupport.convertAcceleratorToKeyStroke((int)n5);
                boolean bl = false;
                boolean bl2 = false;
                if (CycleBaseHandler.this.commandForward != null && CycleBaseHandler.this.forwardTriggerSequences != null) {
                    n3 = CycleBaseHandler.this.forwardTriggerSequences.length;
                    n2 = 0;
                    while (n2 < n3) {
                        triggerSequence = CycleBaseHandler.this.forwardTriggerSequences[n2];
                        triggerArray = triggerSequence.getTriggers();
                        n = triggerArray.length;
                        if (n > 0 && triggerArray[n - 1].equals((Object)keyStroke)) {
                            bl = true;
                            break;
                        }
                        ++n2;
                    }
                }
                if (CycleBaseHandler.this.commandBackward != null && CycleBaseHandler.this.backwardTriggerSequences != null) {
                    n3 = CycleBaseHandler.this.backwardTriggerSequences.length;
                    n2 = 0;
                    while (n2 < n3) {
                        triggerSequence = CycleBaseHandler.this.backwardTriggerSequences[n2];
                        triggerArray = triggerSequence.getTriggers();
                        n = triggerArray.length;
                        if (n > 0 && triggerArray[n - 1].equals((Object)keyStroke)) {
                            bl2 = true;
                            break;
                        }
                        ++n2;
                    }
                }
                if (c == '\r' || c == '\n') {
                    CycleBaseHandler.this.ok(shell, table);
                } else if (bl) {
                    if (this.firstKey && keyEvent.stateMask != 0) {
                        this.quickReleaseMode = true;
                    }
                    n3 = table.getSelectionIndex();
                    table.setSelection((n3 + 1) % table.getItemCount());
                } else if (bl2) {
                    if (this.firstKey && keyEvent.stateMask != 0) {
                        this.quickReleaseMode = true;
                    }
                    table.setSelection((n3 = table.getSelectionIndex()) >= 1 ? n3 - 1 : table.getItemCount() - 1);
                } else if (n4 != 65536 && n4 != 0x400000 && n4 != 262144 && n4 != 131072 && n4 != 0x1000002 && n4 != 0x1000001 && n4 != 0x1000003 && n4 != 0x1000004) {
                    CycleBaseHandler.this.cancel(shell);
                }
                this.firstKey = false;
            }

            public void keyReleased(KeyEvent keyEvent) {
                int n = keyEvent.keyCode;
                int n2 = keyEvent.stateMask;
                IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
                boolean bl = iPreferenceStore.getBoolean("STICKY_CYCLE");
                if (!bl && (this.firstKey || this.quickReleaseMode) && n == n2) {
                    CycleBaseHandler.this.ok(shell, table);
                }
            }
        });
    }

    protected final void addTraverseListener(Table table) {
        table.addTraverseListener(new TraverseListener(){

            public final void keyTraversed(TraverseEvent traverseEvent) {
                traverseEvent.doit = false;
            }
        });
    }

    protected void activate(IWorkbenchPage iWorkbenchPage, Object object) {
        if (object != null) {
            Object object2;
            if (object instanceof IEditorReference) {
                iWorkbenchPage.setEditorAreaVisible(true);
            }
            if (object instanceof IWorkbenchPartReference && (object2 = ((IWorkbenchPartReference)object).getPart(true)) != null) {
                iWorkbenchPage.activate((IWorkbenchPart)object2);
            }
            if (object instanceof IPerspectiveDescriptor) {
                object2 = (IPerspectiveDescriptor)object;
                iWorkbenchPage.setPerspective((IPerspectiveDescriptor)object2);
            }
        }
    }

    protected void cancel(Shell shell) {
        this.selection = null;
        shell.close();
    }

    protected void ok(Shell shell, Table table) {
        TableItem[] tableItemArray = table.getSelection();
        if (tableItemArray != null && tableItemArray.length == 1) {
            this.selection = tableItemArray[0].getData();
        }
        shell.close();
    }

    protected void addMouseListener(final Table table, final Shell shell) {
        table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                CycleBaseHandler.this.ok(shell, table);
            }

            public void mouseDown(MouseEvent mouseEvent) {
                CycleBaseHandler.this.ok(shell, table);
            }

            public void mouseUp(MouseEvent mouseEvent) {
                CycleBaseHandler.this.ok(shell, table);
            }
        });
    }

    protected abstract String getTableHeader(IWorkbenchPart var1);

    public Object getSelection() {
        return this.selection;
    }

    public IWorkbenchWindow getWindow() {
        return this.window;
    }

    public TriggerSequence[] getBackwardTriggerSequences() {
        return this.backwardTriggerSequences;
    }

    public TriggerSequence[] getForwardTriggerSequences() {
        return this.forwardTriggerSequences;
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) throws CoreException {
        this.gotoDirection = "true".equals(object);
    }
}

