/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.DateFormat;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.about.ISystemSummarySection;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;

public final class ConfigurationInfo {
    public static String getBuildId() {
        return System.getProperty("eclipse.buildId", null);
    }

    public static String getSystemSummary() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(NLS.bind((String)WorkbenchMessages.SystemSummary_timeStamp, (Object)DateFormat.getDateTimeInstance((int)0, (int)0).format(new Date())));
        ConfigurationInfo.appendExtensions(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    private static void appendExtensions(PrintWriter printWriter) {
        IConfigurationElement[] iConfigurationElementArray = ConfigurationInfo.getSortedExtensions(Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui", "systemSummarySections"));
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            Object object = null;
            try {
                object = WorkbenchPlugin.createExtension(iConfigurationElement, "class");
            }
            catch (CoreException coreException) {
                WorkbenchPlugin.log("could not create class attribute for extension", coreException.getStatus());
            }
            printWriter.println();
            printWriter.println(NLS.bind((String)WorkbenchMessages.SystemSummary_sectionTitle, (Object)iConfigurationElement.getAttribute("sectionTitle")));
            if (object instanceof ISystemSummarySection) {
                ISystemSummarySection iSystemSummarySection = (ISystemSummarySection)object;
                iSystemSummarySection.write(printWriter);
            } else {
                printWriter.println(WorkbenchMessages.SystemSummary_sectionError);
            }
            ++n;
        }
    }

    public static IConfigurationElement[] getSortedExtensions(IConfigurationElement[] iConfigurationElementArray) {
        Arrays.sort(iConfigurationElementArray, new Comparator(){
            Collator collator = Collator.getInstance((Locale)Locale.getDefault());

            public int compare(Object object, Object object2) {
                IConfigurationElement iConfigurationElement = (IConfigurationElement)object;
                IConfigurationElement iConfigurationElement2 = (IConfigurationElement)object2;
                String string = iConfigurationElement.getAttribute("id");
                String string2 = iConfigurationElement2.getAttribute("id");
                if (string != null && string2 != null && !string.equals(string2)) {
                    return this.collator.compare(string, string2);
                }
                String string3 = iConfigurationElement.getAttribute("sectionTitle");
                String string4 = iConfigurationElement2.getAttribute("sectionTitle");
                if (string3 == null) {
                    string3 = "";
                }
                if (string4 == null) {
                    string4 = "";
                }
                return this.collator.compare(string3, string4);
            }
        });
        return iConfigurationElementArray;
    }
}

