/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.AbstractEvaluationHandler;
import org.eclipse.ui.internal.InternalHandlerUtil;

public class CloseOthersHandler
extends AbstractEvaluationHandler {
    private Expression enabledWhen;

    public CloseOthersHandler() {
        this.registerEnablement();
    }

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IEditorReference[] iEditorReferenceArray;
        IWorkbenchWindow iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked(executionEvent);
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage != null && (iEditorReferenceArray = iWorkbenchPage.getEditorReferences()) != null && iEditorReferenceArray.length > 1) {
            IEditorReference[] iEditorReferenceArray2 = new IEditorReference[iEditorReferenceArray.length - 1];
            IEditorReference iEditorReference = (IEditorReference)iWorkbenchPage.getReference(iWorkbenchPage.getActiveEditor());
            int n = 0;
            while (n < iEditorReferenceArray.length) {
                if (iEditorReferenceArray[n] == iEditorReference) {
                    System.arraycopy(iEditorReferenceArray, 0, iEditorReferenceArray2, 0, n);
                    System.arraycopy(iEditorReferenceArray, n + 1, iEditorReferenceArray2, n, iEditorReferenceArray.length - 1 - n);
                    break;
                }
                ++n;
            }
            iWorkbenchPage.closeEditors(iEditorReferenceArray2, true);
        }
        return null;
    }

    @Override
    protected Expression getEnabledWhenExpression() {
        if (this.enabledWhen == null) {
            this.enabledWhen = new Expression(){

                public EvaluationResult evaluate(IEvaluationContext iEvaluationContext) throws CoreException {
                    IEditorReference[] iEditorReferenceArray;
                    IWorkbenchPage iWorkbenchPage;
                    IWorkbenchWindow iWorkbenchWindow = InternalHandlerUtil.getActiveWorkbenchWindow(iEvaluationContext);
                    if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null && (iEditorReferenceArray = iWorkbenchPage.getEditorReferences()) != null && iEditorReferenceArray.length > 1) {
                        return EvaluationResult.TRUE;
                    }
                    return EvaluationResult.FALSE;
                }

                public void collectExpressionInfo(ExpressionInfo expressionInfo) {
                    expressionInfo.addVariableNameAccess("activeWorkbenchWindow");
                }
            };
        }
        return this.enabledWhen;
    }
}

