/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.PageEventAction;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;

public class CloseAllSavedAction
extends PageEventAction
implements IPropertyListener {
    private List partsWithListeners = new ArrayList(1);

    public CloseAllSavedAction(IWorkbenchWindow iWorkbenchWindow) {
        super(WorkbenchMessages.CloseAllSavedAction_text, iWorkbenchWindow);
        this.setToolTipText(WorkbenchMessages.CloseAllSavedAction_toolTip);
        this.setId("closeAllSaved");
        this.updateState();
        iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.close_all_saved_action_context");
        this.setActionDefinitionId("org.eclipse.ui.file.closeAllSaved");
    }

    @Override
    public void pageActivated(IWorkbenchPage iWorkbenchPage) {
        super.pageActivated(iWorkbenchPage);
        this.updateState();
    }

    @Override
    public void pageClosed(IWorkbenchPage iWorkbenchPage) {
        super.pageClosed(iWorkbenchPage);
        this.updateState();
    }

    @Override
    public void partClosed(IWorkbenchPart iWorkbenchPart) {
        super.partClosed(iWorkbenchPart);
        if (iWorkbenchPart instanceof IEditorPart) {
            iWorkbenchPart.removePropertyListener(this);
            this.partsWithListeners.remove(iWorkbenchPart);
            this.updateState();
        }
    }

    @Override
    public void partOpened(IWorkbenchPart iWorkbenchPart) {
        super.partOpened(iWorkbenchPart);
        if (iWorkbenchPart instanceof IEditorPart) {
            iWorkbenchPart.addPropertyListener(this);
            this.partsWithListeners.add(iWorkbenchPart);
            this.updateState();
        }
    }

    @Override
    public void propertyChanged(Object object, int n) {
        if (object instanceof IEditorPart && n == 257) {
            this.updateState();
        }
    }

    public void run() {
        if (this.getWorkbenchWindow() == null) {
            return;
        }
        IWorkbenchPage iWorkbenchPage = this.getActivePage();
        if (iWorkbenchPage != null) {
            ((WorkbenchPage)iWorkbenchPage).closeAllSavedEditors();
        }
    }

    private void updateState() {
        IWorkbenchPage iWorkbenchPage = this.getActivePage();
        if (iWorkbenchPage == null) {
            this.setEnabled(false);
            return;
        }
        IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            if (!iEditorReferenceArray[n].isDirty()) {
                this.setEnabled(true);
                return;
            }
            ++n;
        }
        this.setEnabled(false);
    }

    @Override
    public void dispose() {
        super.dispose();
        for (IWorkbenchPart iWorkbenchPart : this.partsWithListeners) {
            iWorkbenchPart.removePropertyListener(this);
        }
        this.partsWithListeners.clear();
    }
}

