/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.net.URL;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.branding.IBundleGroupConstants;
import org.eclipse.ui.internal.BrandingProperties;

public class BundleGroupProperties
extends BrandingProperties
implements IBundleGroupConstants {
    private final IBundleGroup bundleGroup;
    private ImageDescriptor featureImageDescriptor;
    private URL featureImageUrl;
    private String tipsAndTricksHref;
    private URL welcomePageUrl;
    private String welcomePerspective;
    private URL licenseUrl;
    private String featureLabel;
    private String featureId;
    private String providerName;
    private String versionId;
    private String brandingId;
    private String brandingVersion;

    public BundleGroupProperties(IBundleGroup iBundleGroup) {
        if (iBundleGroup == null) {
            throw new IllegalArgumentException();
        }
        this.bundleGroup = iBundleGroup;
    }

    public ImageDescriptor getFeatureImage() {
        if (this.featureImageDescriptor == null) {
            this.featureImageDescriptor = BundleGroupProperties.getFeatureImage(this.bundleGroup);
        }
        return this.featureImageDescriptor;
    }

    public URL getFeatureImageUrl() {
        if (this.featureImageUrl == null) {
            this.featureImageUrl = BundleGroupProperties.getFeatureImageUrl(this.bundleGroup);
        }
        return this.featureImageUrl;
    }

    public String getTipsAndTricksHref() {
        if (this.tipsAndTricksHref == null) {
            this.tipsAndTricksHref = BundleGroupProperties.getTipsAndTricksHref(this.bundleGroup);
        }
        return this.tipsAndTricksHref;
    }

    public URL getWelcomePageUrl() {
        if (this.welcomePageUrl == null) {
            this.welcomePageUrl = BundleGroupProperties.getWelcomePageUrl(this.bundleGroup);
        }
        return this.welcomePageUrl;
    }

    public String getWelcomePerspective() {
        if (this.welcomePerspective == null) {
            this.welcomePerspective = BundleGroupProperties.getWelcomePerspective(this.bundleGroup);
        }
        return this.welcomePerspective;
    }

    public URL getLicenseUrl() {
        if (this.licenseUrl == null) {
            this.licenseUrl = BundleGroupProperties.getLicenseUrl(this.bundleGroup);
        }
        return this.licenseUrl;
    }

    public String getFeatureLabel() {
        if (this.featureLabel == null) {
            this.featureLabel = BundleGroupProperties.getFeatureLabel(this.bundleGroup);
        }
        return this.featureLabel;
    }

    public String getFeatureId() {
        if (this.featureId == null) {
            this.featureId = BundleGroupProperties.getFeatureId(this.bundleGroup);
        }
        return this.featureId;
    }

    public String getProviderName() {
        if (this.providerName == null) {
            this.providerName = BundleGroupProperties.getProviderName(this.bundleGroup);
        }
        return this.providerName;
    }

    public String getFeatureVersion() {
        if (this.versionId == null) {
            this.versionId = BundleGroupProperties.getFeatureVersion(this.bundleGroup);
        }
        return this.versionId;
    }

    public String getBrandingBundleId() {
        if (this.brandingId == null) {
            this.brandingId = BundleGroupProperties.getBrandingBundleId(this.bundleGroup);
        }
        return this.brandingId;
    }

    public String getBrandingBundleVersion() {
        if (this.brandingVersion == null) {
            this.brandingVersion = BundleGroupProperties.getBrandingBundleVersion(this.bundleGroup);
        }
        return this.brandingVersion;
    }

    public static ImageDescriptor getFeatureImage(IBundleGroup iBundleGroup) {
        return BundleGroupProperties.getImage(iBundleGroup.getProperty("featureImage"), null);
    }

    public static URL getFeatureImageUrl(IBundleGroup iBundleGroup) {
        return BundleGroupProperties.getUrl(iBundleGroup.getProperty("featureImage"), null);
    }

    public static String getTipsAndTricksHref(IBundleGroup iBundleGroup) {
        return iBundleGroup.getProperty("tipsAndTricksHref");
    }

    public static URL getWelcomePageUrl(IBundleGroup iBundleGroup) {
        return BundleGroupProperties.getUrl(iBundleGroup.getProperty("welcomePage"), null);
    }

    public static String getWelcomePerspective(IBundleGroup iBundleGroup) {
        String string = iBundleGroup.getProperty("welcomePerspective");
        return string == null ? null : string;
    }

    public static URL getLicenseUrl(IBundleGroup iBundleGroup) {
        return BundleGroupProperties.getUrl(iBundleGroup.getProperty("licenseHref"), null);
    }

    public static String getFeatureLabel(IBundleGroup iBundleGroup) {
        return iBundleGroup.getName();
    }

    public static String getFeatureId(IBundleGroup iBundleGroup) {
        return iBundleGroup.getIdentifier();
    }

    public static String getProviderName(IBundleGroup iBundleGroup) {
        return iBundleGroup.getProviderName();
    }

    public static String getFeatureVersion(IBundleGroup iBundleGroup) {
        return iBundleGroup.getVersion();
    }

    public static String getBrandingBundleId(IBundleGroup iBundleGroup) {
        return iBundleGroup.getProperty("brandingBundleId");
    }

    public static String getBrandingBundleVersion(IBundleGroup iBundleGroup) {
        return iBundleGroup.getProperty("brandingBundleVersion");
    }
}

