/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IAggregateWorkingSet;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.internal.AbstractWorkingSet;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.util.Util;

public class AggregateWorkingSet
extends AbstractWorkingSet
implements IAggregateWorkingSet,
IPropertyChangeListener {
    private IWorkingSet[] components;
    private boolean inElementConstruction = false;

    public AggregateWorkingSet(String string, String string2, IWorkingSet[] iWorkingSetArray) {
        super(string, string2);
        IWorkingSet[] iWorkingSetArray2 = new IWorkingSet[iWorkingSetArray.length];
        System.arraycopy(iWorkingSetArray, 0, iWorkingSetArray2, 0, iWorkingSetArray.length);
        this.internalSetComponents(iWorkingSetArray2);
        this.constructElements(false);
    }

    public AggregateWorkingSet(String string, String string2, IMemento iMemento) {
        super(string, string2);
        String string3;
        this.workingSetMemento = iMemento;
        if (this.workingSetMemento != null && (string3 = this.workingSetMemento.getString("id")) != null) {
            this.setUniqueId(string3);
        }
    }

    void setComponents(IWorkingSet[] iWorkingSetArray) {
        this.internalSetComponents(iWorkingSetArray);
        this.constructElements(true);
    }

    private void internalSetComponents(IWorkingSet[] iWorkingSetArray) {
        this.components = iWorkingSetArray;
    }

    private void constructElements(boolean bl) {
        if (this.inElementConstruction) {
            String string = NLS.bind((String)WorkbenchMessages.ProblemCyclicDependency, (Object)this.getName());
            WorkbenchPlugin.log(string);
            throw new IllegalStateException(string);
        }
        this.inElementConstruction = true;
        try {
            HashSet<IAdaptable> hashSet = new HashSet<IAdaptable>();
            IWorkingSet[] iWorkingSetArray = this.getComponentsInternal();
            int n = 0;
            while (n < iWorkingSetArray.length) {
                IAdaptable[] iAdaptableArray;
                IWorkingSet iWorkingSet = iWorkingSetArray[n];
                try {
                    iAdaptableArray = iWorkingSet.getElements();
                    hashSet.addAll(Arrays.asList(iAdaptableArray));
                }
                catch (IllegalStateException illegalStateException) {
                    iAdaptableArray = new IWorkingSet[this.components.length - 1];
                    if (n > 0) {
                        System.arraycopy(this.components, 0, iAdaptableArray, 0, n);
                    }
                    if (this.components.length - n - 1 > 0) {
                        System.arraycopy(this.components, n + 1, iAdaptableArray, n, this.components.length - n - 1);
                    }
                    this.components = iAdaptableArray;
                    this.workingSetMemento = null;
                    this.fireWorkingSetChanged("workingSetContentChange", null);
                }
                ++n;
            }
            this.internalSetElements(hashSet.toArray(new IAdaptable[hashSet.size()]));
            if (bl) {
                this.fireWorkingSetChanged("workingSetContentChange", null);
            }
        }
        finally {
            this.inElementConstruction = false;
        }
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return WorkbenchImages.getImageDescriptor("IMG_OBJ_WORKING_SETS");
    }

    @Override
    public void setElements(IAdaptable[] iAdaptableArray) {
    }

    @Override
    public void setId(String string) {
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public void saveState(IMemento iMemento) {
        if (this.workingSetMemento != null) {
            iMemento.putMemento(this.workingSetMemento);
        } else {
            iMemento.putString("name", this.getName());
            iMemento.putString("label", this.getLabel());
            iMemento.putString("id", this.getUniqueId());
            iMemento.putString("aggregate", Boolean.TRUE.toString());
            IWorkingSet[] iWorkingSetArray = this.getComponentsInternal();
            int n = 0;
            while (n < iWorkingSetArray.length) {
                IWorkingSet iWorkingSet = iWorkingSetArray[n];
                iMemento.createChild("workingSet", iWorkingSet.getName());
                ++n;
            }
        }
    }

    @Override
    public void connect(IWorkingSetManager iWorkingSetManager) {
        iWorkingSetManager.addPropertyChangeListener(this);
        super.connect(iWorkingSetManager);
    }

    @Override
    public void disconnect() {
        IWorkingSetManager iWorkingSetManager = this.getManager();
        if (iWorkingSetManager != null) {
            iWorkingSetManager.removePropertyChangeListener(this);
        }
        super.disconnect();
    }

    @Override
    public IWorkingSet[] getComponents() {
        IWorkingSet[] iWorkingSetArray = this.getComponentsInternal();
        IWorkingSet[] iWorkingSetArray2 = new IWorkingSet[iWorkingSetArray.length];
        System.arraycopy(iWorkingSetArray, 0, iWorkingSetArray2, 0, iWorkingSetArray.length);
        return iWorkingSetArray2;
    }

    private IWorkingSet[] getComponentsInternal() {
        if (this.components == null) {
            this.restoreWorkingSet();
            this.workingSetMemento = null;
        }
        return this.components;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        block4: {
            String string;
            block5: {
                string = propertyChangeEvent.getProperty();
                if (!string.equals("workingSetRemove")) break block5;
                Object[] objectArray = this.getComponentsInternal();
                int n = 0;
                while (n < objectArray.length) {
                    IWorkingSet iWorkingSet = objectArray[n];
                    if (iWorkingSet.equals(propertyChangeEvent.getOldValue())) {
                        Object[] objectArray2 = new IWorkingSet[objectArray.length - 1];
                        Util.arrayCopyWithRemoval(objectArray, objectArray2, n);
                        this.setComponents((IWorkingSet[])objectArray2);
                    }
                    ++n;
                }
                break block4;
            }
            if (!string.equals("workingSetContentChange")) break block4;
            IWorkingSet[] iWorkingSetArray = this.getComponentsInternal();
            int n = 0;
            while (n < iWorkingSetArray.length) {
                IWorkingSet iWorkingSet = iWorkingSetArray[n];
                if (iWorkingSet.equals(propertyChangeEvent.getNewValue())) {
                    this.constructElements(true);
                    break;
                }
                ++n;
            }
        }
    }

    @Override
    void restoreWorkingSet() {
        IWorkingSetManager iWorkingSetManager = this.getManager();
        if (iWorkingSetManager == null) {
            throw new IllegalStateException();
        }
        IMemento[] iMementoArray = this.workingSetMemento.getChildren("workingSet");
        ArrayList<IWorkingSet> arrayList = new ArrayList<IWorkingSet>(iMementoArray.length);
        int n = 0;
        while (n < iMementoArray.length) {
            IMemento iMemento = iMementoArray[n];
            String string = iMemento.getID();
            IWorkingSet iWorkingSet = iWorkingSetManager.getWorkingSet(string);
            if (iWorkingSet != null) {
                arrayList.add(iWorkingSet);
            }
            ++n;
        }
        this.internalSetComponents(arrayList.toArray(new IWorkingSet[arrayList.size()]));
        this.constructElements(false);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AggregateWorkingSet) {
            AggregateWorkingSet aggregateWorkingSet = (AggregateWorkingSet)object;
            return Util.equals(aggregateWorkingSet.getName(), this.getName()) && Util.equals(aggregateWorkingSet.getComponentsInternal(), this.getComponentsInternal());
        }
        return false;
    }

    public int hashCode() {
        int n = this.getName().hashCode() & this.getComponentsInternal().hashCode();
        return n;
    }

    @Override
    public boolean isSelfUpdating() {
        IWorkingSet[] iWorkingSetArray = this.getComponentsInternal();
        if (iWorkingSetArray == null || iWorkingSetArray.length == 0) {
            return false;
        }
        int n = 0;
        while (n < iWorkingSetArray.length) {
            if (!iWorkingSetArray[n].isSelfUpdating()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public boolean isAggregateWorkingSet() {
        return true;
    }

    @Override
    public IAdaptable[] adaptElements(IAdaptable[] iAdaptableArray) {
        return new IAdaptable[0];
    }
}

