/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.activities.IActivityRequirementBinding;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.NotDefinedException;
import org.eclipse.ui.internal.WorkbenchPlugin;

final class ActivityPersistanceHelper {
    protected static final String PREFIX = "UIActivities.";
    private static ActivityPersistanceHelper singleton;
    private final IActivityManagerListener activityManagerListener = new IActivityManagerListener(){

        @Override
        public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
            if (activityManagerEvent.haveDefinedActivityIdsChanged()) {
                HashSet hashSet = new HashSet(activityManagerEvent.getActivityManager().getDefinedActivityIds());
                hashSet.removeAll(activityManagerEvent.getPreviouslyDefinedActivityIds());
                ActivityPersistanceHelper.this.loadEnabledStates(activityManagerEvent.getActivityManager().getEnabledActivityIds(), hashSet);
            }
            if (activityManagerEvent.haveEnabledActivityIdsChanged()) {
                ActivityPersistanceHelper.this.saveEnabledStates();
            }
        }
    };
    private final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!ActivityPersistanceHelper.this.saving && propertyChangeEvent.getProperty().startsWith(ActivityPersistanceHelper.PREFIX)) {
                String string = propertyChangeEvent.getProperty().substring(ActivityPersistanceHelper.PREFIX.length());
                IWorkbenchActivitySupport iWorkbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
                IActivityManager iActivityManager = iWorkbenchActivitySupport.getActivityManager();
                boolean bl = Boolean.valueOf(propertyChangeEvent.getNewValue().toString());
                HashSet<String> hashSet = new HashSet<String>(iActivityManager.getEnabledActivityIds());
                if (!bl) {
                    Set set = ActivityPersistanceHelper.this.buildDependencies(iActivityManager, string);
                    hashSet.removeAll(set);
                } else {
                    hashSet.add(string);
                }
                iWorkbenchActivitySupport.setEnabledActivityIds(hashSet);
            }
        }
    };
    protected boolean saving = false;

    public static ActivityPersistanceHelper getInstance() {
        if (singleton == null) {
            singleton = new ActivityPersistanceHelper();
        }
        return singleton;
    }

    protected Set buildDependencies(IActivityManager iActivityManager, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = iActivityManager.getDefinedActivityIds().iterator();
        while (iterator.hasNext()) {
            IActivity iActivity = iActivityManager.getActivity((String)iterator.next());
            for (IActivityRequirementBinding iActivityRequirementBinding : iActivity.getActivityRequirementBindings()) {
                if (!string.equals(iActivityRequirementBinding.getRequiredActivityId())) continue;
                hashSet.addAll(this.buildDependencies(iActivityManager, iActivity.getId()));
            }
        }
        hashSet.add(string);
        return hashSet;
    }

    private ActivityPersistanceHelper() {
        this.loadEnabledStates();
        this.hookListeners();
    }

    private void hookListeners() {
        IWorkbenchActivitySupport iWorkbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
        IActivityManager iActivityManager = iWorkbenchActivitySupport.getActivityManager();
        iActivityManager.addActivityManagerListener(this.activityManagerListener);
        IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.addPropertyChangeListener(this.propertyChangeListener);
    }

    private void unhookListeners() {
        IWorkbenchActivitySupport iWorkbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
        IActivityManager iActivityManager = iWorkbenchActivitySupport.getActivityManager();
        iActivityManager.removeActivityManagerListener(this.activityManagerListener);
        IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.removePropertyChangeListener(this.propertyChangeListener);
    }

    private String createPreferenceKey(String string) {
        return PREFIX + string;
    }

    void loadEnabledStates() {
        this.loadEnabledStates(Collections.EMPTY_SET, PlatformUI.getWorkbench().getActivitySupport().getActivityManager().getDefinedActivityIds());
    }

    protected void loadEnabledStates(Set set, Set set2) {
        if (set2.isEmpty()) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>(set);
        IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        IWorkbenchActivitySupport iWorkbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
        IActivityManager iActivityManager = iWorkbenchActivitySupport.getActivityManager();
        for (String string : set2) {
            String string2 = this.createPreferenceKey(string);
            try {
                IActivity iActivity = iActivityManager.getActivity(string);
                if (iActivity.getExpression() != null) continue;
                if ("".equals(iPreferenceStore.getDefaultString(string2))) {
                    iPreferenceStore.setDefault(string2, iActivity.isDefaultEnabled());
                }
            }
            catch (NotDefinedException notDefinedException) {}
            if (iPreferenceStore.getBoolean(string2)) {
                hashSet.add(string);
                continue;
            }
            hashSet.remove(string);
        }
        iWorkbenchActivitySupport.setEnabledActivityIds(hashSet);
    }

    protected void saveEnabledStates() {
        try {
            this.saving = true;
            IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
            IWorkbenchActivitySupport iWorkbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
            IActivityManager iActivityManager = iWorkbenchActivitySupport.getActivityManager();
            Iterator iterator = iActivityManager.getDefinedActivityIds().iterator();
            while (iterator.hasNext()) {
                IActivity iActivity = iActivityManager.getActivity((String)iterator.next());
                if (iActivity.getExpression() != null) continue;
                iPreferenceStore.setValue(this.createPreferenceKey(iActivity.getId()), iActivity.isEnabled());
            }
            WorkbenchPlugin.getDefault().savePluginPreferences();
        }
        finally {
            this.saving = false;
        }
    }

    public void shutdown() {
        this.unhookListeners();
        this.saveEnabledStates();
    }
}

