/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.AbstractEvaluationHandler;
import org.eclipse.ui.internal.InternalHandlerUtil;
import org.eclipse.ui.internal.WorkbenchPage;

public class ActivateEditorHandler
extends AbstractEvaluationHandler {
    private Expression enabledWhen;

    public ActivateEditorHandler() {
        this.registerEnablement();
    }

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IWorkbenchWindow iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked(executionEvent);
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage != null) {
            IEditorPart iEditorPart = HandlerUtil.getActiveEditor(executionEvent);
            if (iEditorPart != null) {
                iWorkbenchPage.activate(iEditorPart);
            } else {
                IWorkbenchPartReference iWorkbenchPartReference = iWorkbenchPage.getActivePartReference();
                if (iWorkbenchPartReference instanceof IViewReference && ((WorkbenchPage)iWorkbenchPage).isFastView((IViewReference)iWorkbenchPartReference)) {
                    ((WorkbenchPage)iWorkbenchPage).toggleFastView((IViewReference)iWorkbenchPartReference);
                }
            }
        }
        return null;
    }

    @Override
    protected Expression getEnabledWhenExpression() {
        if (this.enabledWhen == null) {
            this.enabledWhen = new Expression(){

                public EvaluationResult evaluate(IEvaluationContext iEvaluationContext) throws CoreException {
                    IWorkbenchWindow iWorkbenchWindow = InternalHandlerUtil.getActiveWorkbenchWindow(iEvaluationContext);
                    if (iWorkbenchWindow != null && iWorkbenchWindow.getActivePage() != null) {
                        return EvaluationResult.TRUE;
                    }
                    return EvaluationResult.FALSE;
                }

                public void collectExpressionInfo(ExpressionInfo expressionInfo) {
                    expressionInfo.addVariableNameAccess("activeWorkbenchWindow");
                }
            };
        }
        return this.enabledWhen;
    }
}

