/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.services.IServiceLocator;

public class ActionSetManager {
    private HashMap actionSets = new HashMap();
    private HashSet visibleItems = new HashSet();
    public static final int PROP_VISIBLE = 0;
    public static final int PROP_HIDDEN = 1;
    public static final int CHANGE_MASK = 0;
    public static final int CHANGE_UNMASK = 1;
    public static final int CHANGE_SHOW = 2;
    public static final int CHANGE_HIDE = 3;
    private ListenerList listeners = new ListenerList();
    private IPropertyListener contextListener;
    private Map activationsById = new HashMap();
    private IContextService contextService;

    public ActionSetManager(IServiceLocator iServiceLocator) {
        this.contextService = (IContextService)iServiceLocator.getService(IContextService.class);
        this.addListener(this.getContextListener());
    }

    private IPropertyListener getContextListener() {
        if (this.contextListener == null) {
            this.contextListener = new IPropertyListener(){

                @Override
                public void propertyChanged(Object object, int n) {
                    if (object instanceof IActionSetDescriptor) {
                        IContextActivation iContextActivation;
                        IActionSetDescriptor iActionSetDescriptor = (IActionSetDescriptor)object;
                        String string = iActionSetDescriptor.getId();
                        if (n == 0) {
                            ActionSetManager.this.activationsById.put(string, ActionSetManager.this.contextService.activateContext(string));
                        } else if (n == 1 && (iContextActivation = (IContextActivation)ActionSetManager.this.activationsById.remove(string)) != null) {
                            ActionSetManager.this.contextService.deactivateContext(iContextActivation);
                        }
                    }
                }
            };
        }
        return this.contextListener;
    }

    public void addListener(IPropertyListener iPropertyListener) {
        this.listeners.add((Object)iPropertyListener);
    }

    public void removeListener(IPropertyListener iPropertyListener) {
        this.listeners.remove((Object)iPropertyListener);
    }

    private void firePropertyChange(IActionSetDescriptor iActionSetDescriptor, int n) {
        Object[] objectArray = this.listeners.getListeners();
        int n2 = 0;
        while (n2 < objectArray.length) {
            IPropertyListener iPropertyListener = (IPropertyListener)objectArray[n2];
            iPropertyListener.propertyChanged(iActionSetDescriptor, n);
            ++n2;
        }
    }

    private ActionSetRec getRec(IActionSetDescriptor iActionSetDescriptor) {
        ActionSetRec actionSetRec = (ActionSetRec)this.actionSets.get(iActionSetDescriptor);
        if (actionSetRec == null) {
            actionSetRec = new ActionSetRec();
            this.actionSets.put(iActionSetDescriptor, actionSetRec);
        }
        return actionSetRec;
    }

    public void showAction(IActionSetDescriptor iActionSetDescriptor) {
        ActionSetRec actionSetRec = this.getRec(iActionSetDescriptor);
        boolean bl = actionSetRec.isVisible();
        ++actionSetRec.showCount;
        if (!bl && actionSetRec.isVisible()) {
            this.visibleItems.add(iActionSetDescriptor);
            this.firePropertyChange(iActionSetDescriptor, 0);
            if (actionSetRec.isEmpty()) {
                this.actionSets.remove(iActionSetDescriptor);
            }
        }
    }

    public void hideAction(IActionSetDescriptor iActionSetDescriptor) {
        ActionSetRec actionSetRec = this.getRec(iActionSetDescriptor);
        boolean bl = actionSetRec.isVisible();
        --actionSetRec.showCount;
        if (bl && !actionSetRec.isVisible()) {
            this.visibleItems.remove(iActionSetDescriptor);
            this.firePropertyChange(iActionSetDescriptor, 1);
            if (actionSetRec.isEmpty()) {
                this.actionSets.remove(iActionSetDescriptor);
            }
        }
    }

    public void maskAction(IActionSetDescriptor iActionSetDescriptor) {
        ActionSetRec actionSetRec = this.getRec(iActionSetDescriptor);
        boolean bl = actionSetRec.isVisible();
        ++actionSetRec.maskCount;
        if (bl && !actionSetRec.isVisible()) {
            this.visibleItems.remove(iActionSetDescriptor);
            this.firePropertyChange(iActionSetDescriptor, 1);
            if (actionSetRec.isEmpty()) {
                this.actionSets.remove(iActionSetDescriptor);
            }
        }
    }

    public void unmaskAction(IActionSetDescriptor iActionSetDescriptor) {
        ActionSetRec actionSetRec = this.getRec(iActionSetDescriptor);
        boolean bl = actionSetRec.isVisible();
        --actionSetRec.maskCount;
        if (!bl && actionSetRec.isVisible()) {
            this.visibleItems.add(iActionSetDescriptor);
            this.firePropertyChange(iActionSetDescriptor, 0);
            if (actionSetRec.isEmpty()) {
                this.actionSets.remove(iActionSetDescriptor);
            }
        }
    }

    public Collection getVisibleItems() {
        return this.visibleItems;
    }

    public void change(IActionSetDescriptor iActionSetDescriptor, int n) {
        switch (n) {
            case 2: {
                this.showAction(iActionSetDescriptor);
                break;
            }
            case 3: {
                this.hideAction(iActionSetDescriptor);
                break;
            }
            case 0: {
                this.maskAction(iActionSetDescriptor);
                break;
            }
            case 1: {
                this.unmaskAction(iActionSetDescriptor);
            }
        }
    }

    private static class ActionSetRec {
        int showCount;
        int maskCount;

        private ActionSetRec() {
        }

        public boolean isVisible() {
            return this.maskCount == 0 && this.showCount > 0;
        }

        public boolean isEmpty() {
            return this.maskCount == 0 && this.showCount == 0;
        }
    }
}

