/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.internal.ActionSetActionBars;
import org.eclipse.ui.internal.PluginActionSet;
import org.eclipse.ui.internal.PluginActionSetBuilder;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.provisional.application.IActionBarConfigurer2;
import org.eclipse.ui.internal.registry.IActionSet;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;

public class ActionPresentation {
    private WorkbenchWindow window;
    private HashMap mapDescToRec = new HashMap(3);
    private HashMap invisibleBars = new HashMap(3);

    public ActionPresentation(WorkbenchWindow workbenchWindow) {
        this.window = workbenchWindow;
    }

    public void clearActionSets() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.mapDescToRec.keySet());
        arrayList.addAll(this.invisibleBars.keySet());
        for (IActionSetDescriptor iActionSetDescriptor : arrayList) {
            this.removeActionSet(iActionSetDescriptor);
        }
    }

    public void removeActionSet(IActionSetDescriptor iActionSetDescriptor) {
        SetRec setRec = (SetRec)this.mapDescToRec.remove(iActionSetDescriptor);
        if (setRec == null) {
            setRec = (SetRec)this.invisibleBars.remove(iActionSetDescriptor);
        }
        if (setRec != null) {
            IActionSet iActionSet = setRec.set;
            SubActionBars subActionBars = setRec.bars;
            if (subActionBars != null) {
                subActionBars.dispose();
            }
            if (iActionSet != null) {
                iActionSet.dispose();
            }
        }
    }

    public void setActionSets(IActionSetDescriptor[] iActionSetDescriptorArray) {
        Object object;
        Object object2;
        Object object3;
        Object object42;
        Iterator iterator;
        HashSet<IActionSetDescriptor> hashSet = new HashSet<IActionSetDescriptor>();
        int n = 0;
        while (n < iActionSetDescriptorArray.length) {
            iterator = iActionSetDescriptorArray[n];
            hashSet.add((IActionSetDescriptor)((Object)iterator));
            ++n;
        }
        ArrayList arrayList = new ArrayList(this.mapDescToRec.keySet());
        for (Object object42 : arrayList) {
            SetRec setRec;
            if (hashSet.contains(object42) || (setRec = (SetRec)this.mapDescToRec.get(object42)) == null) continue;
            this.mapDescToRec.remove(object42);
            object3 = setRec.set;
            object2 = setRec.bars;
            if (object2 == null) continue;
            object = new SetRec((IActionSet)object3, (SubActionBars)object2);
            this.invisibleBars.put(object42, object);
            ((SubActionBars)object2).deactivate();
        }
        object42 = new ArrayList();
        int n2 = 0;
        while (n2 < iActionSetDescriptorArray.length) {
            object3 = iActionSetDescriptorArray[n2];
            if (!this.mapDescToRec.containsKey(object3)) {
                try {
                    if (this.invisibleBars.containsKey(object3)) {
                        object2 = (SetRec)this.invisibleBars.get(object3);
                        if (((SetRec)object2).bars != null) {
                            ((SetRec)object2).bars.activate();
                        }
                        this.invisibleBars.remove(object3);
                    } else {
                        object = object3.createActionSet();
                        ActionSetActionBars actionSetActionBars = new ActionSetActionBars(this.window.getActionBars(), this.window, (IActionBarConfigurer2)this.window.getWindowConfigurer().getActionBarConfigurer(), object3.getId());
                        object2 = new SetRec((IActionSet)object, actionSetActionBars);
                        object.init(this.window, actionSetActionBars);
                        ((ArrayList)object42).add(object);
                        Object[] objectArray = this.window.getExtensionTracker().getObjects(object3.getConfigurationElement().getDeclaringExtension());
                        if (objectArray.length == 0 || !this.containsRegistration(objectArray, (IActionSetDescriptor)object3)) {
                            this.window.getExtensionTracker().registerObject(object3.getConfigurationElement().getDeclaringExtension(), object3, 2);
                        }
                    }
                    this.mapDescToRec.put(object3, object2);
                }
                catch (CoreException coreException) {
                    WorkbenchPlugin.log("Unable to create ActionSet: " + object3.getId(), coreException);
                }
            }
            ++n2;
        }
        PluginActionSetBuilder.processActionSets((ArrayList)object42, this.window);
        iterator = ((ArrayList)object42).iterator();
        while (iterator.hasNext()) {
            PluginActionSet pluginActionSet = (PluginActionSet)iterator.next();
            pluginActionSet.getBars().activate();
        }
    }

    private boolean containsRegistration(Object[] objectArray, IActionSetDescriptor iActionSetDescriptor) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == iActionSetDescriptor) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public IActionSet[] getActionSets() {
        Collection collection = this.mapDescToRec.values();
        IActionSet[] iActionSetArray = new IActionSet[collection.size()];
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            iActionSetArray[n] = ((SetRec)iterator.next()).set;
            ++n;
        }
        return iActionSetArray;
    }

    private class SetRec {
        public IActionSet set;
        public SubActionBars bars;

        public SetRec(IActionSet iActionSet, SubActionBars subActionBars) {
            this.set = iActionSet;
            this.bars = subActionBars;
        }
    }
}

