/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.internal.LegacyResourceSupport;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.internal.util.Util;
import org.osgi.framework.Bundle;

public class ActionExpression {
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_VALUE = "value";
    public static final String EXP_TYPE_AND = "and";
    public static final String EXP_TYPE_NOT = "not";
    public static final String EXP_TYPE_OBJECT_CLASS = "objectClass";
    public static final String EXP_TYPE_OBJECT_STATE = "objectState";
    public static final String EXP_TYPE_OR = "or";
    public static final String EXP_TYPE_PLUG_IN_STATE = "pluginState";
    public static final String EXP_TYPE_SYSTEM_PROPERTY = "systemProperty";
    private static final int HASH_CODE_NOT_COMPUTED = -1;
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL = ActionExpression.class.getName().hashCode();
    private static final String PLUGIN_ACTIVATED = "activated";
    private static final String PLUGIN_INSTALLED = "installed";
    private transient int hashCode = -1;
    private SingleExpression root;

    private static AbstractExpression createExpression(IConfigurationElement iConfigurationElement) throws IllegalStateException {
        String string = iConfigurationElement.getName();
        if (string.equals(EXP_TYPE_OR)) {
            return new OrExpression(iConfigurationElement);
        }
        if (string.equals(EXP_TYPE_AND)) {
            return new AndExpression(iConfigurationElement);
        }
        if (string.equals(EXP_TYPE_NOT)) {
            return new NotExpression(iConfigurationElement);
        }
        if (string.equals(EXP_TYPE_OBJECT_STATE)) {
            return new ObjectStateExpression(iConfigurationElement);
        }
        if (string.equals(EXP_TYPE_OBJECT_CLASS)) {
            return new ObjectClassExpression(iConfigurationElement);
        }
        if (string.equals(EXP_TYPE_PLUG_IN_STATE)) {
            return new PluginStateExpression(iConfigurationElement);
        }
        if (string.equals(EXP_TYPE_SYSTEM_PROPERTY)) {
            return new SystemPropertyExpression(iConfigurationElement);
        }
        throw new IllegalStateException("Action expression unrecognized element: " + string);
    }

    public ActionExpression(IConfigurationElement iConfigurationElement) {
        try {
            this.root = new SingleExpression(iConfigurationElement);
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
            this.root = null;
        }
    }

    public ActionExpression(String string, String string2) {
        if (string.equals(EXP_TYPE_OBJECT_CLASS)) {
            this.root = new SingleExpression(new ObjectClassExpression(string2));
        }
    }

    public final boolean equals(Object object) {
        if (object instanceof ActionExpression) {
            ActionExpression actionExpression = (ActionExpression)object;
            return Util.equals(this.root, actionExpression.root);
        }
        return false;
    }

    public String[] extractObjectClasses() {
        return this.root.extractObjectClasses();
    }

    public final int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = HASH_INITIAL * 89 + Util.hashCode(this.root);
            if (this.hashCode == -1) {
                ++this.hashCode;
            }
        }
        return this.hashCode;
    }

    public boolean isEnabledFor(IStructuredSelection iStructuredSelection) {
        if (this.root == null) {
            return false;
        }
        if (iStructuredSelection == null || iStructuredSelection.isEmpty()) {
            return this.root.isEnabledFor(null);
        }
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            if (this.isEnabledFor(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isEnabledFor(Object object) {
        if (this.root == null) {
            return false;
        }
        return this.root.isEnabledFor(object);
    }

    public boolean isEnabledForExpression(Object object, String string) {
        if (this.root == null) {
            return false;
        }
        return this.root.isEnabledForExpression(object, string);
    }

    public Collection valuesForExpression(String string) {
        return this.root.valuesForExpression(string);
    }

    private static abstract class AbstractExpression {
        protected transient int expressionHashCode = -1;

        private AbstractExpression() {
        }

        public String[] extractObjectClasses() {
            return null;
        }

        public abstract boolean isEnabledFor(Object var1);

        public boolean isEnabledForExpression(Object object, String string) {
            return false;
        }

        public Collection valuesForExpression(String string) {
            return null;
        }
    }

    private static class AndExpression
    extends CompositeExpression {
        public AndExpression(IConfigurationElement iConfigurationElement) throws IllegalStateException {
            super(iConfigurationElement);
        }

        public final boolean equals(Object object) {
            if (object instanceof AndExpression) {
                AndExpression andExpression = (AndExpression)object;
                return Util.equals(this.list, andExpression.list);
            }
            return false;
        }

        @Override
        public boolean isEnabledFor(Object object) {
            for (AbstractExpression abstractExpression : this.list) {
                if (abstractExpression.isEnabledFor(object)) continue;
                return false;
            }
            return true;
        }
    }

    private static abstract class CompositeExpression
    extends AbstractExpression {
        protected ArrayList list;

        public CompositeExpression(IConfigurationElement iConfigurationElement) throws IllegalStateException {
            IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
            if (iConfigurationElementArray.length == 0) {
                throw new IllegalStateException("Composite expression cannot be empty");
            }
            this.list = new ArrayList(iConfigurationElementArray.length);
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                String string = iConfigurationElementArray[n].getName();
                AbstractExpression abstractExpression = ActionExpression.createExpression(iConfigurationElementArray[n]);
                if (ActionExpression.EXP_TYPE_OBJECT_CLASS.equals(string)) {
                    this.list.add(0, abstractExpression);
                } else {
                    this.list.add(abstractExpression);
                }
                ++n;
            }
        }

        @Override
        public String[] extractObjectClasses() {
            String[] stringArray;
            Iterator iterator = this.list.iterator();
            ArrayList<String> arrayList = null;
            while (iterator.hasNext()) {
                stringArray = (String[])iterator.next();
                String[] stringArray2 = stringArray.extractObjectClasses();
                if (stringArray2 == null) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                int n = 0;
                while (n < stringArray2.length) {
                    arrayList.add(stringArray2[n]);
                    ++n;
                }
            }
            if (arrayList == null) {
                return null;
            }
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            return stringArray;
        }

        public final int hashCode() {
            if (this.expressionHashCode == -1) {
                this.expressionHashCode = HASH_INITIAL * 89 + Util.hashCode(this.list);
                if (this.expressionHashCode == -1) {
                    ++this.expressionHashCode;
                }
            }
            return this.expressionHashCode;
        }

        @Override
        public boolean isEnabledForExpression(Object object, String string) {
            for (AbstractExpression abstractExpression : this.list) {
                if (!abstractExpression.isEnabledForExpression(object, string)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Collection valuesForExpression(String string) {
            Iterator iterator = this.list.iterator();
            Collection collection = null;
            while (iterator.hasNext()) {
                AbstractExpression abstractExpression = (AbstractExpression)iterator.next();
                Collection collection2 = abstractExpression.valuesForExpression(string);
                if (collection2 == null) continue;
                if (collection == null) {
                    collection = collection2;
                    continue;
                }
                collection.addAll(collection2);
            }
            return collection;
        }
    }

    private static class NotExpression
    extends SingleExpression {
        public NotExpression(IConfigurationElement iConfigurationElement) throws IllegalStateException {
            super(iConfigurationElement);
        }

        @Override
        public boolean isEnabledFor(Object object) {
            return !super.isEnabledFor(object);
        }
    }

    private static class ObjectClassExpression
    extends AbstractExpression {
        private String className;
        private boolean extracted;

        public ObjectClassExpression(IConfigurationElement iConfigurationElement) throws IllegalStateException {
            this.className = iConfigurationElement.getAttribute(ActionExpression.ATT_NAME);
            if (this.className == null) {
                throw new IllegalStateException("Object class expression missing name attribute");
            }
        }

        public ObjectClassExpression(String string) {
            if (string == null) {
                throw new IllegalStateException("Object class expression must have class name");
            }
            this.className = string;
        }

        private boolean checkInterfaceHierarchy(Class clazz) {
            if (clazz.getName().equals(this.className)) {
                return true;
            }
            Class<?>[] classArray = clazz.getInterfaces();
            int n = 0;
            while (n < classArray.length) {
                if (this.checkInterfaceHierarchy(classArray[n])) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public final boolean equals(Object object) {
            if (object instanceof ObjectClassExpression) {
                ObjectClassExpression objectClassExpression = (ObjectClassExpression)object;
                return Util.equals(this.className, objectClassExpression.className) && Util.equals(this.extracted, objectClassExpression.extracted);
            }
            return false;
        }

        @Override
        public String[] extractObjectClasses() {
            this.extracted = true;
            return new String[]{this.className};
        }

        public final int hashCode() {
            if (this.expressionHashCode == -1) {
                this.expressionHashCode = HASH_INITIAL * 89 + Util.hashCode(this.className);
                this.expressionHashCode = this.expressionHashCode * 89 + Util.hashCode(this.extracted);
                if (this.expressionHashCode == -1) {
                    ++this.expressionHashCode;
                }
            }
            return this.expressionHashCode;
        }

        @Override
        public boolean isEnabledFor(Object object) {
            if (object == null) {
                return false;
            }
            if (this.extracted) {
                return true;
            }
            Class<?> clazz = object.getClass();
            while (clazz != null) {
                if (clazz.getName().equals(this.className)) {
                    return true;
                }
                Class<?>[] classArray = clazz.getInterfaces();
                int n = 0;
                while (n < classArray.length) {
                    if (this.checkInterfaceHierarchy(classArray[n])) {
                        return true;
                    }
                    ++n;
                }
                clazz = clazz.getSuperclass();
            }
            return false;
        }

        @Override
        public boolean isEnabledForExpression(Object object, String string) {
            if (string.equals(ActionExpression.EXP_TYPE_OBJECT_CLASS)) {
                return this.isEnabledFor(object);
            }
            return false;
        }
    }

    private static class ObjectStateExpression
    extends AbstractExpression {
        private String name;
        private String value;

        public ObjectStateExpression(IConfigurationElement iConfigurationElement) throws IllegalStateException {
            this.name = iConfigurationElement.getAttribute(ActionExpression.ATT_NAME);
            this.value = iConfigurationElement.getAttribute(ActionExpression.ATT_VALUE);
            if (this.name == null || this.value == null) {
                throw new IllegalStateException("Object state expression missing attribute");
            }
        }

        public final boolean equals(Object object) {
            if (object instanceof ObjectStateExpression) {
                ObjectStateExpression objectStateExpression = (ObjectStateExpression)object;
                return Util.equals(this.name, objectStateExpression.name) && Util.equals(this.value, objectStateExpression.value);
            }
            return false;
        }

        private IActionFilter getActionFilter(Object object) {
            return (IActionFilter)Util.getAdapter(object, IActionFilter.class);
        }

        public final int hashCode() {
            if (this.expressionHashCode == -1) {
                this.expressionHashCode = HASH_INITIAL * 89 + Util.hashCode(this.name);
                this.expressionHashCode = this.expressionHashCode * 89 + Util.hashCode(this.value);
                if (this.expressionHashCode == -1) {
                    ++this.expressionHashCode;
                }
            }
            return this.expressionHashCode;
        }

        @Override
        public boolean isEnabledFor(Object object) {
            if (object == null) {
                return false;
            }
            if (this.preciselyMatches(object)) {
                return true;
            }
            Class clazz = LegacyResourceSupport.getResourceClass();
            if (clazz == null) {
                return false;
            }
            if (clazz.isInstance(object)) {
                return false;
            }
            Object object2 = Util.getAdapter(object, clazz);
            if (object2 == null) {
                return false;
            }
            return this.preciselyMatches(object2);
        }

        private boolean preciselyMatches(Object object) {
            IActionFilter iActionFilter = this.getActionFilter(object);
            if (iActionFilter == null) {
                return false;
            }
            return iActionFilter.testAttribute(object, this.name, this.value);
        }

        @Override
        public Collection valuesForExpression(String string) {
            if (string.equals(this.name)) {
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add(this.value);
                return hashSet;
            }
            return null;
        }
    }

    private static class OrExpression
    extends CompositeExpression {
        public OrExpression(IConfigurationElement iConfigurationElement) throws IllegalStateException {
            super(iConfigurationElement);
        }

        public final boolean equals(Object object) {
            if (object instanceof OrExpression) {
                OrExpression orExpression = (OrExpression)object;
                return Util.equals(this.list, orExpression.list);
            }
            return false;
        }

        @Override
        public boolean isEnabledFor(Object object) {
            for (AbstractExpression abstractExpression : this.list) {
                if (!abstractExpression.isEnabledFor(object)) continue;
                return true;
            }
            return false;
        }
    }

    private static class PluginStateExpression
    extends AbstractExpression {
        private String id;
        private String value;

        public PluginStateExpression(IConfigurationElement iConfigurationElement) throws IllegalStateException {
            this.id = iConfigurationElement.getAttribute(ActionExpression.ATT_ID);
            this.value = iConfigurationElement.getAttribute(ActionExpression.ATT_VALUE);
            if (this.id == null || this.value == null) {
                throw new IllegalStateException("Plugin state expression missing attribute");
            }
        }

        public final boolean equals(Object object) {
            if (object instanceof PluginStateExpression) {
                PluginStateExpression pluginStateExpression = (PluginStateExpression)object;
                return Util.equals(this.id, pluginStateExpression.id) && Util.equals(this.value, pluginStateExpression.value);
            }
            return false;
        }

        public final int hashCode() {
            if (this.expressionHashCode == -1) {
                this.expressionHashCode = HASH_INITIAL * 89 + Util.hashCode(this.id);
                this.expressionHashCode = this.expressionHashCode * 89 + Util.hashCode(this.value);
                if (this.expressionHashCode == -1) {
                    ++this.expressionHashCode;
                }
            }
            return this.expressionHashCode;
        }

        @Override
        public boolean isEnabledFor(Object object) {
            Bundle bundle = Platform.getBundle((String)this.id);
            if (!BundleUtility.isReady(bundle)) {
                return false;
            }
            if (this.value.equals(ActionExpression.PLUGIN_INSTALLED)) {
                return true;
            }
            if (this.value.equals(ActionExpression.PLUGIN_ACTIVATED)) {
                return BundleUtility.isActivated(bundle);
            }
            return false;
        }
    }

    private static class SingleExpression
    extends AbstractExpression {
        private AbstractExpression child;

        public SingleExpression(AbstractExpression abstractExpression) throws IllegalStateException {
            if (abstractExpression == null) {
                throw new IllegalStateException("Single expression must contain 1 expression");
            }
            this.child = abstractExpression;
        }

        public SingleExpression(IConfigurationElement iConfigurationElement) throws IllegalStateException {
            IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
            if (iConfigurationElementArray.length != 1) {
                throw new IllegalStateException("Single expression does not contain only 1 expression");
            }
            this.child = ActionExpression.createExpression(iConfigurationElementArray[0]);
        }

        public final boolean equals(Object object) {
            if (object instanceof SingleExpression) {
                SingleExpression singleExpression = (SingleExpression)object;
                return Util.equals(this.child, singleExpression.child);
            }
            return false;
        }

        @Override
        public String[] extractObjectClasses() {
            return this.child.extractObjectClasses();
        }

        public final int hashCode() {
            if (this.expressionHashCode == -1) {
                this.expressionHashCode = HASH_INITIAL * 89 + Util.hashCode(this.child);
                if (this.expressionHashCode == -1) {
                    ++this.expressionHashCode;
                }
            }
            return this.expressionHashCode;
        }

        @Override
        public boolean isEnabledFor(Object object) {
            return this.child.isEnabledFor(object);
        }

        @Override
        public boolean isEnabledForExpression(Object object, String string) {
            return this.child.isEnabledForExpression(object, string);
        }

        @Override
        public Collection valuesForExpression(String string) {
            return this.child.valuesForExpression(string);
        }
    }

    private static class SystemPropertyExpression
    extends AbstractExpression {
        private String name;
        private String value;

        public SystemPropertyExpression(IConfigurationElement iConfigurationElement) throws IllegalStateException {
            this.name = iConfigurationElement.getAttribute(ActionExpression.ATT_NAME);
            this.value = iConfigurationElement.getAttribute(ActionExpression.ATT_VALUE);
            if (this.name == null || this.value == null) {
                throw new IllegalStateException("System property expression missing attribute");
            }
        }

        @Override
        public boolean isEnabledFor(Object object) {
            String string = System.getProperty(this.name);
            if (string == null) {
                return false;
            }
            return this.value.equals(string);
        }

        public final boolean equals(Object object) {
            if (object instanceof SystemPropertyExpression) {
                SystemPropertyExpression systemPropertyExpression = (SystemPropertyExpression)object;
                return Util.equals(this.name, systemPropertyExpression.name) && Util.equals(this.value, systemPropertyExpression.value);
            }
            return false;
        }

        public final int hashCode() {
            if (this.expressionHashCode == -1) {
                this.expressionHashCode = HASH_INITIAL * 89 + Util.hashCode(this.name);
                this.expressionHashCode = this.expressionHashCode * 89 + Util.hashCode(this.value);
                if (this.expressionHashCode == -1) {
                    ++this.expressionHashCode;
                }
            }
            return this.expressionHashCode;
        }
    }
}

