/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.EditorPluginAction;
import org.eclipse.ui.internal.ObjectPluginAction;
import org.eclipse.ui.internal.PluginAction;
import org.eclipse.ui.internal.ViewPluginAction;
import org.eclipse.ui.internal.WWinPluginAction;
import org.eclipse.ui.internal.WWinPluginPulldown;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ActionDescriptor
implements IPluginContribution {
    private PluginAction action;
    private String toolbarId;
    private String menuPath;
    private String id;
    private String pluginId;
    private String menuGroup;
    private String toolbarGroupId;
    private int mode = 0;
    public static final int T_POPUP = 1;
    public static final int T_VIEW = 2;
    public static final int T_WORKBENCH = 3;
    public static final int T_EDITOR = 4;
    public static final int T_WORKBENCH_PULLDOWN = 5;
    public static final String STYLE_PUSH = "push";
    public static final String STYLE_RADIO = "radio";
    public static final String STYLE_TOGGLE = "toggle";
    public static final String STYLE_PULLDOWN = "pulldown";

    public ActionDescriptor(IConfigurationElement iConfigurationElement, int n) {
        this(iConfigurationElement, n, null);
    }

    public ActionDescriptor(IConfigurationElement iConfigurationElement, int n, Object object) {
        String string;
        int n2;
        this.id = iConfigurationElement.getAttribute("id");
        this.pluginId = iConfigurationElement.getNamespace();
        String string2 = iConfigurationElement.getAttribute("label");
        String string3 = iConfigurationElement.getAttribute("tooltip");
        String string4 = iConfigurationElement.getAttribute("helpContextId");
        String string5 = iConfigurationElement.getAttribute("menubarPath");
        String string6 = iConfigurationElement.getAttribute("toolbarPath");
        String string7 = iConfigurationElement.getAttribute("style");
        String string8 = iConfigurationElement.getAttribute("icon");
        String string9 = iConfigurationElement.getAttribute("hoverIcon");
        String string10 = iConfigurationElement.getAttribute("disabledIcon");
        String string11 = iConfigurationElement.getAttribute("description");
        String string12 = iConfigurationElement.getAttribute("accelerator");
        if ("FORCE_TEXT".equals(iConfigurationElement.getAttribute("mode"))) {
            this.mode = ActionContributionItem.MODE_FORCE_TEXT;
        }
        if (string2 == null) {
            WorkbenchPlugin.log("Invalid action declaration (label == null): " + this.id);
            string2 = WorkbenchMessages.ActionDescriptor_invalidLabel;
        }
        String string13 = null;
        String string14 = null;
        if (string5 != null) {
            n2 = string5.lastIndexOf(47);
            if (n2 != -1) {
                string13 = string5.substring(n2 + 1);
                string5 = string5.substring(0, n2);
            } else {
                string13 = string5;
                string5 = null;
            }
        }
        if (n == 1 && string13 == null) {
            string13 = "additions";
        }
        if (string6 != null) {
            n2 = string6.lastIndexOf(47);
            if (n2 != -1) {
                string14 = string6.substring(n2 + 1);
                string6 = string6.substring(0, n2);
            } else {
                string14 = string6;
                string6 = null;
            }
        }
        this.menuPath = string5;
        this.menuGroup = string13;
        if (string6 != null && string6.equals("Normal")) {
            string6 = "";
        }
        this.toolbarId = string6;
        this.toolbarGroupId = string14;
        this.action = this.createAction(n, iConfigurationElement, object, string7);
        if (this.action.getText() == null) {
            this.action.setText(string2);
        }
        if (this.action.getToolTipText() == null && string3 != null) {
            this.action.setToolTipText(string3);
        }
        if (string4 != null) {
            String string15 = string4;
            if (string4.indexOf(".") == -1) {
                string15 = String.valueOf(iConfigurationElement.getNamespace()) + "." + string4;
            }
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.action, string15);
        }
        if (string11 != null) {
            this.action.setDescription(string11);
        }
        if (string7 != null) {
            string = iConfigurationElement.getAttribute("state");
            if (string != null && (string7.equals(STYLE_RADIO) || string7.equals(STYLE_TOGGLE))) {
                this.action.setChecked(string.equals("true"));
            }
        } else {
            string = iConfigurationElement.getAttribute("state");
            if (string != null) {
                this.action.setChecked(string.equals("true"));
            }
        }
        string = iConfigurationElement.getDeclaringExtension().getNamespace();
        if (string8 != null) {
            this.action.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin(string, string8));
        }
        if (string9 != null) {
            this.action.setHoverImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin(string, string9));
        }
        if (string10 != null) {
            this.action.setDisabledImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin(string, string10));
        }
        if (string12 != null) {
            this.processAccelerator((IAction)this.action, string12);
        }
    }

    private PluginAction createAction(int n, IConfigurationElement iConfigurationElement, Object object, String string) {
        int n2 = 0;
        if (string != null) {
            if (string.equals(STYLE_RADIO)) {
                n2 = 8;
            } else if (string.equals(STYLE_TOGGLE)) {
                n2 = 2;
            } else if (string.equals(STYLE_PULLDOWN)) {
                n2 = 4;
            } else if (string.equals(STYLE_PUSH)) {
                n2 = 1;
            }
        }
        switch (n) {
            case 2: {
                return new ViewPluginAction(iConfigurationElement, (IViewPart)object, this.id, n2);
            }
            case 4: {
                return new EditorPluginAction(iConfigurationElement, (IEditorPart)object, this.id, n2);
            }
            case 3: {
                return new WWinPluginAction(iConfigurationElement, (IWorkbenchWindow)object, this.id, n2);
            }
            case 5: {
                n2 = 4;
                return new WWinPluginPulldown(iConfigurationElement, (IWorkbenchWindow)object, this.id, n2);
            }
            case 1: {
                return new ObjectPluginAction(iConfigurationElement, this.id, n2);
            }
        }
        WorkbenchPlugin.log("Unknown Action Type: " + n);
        return null;
    }

    public PluginAction getAction() {
        return this.action;
    }

    public String getId() {
        return this.id;
    }

    public String getMenuGroup() {
        return this.menuGroup;
    }

    public String getMenuPath() {
        return this.menuPath;
    }

    public String getToolbarGroupId() {
        return this.toolbarGroupId;
    }

    public String getToolbarId() {
        return this.toolbarId;
    }

    public String toString() {
        return "ActionDescriptor(" + this.id + ")";
    }

    private void processAccelerator(IAction iAction, String string) {
        if (string.length() == 0) {
            return;
        }
        if (Character.isDigit(string.charAt(0))) {
            try {
                iAction.setAccelerator(Integer.valueOf(string).intValue());
            }
            catch (NumberFormatException numberFormatException) {
                WorkbenchPlugin.log("Invalid accelerator declaration for action: " + this.id, numberFormatException);
            }
        } else {
            iAction.setAccelerator(Action.convertAccelerator((String)string));
        }
    }

    @Override
    public String getLocalId() {
        return this.getId();
    }

    @Override
    public String getPluginId() {
        return this.pluginId;
    }

    public int getMode() {
        return this.mode;
    }
}

