/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetElementAdapter;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.IWorkingSetUpdater;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.dialogs.IWorkingSetEditWizard;
import org.eclipse.ui.dialogs.IWorkingSetNewWizard;
import org.eclipse.ui.dialogs.IWorkingSetPage;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.internal.AbstractWorkingSet;
import org.eclipse.ui.internal.AggregateWorkingSet;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkingSet;
import org.eclipse.ui.internal.WorkingSetComparator;
import org.eclipse.ui.internal.dialogs.WorkingSetEditWizard;
import org.eclipse.ui.internal.dialogs.WorkingSetNewWizard;
import org.eclipse.ui.internal.dialogs.WorkingSetSelectionDialog;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.registry.WorkingSetDescriptor;
import org.eclipse.ui.internal.registry.WorkingSetRegistry;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public abstract class AbstractWorkingSetManager
extends EventManager
implements IWorkingSetManager,
BundleListener,
IExtensionChangeHandler {
    private SortedSet workingSets = new TreeSet(new Comparator(){

        public int compare(Object object, Object object2) {
            return ((AbstractWorkingSet)object).getUniqueId().compareTo(((AbstractWorkingSet)object2).getUniqueId());
        }
    });
    private List recentWorkingSets = new ArrayList();
    private BundleContext bundleContext;
    private Map updaters = new HashMap();
    private Map elementAdapters = new HashMap();
    private static final IWorkingSetUpdater NULL_UPDATER = new IWorkingSetUpdater(){

        @Override
        public void add(IWorkingSet iWorkingSet) {
        }

        @Override
        public boolean remove(IWorkingSet iWorkingSet) {
            return true;
        }

        @Override
        public boolean contains(IWorkingSet iWorkingSet) {
            return true;
        }

        @Override
        public void dispose() {
        }
    };
    private static final IWorkingSetElementAdapter IDENTITY_ADAPTER = new IWorkingSetElementAdapter(){

        @Override
        public IAdaptable[] adaptElements(IWorkingSet iWorkingSet, IAdaptable[] iAdaptableArray) {
            return iAdaptableArray;
        }

        @Override
        public void dispose() {
        }
    };

    private static WorkingSetDescriptor[] getSupportedEditableDescriptors(String[] stringArray) {
        WorkingSetRegistry workingSetRegistry = WorkbenchPlugin.getDefault().getWorkingSetRegistry();
        if (stringArray == null) {
            return workingSetRegistry.getNewPageWorkingSetDescriptors();
        }
        ArrayList<WorkingSetDescriptor> arrayList = new ArrayList<WorkingSetDescriptor>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            WorkingSetDescriptor workingSetDescriptor = workingSetRegistry.getWorkingSetDescriptor(stringArray[n]);
            if (workingSetDescriptor != null && workingSetDescriptor.isEditable()) {
                arrayList.add(workingSetDescriptor);
            }
            ++n;
        }
        return arrayList.toArray(new WorkingSetDescriptor[arrayList.size()]);
    }

    protected AbstractWorkingSetManager(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.bundleContext.addBundleListener((BundleListener)this);
        PlatformUI.getWorkbench().getExtensionTracker().registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)this.getExtensionPointFilter()));
    }

    private IExtensionPoint getExtensionPointFilter() {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "workingSets");
    }

    @Override
    public void dispose() {
        this.bundleContext.removeBundleListener((BundleListener)this);
        final Iterator iterator = this.updaters.values().iterator();
        while (iterator.hasNext()) {
            SafeRunner.run((ISafeRunnable)new WorkingSetRunnable(){

                public void run() throws Exception {
                    ((IWorkingSetUpdater)iterator.next()).dispose();
                }
            });
        }
        iterator = this.elementAdapters.values().iterator();
        while (iterator.hasNext()) {
            SafeRunner.run((ISafeRunnable)new WorkingSetRunnable(){

                public void run() throws Exception {
                    ((IWorkingSetElementAdapter)iterator.next()).dispose();
                }
            });
        }
    }

    @Override
    public IWorkingSet createWorkingSet(String string, IAdaptable[] iAdaptableArray) {
        return new WorkingSet(string, string, iAdaptableArray);
    }

    @Override
    public IWorkingSet createAggregateWorkingSet(String string, String string2, IWorkingSet[] iWorkingSetArray) {
        return new AggregateWorkingSet(string, string2, iWorkingSetArray);
    }

    @Override
    public IWorkingSet createWorkingSet(IMemento iMemento) {
        return this.restoreWorkingSet(iMemento);
    }

    @Override
    public void addWorkingSet(IWorkingSet iWorkingSet) {
        IWorkingSet iWorkingSet2 = this.getWorkingSet(iWorkingSet.getName());
        Assert.isTrue((iWorkingSet2 == null ? 1 : 0) != 0, (String)"working set with same name already registered");
        this.internalAddWorkingSet(iWorkingSet);
    }

    private void internalAddWorkingSet(IWorkingSet iWorkingSet) {
        this.workingSets.add(iWorkingSet);
        ((AbstractWorkingSet)iWorkingSet).connect(this);
        this.addToUpdater(iWorkingSet);
        this.firePropertyChange("workingSetAdd", null, iWorkingSet);
    }

    protected boolean internalRemoveWorkingSet(IWorkingSet iWorkingSet) {
        boolean bl = this.workingSets.remove(iWorkingSet);
        boolean bl2 = this.recentWorkingSets.remove(iWorkingSet);
        if (bl) {
            ((AbstractWorkingSet)iWorkingSet).disconnect();
            this.removeFromUpdater(iWorkingSet);
            this.firePropertyChange("workingSetRemove", iWorkingSet, null);
        }
        return bl || bl2;
    }

    @Override
    public IWorkingSet[] getWorkingSets() {
        TreeSet<IWorkingSet> treeSet = new TreeSet<IWorkingSet>(WorkingSetComparator.getInstance());
        for (IWorkingSet iWorkingSet : this.workingSets) {
            if (!iWorkingSet.isVisible()) continue;
            treeSet.add(iWorkingSet);
        }
        return treeSet.toArray(new IWorkingSet[treeSet.size()]);
    }

    @Override
    public IWorkingSet[] getAllWorkingSets() {
        IWorkingSet[] iWorkingSetArray = this.workingSets.toArray(new IWorkingSet[this.workingSets.size()]);
        Arrays.sort(iWorkingSetArray, WorkingSetComparator.getInstance());
        return iWorkingSetArray;
    }

    @Override
    public IWorkingSet getWorkingSet(String string) {
        if (string == null || this.workingSets == null) {
            return null;
        }
        for (IWorkingSet iWorkingSet : this.workingSets) {
            if (!string.equals(iWorkingSet.getName())) continue;
            return iWorkingSet;
        }
        return null;
    }

    @Override
    public IWorkingSet[] getRecentWorkingSets() {
        return this.recentWorkingSets.toArray(new IWorkingSet[this.recentWorkingSets.size()]);
    }

    protected void internalAddRecentWorkingSet(IWorkingSet iWorkingSet) {
        if (!iWorkingSet.isVisible()) {
            return;
        }
        this.recentWorkingSets.remove(iWorkingSet);
        this.recentWorkingSets.add(0, iWorkingSet);
        this.sizeRecentWorkingSets();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!this.getClass().getName().equals(object.getClass().getName())) {
            return false;
        }
        AbstractWorkingSetManager abstractWorkingSetManager = (AbstractWorkingSetManager)object;
        return abstractWorkingSetManager.workingSets.equals(this.workingSets);
    }

    public int hashCode() {
        return this.workingSets.hashCode();
    }

    @Override
    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.addListenerObject(iPropertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.removeListenerObject(iPropertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        final Object[] objectArray = this.getListeners();
        if (objectArray.length == 0) {
            return;
        }
        final PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, string, object, object2);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int n = 0;
                while (n < objectArray.length) {
                    final IPropertyChangeListener iPropertyChangeListener = (IPropertyChangeListener)objectArray[n];
                    ISafeRunnable iSafeRunnable = new ISafeRunnable(){

                        public void run() throws Exception {
                            iPropertyChangeListener.propertyChange(propertyChangeEvent);
                        }

                        public void handleException(Throwable throwable) {
                        }
                    };
                    SafeRunner.run((ISafeRunnable)iSafeRunnable);
                    ++n;
                }
            }
        };
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            Display.getDefault().asyncExec(runnable);
        }
    }

    public void workingSetChanged(IWorkingSet iWorkingSet, String string, Object object) {
        this.firePropertyChange(string, object, iWorkingSet);
    }

    public void saveWorkingSetState(IMemento iMemento) {
        Iterator iterator = this.workingSets.iterator();
        ArrayList<IWorkingSet> arrayList = new ArrayList<IWorkingSet>();
        ArrayList<IWorkingSet> arrayList2 = new ArrayList<IWorkingSet>();
        while (iterator.hasNext()) {
            IWorkingSet iWorkingSet = (IWorkingSet)iterator.next();
            if (iWorkingSet instanceof AggregateWorkingSet) {
                arrayList2.add(iWorkingSet);
                continue;
            }
            arrayList.add(iWorkingSet);
        }
        this.saveWorkingSetState(iMemento, arrayList);
        this.saveWorkingSetState(iMemento, arrayList2);
    }

    private void saveWorkingSetState(final IMemento iMemento, List list) {
        for (final IWorkingSet iWorkingSet : list) {
            SafeRunner.run((ISafeRunnable)new WorkingSetRunnable(){

                public void run() throws Exception {
                    XMLMemento xMLMemento = XMLMemento.createWriteRoot("workingSet");
                    xMLMemento.putString("factoryID", iWorkingSet.getFactoryId());
                    iWorkingSet.saveState(xMLMemento);
                    IMemento iMemento2 = iMemento.createChild("workingSet");
                    iMemento2.putMemento(xMLMemento);
                }
            });
        }
    }

    protected void restoreWorkingSetState(IMemento iMemento) {
        IMemento[] iMementoArray = iMemento.getChildren("workingSet");
        int n = 0;
        while (n < iMementoArray.length) {
            IWorkingSet iWorkingSet = this.restoreWorkingSet(iMementoArray[n]);
            if (iWorkingSet != null) {
                this.workingSets.add(iWorkingSet);
            }
            ++n;
        }
        IWorkingSet[] iWorkingSetArray = this.getAllWorkingSets();
        int n2 = 0;
        while (n2 < iWorkingSetArray.length) {
            ((AbstractWorkingSet)iWorkingSetArray[n2]).connect(this);
            ++n2;
        }
        n2 = 0;
        while (n2 < iWorkingSetArray.length) {
            this.addToUpdater(iWorkingSetArray[n2]);
            ++n2;
        }
        n2 = 0;
        while (n2 < iWorkingSetArray.length) {
            this.firePropertyChange("workingSetAdd", null, iWorkingSetArray[n2]);
            ++n2;
        }
    }

    protected IWorkingSet restoreWorkingSet(final IMemento iMemento) {
        IElementFactory iElementFactory;
        String string = iMemento.getString("factoryID");
        if (string == null) {
            string = "org.eclipse.ui.internal.WorkingSetFactory";
        }
        if ((iElementFactory = PlatformUI.getWorkbench().getElementFactory(string)) == null) {
            WorkbenchPlugin.log("Unable to restore working set - cannot instantiate factory: " + string);
            return null;
        }
        final IAdaptable[] iAdaptableArray = new IAdaptable[1];
        SafeRunner.run((ISafeRunnable)new WorkingSetRunnable(){

            public void run() throws Exception {
                iAdaptableArray[0] = iElementFactory.createElement(iMemento);
            }
        });
        if (iAdaptableArray[0] == null) {
            WorkbenchPlugin.log("Unable to restore working set - cannot instantiate working set: " + string);
            return null;
        }
        if (!(iAdaptableArray[0] instanceof IWorkingSet)) {
            WorkbenchPlugin.log("Unable to restore working set - element is not an IWorkingSet: " + string);
            return null;
        }
        return (IWorkingSet)iAdaptableArray[0];
    }

    protected void saveMruList(IMemento iMemento) {
        for (IWorkingSet iWorkingSet : this.recentWorkingSets) {
            IMemento iMemento2 = iMemento.createChild("mruList");
            iMemento2.putString("name", iWorkingSet.getName());
        }
    }

    protected void restoreMruList(IMemento iMemento) {
        IMemento[] iMementoArray = iMemento.getChildren("mruList");
        int n = iMementoArray.length - 1;
        while (n >= 0) {
            IWorkingSet iWorkingSet;
            String string = iMementoArray[n].getString("name");
            if (string != null && (iWorkingSet = this.getWorkingSet(string)) != null) {
                this.internalAddRecentWorkingSet(iWorkingSet);
            }
            --n;
        }
    }

    @Override
    public IWorkingSetEditWizard createWorkingSetEditWizard(IWorkingSet iWorkingSet) {
        String string = iWorkingSet.getId();
        WorkingSetRegistry workingSetRegistry = WorkbenchPlugin.getDefault().getWorkingSetRegistry();
        IWorkingSetPage iWorkingSetPage = null;
        if (string != null) {
            iWorkingSetPage = workingSetRegistry.getWorkingSetPage(string);
        }
        if (iWorkingSetPage == null && (iWorkingSetPage = workingSetRegistry.getDefaultWorkingSetPage()) == null) {
            return null;
        }
        WorkingSetEditWizard workingSetEditWizard = new WorkingSetEditWizard(iWorkingSetPage);
        workingSetEditWizard.setSelection(iWorkingSet);
        return workingSetEditWizard;
    }

    @Override
    public IWorkingSetSelectionDialog createWorkingSetSelectionDialog(Shell shell) {
        return this.createWorkingSetSelectionDialog(shell, true);
    }

    @Override
    public IWorkingSetSelectionDialog createWorkingSetSelectionDialog(Shell shell, boolean bl) {
        return this.createWorkingSetSelectionDialog(shell, bl, null);
    }

    @Override
    public IWorkingSetNewWizard createWorkingSetNewWizard(String[] stringArray) {
        WorkingSetDescriptor[] workingSetDescriptorArray = AbstractWorkingSetManager.getSupportedEditableDescriptors(stringArray);
        if (workingSetDescriptorArray.length == 0) {
            return null;
        }
        return new WorkingSetNewWizard(workingSetDescriptorArray);
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        String string = bundleEvent.getBundle().getSymbolicName();
        if (string == null) {
            return;
        }
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        if (bundleEvent.getBundle().getState() == 32) {
            final WorkingSetDescriptor[] workingSetDescriptorArray = WorkbenchPlugin.getDefault().getWorkingSetRegistry().getUpdaterDescriptorsForNamespace(string);
            WorkbenchJob workbenchJob = new WorkbenchJob(NLS.bind((String)WorkbenchMessages.AbstractWorkingSetManager_updatersActivating, (Object)string)){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                    Map map = AbstractWorkingSetManager.this.updaters;
                    synchronized (map) {
                        int n = 0;
                        while (n < workingSetDescriptorArray.length) {
                            WorkingSetDescriptor workingSetDescriptor = workingSetDescriptorArray[n];
                            List list = AbstractWorkingSetManager.this.getWorkingSetsForId(workingSetDescriptor.getId());
                            if (list.size() != 0) {
                                final IWorkingSetUpdater iWorkingSetUpdater = AbstractWorkingSetManager.this.getUpdater(workingSetDescriptor);
                                for (final IWorkingSet iWorkingSet : list) {
                                    SafeRunner.run((ISafeRunnable)new WorkingSetRunnable(){

                                        public void run() throws Exception {
                                            if (!iWorkingSetUpdater.contains(iWorkingSet)) {
                                                iWorkingSetUpdater.add(iWorkingSet);
                                            }
                                        }
                                    });
                                }
                            }
                            ++n;
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            workbenchJob.setSystem(true);
            workbenchJob.schedule();
        }
    }

    private List getWorkingSetsForId(String string) {
        ArrayList<IWorkingSet> arrayList = new ArrayList<IWorkingSet>();
        for (IWorkingSet iWorkingSet : this.workingSets) {
            if (!string.equals(iWorkingSet.getId())) continue;
            arrayList.add(iWorkingSet);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToUpdater(final IWorkingSet iWorkingSet) {
        WorkingSetDescriptor workingSetDescriptor = WorkbenchPlugin.getDefault().getWorkingSetRegistry().getWorkingSetDescriptor(iWorkingSet.getId());
        if (workingSetDescriptor == null || !workingSetDescriptor.isUpdaterClassLoaded()) {
            return;
        }
        Map map = this.updaters;
        synchronized (map) {
            final IWorkingSetUpdater iWorkingSetUpdater = this.getUpdater(workingSetDescriptor);
            SafeRunner.run((ISafeRunnable)new WorkingSetRunnable(){

                public void run() throws Exception {
                    if (!iWorkingSetUpdater.contains(iWorkingSet)) {
                        iWorkingSetUpdater.add(iWorkingSet);
                    }
                }
            });
        }
    }

    private IWorkingSetUpdater getUpdater(WorkingSetDescriptor workingSetDescriptor) {
        IWorkingSetUpdater iWorkingSetUpdater = (IWorkingSetUpdater)this.updaters.get(workingSetDescriptor.getId());
        if (iWorkingSetUpdater == null) {
            iWorkingSetUpdater = workingSetDescriptor.createWorkingSetUpdater();
            if (iWorkingSetUpdater == null) {
                iWorkingSetUpdater = NULL_UPDATER;
            } else {
                this.firePropertyChange("workingSetUpdaterInstalled", null, iWorkingSetUpdater);
                PlatformUI.getWorkbench().getExtensionTracker().registerObject(workingSetDescriptor.getConfigurationElement().getDeclaringExtension(), (Object)iWorkingSetUpdater, 2);
            }
            this.updaters.put(workingSetDescriptor.getId(), iWorkingSetUpdater);
        }
        return iWorkingSetUpdater;
    }

    IWorkingSetElementAdapter getElementAdapter(WorkingSetDescriptor workingSetDescriptor) {
        IWorkingSetElementAdapter iWorkingSetElementAdapter = (IWorkingSetElementAdapter)this.elementAdapters.get(workingSetDescriptor.getId());
        if (iWorkingSetElementAdapter == null) {
            iWorkingSetElementAdapter = workingSetDescriptor.createWorkingSetElementAdapter();
            if (iWorkingSetElementAdapter == null) {
                iWorkingSetElementAdapter = IDENTITY_ADAPTER;
            } else {
                this.elementAdapters.put(workingSetDescriptor.getId(), iWorkingSetElementAdapter);
            }
        }
        return iWorkingSetElementAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromUpdater(final IWorkingSet iWorkingSet) {
        Map map = this.updaters;
        synchronized (map) {
            final IWorkingSetUpdater iWorkingSetUpdater = (IWorkingSetUpdater)this.updaters.get(iWorkingSet.getId());
            if (iWorkingSetUpdater != null) {
                SafeRunner.run((ISafeRunnable)new WorkingSetRunnable(){

                    public void run() throws Exception {
                        iWorkingSetUpdater.remove(iWorkingSet);
                    }
                });
            }
        }
    }

    @Override
    public IWorkingSetSelectionDialog createWorkingSetSelectionDialog(Shell shell, boolean bl, String[] stringArray) {
        return new WorkingSetSelectionDialog(shell, bl, stringArray);
    }

    public void saveState(File file) throws IOException {
        XMLMemento xMLMemento = XMLMemento.createWriteRoot("workingSetManager");
        this.saveWorkingSetState(xMLMemento);
        this.saveMruList(xMLMemento);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "utf-8");
        xMLMemento.save(outputStreamWriter);
        outputStreamWriter.close();
    }

    public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
    }

    public void removeExtension(IExtension iExtension, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object instanceof IWorkingSetUpdater) {
                this.removeUpdater((IWorkingSetUpdater)object);
            }
            if (object instanceof IWorkingSetElementAdapter) {
                this.removeElementAdapter((IWorkingSetElementAdapter)object);
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeElementAdapter(final IWorkingSetElementAdapter iWorkingSetElementAdapter) {
        SafeRunner.run((ISafeRunnable)new WorkingSetRunnable(){

            public void run() throws Exception {
                iWorkingSetElementAdapter.dispose();
            }
        });
        Map map = this.elementAdapters;
        synchronized (map) {
            this.elementAdapters.values().remove(iWorkingSetElementAdapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUpdater(final IWorkingSetUpdater iWorkingSetUpdater) {
        SafeRunner.run((ISafeRunnable)new WorkingSetRunnable(){

            public void run() throws Exception {
                iWorkingSetUpdater.dispose();
            }
        });
        Map map = this.updaters;
        synchronized (map) {
            this.updaters.values().remove(iWorkingSetUpdater);
        }
        this.firePropertyChange("workingSetUpdaterUninstalled", iWorkingSetUpdater, null);
    }

    @Override
    public void addToWorkingSets(final IAdaptable iAdaptable, IWorkingSet[] iWorkingSetArray) {
        int n = 0;
        while (n < iWorkingSetArray.length) {
            final IWorkingSet iWorkingSet = iWorkingSetArray[n];
            SafeRunner.run((ISafeRunnable)new WorkingSetRunnable(){

                public void run() throws Exception {
                    IAdaptable[] iAdaptableArray = iWorkingSet.adaptElements(new IAdaptable[]{iAdaptable});
                    if (iAdaptableArray.length == 1) {
                        IAdaptable[] iAdaptableArray2 = iWorkingSet.getElements();
                        IAdaptable[] iAdaptableArray3 = new IAdaptable[iAdaptableArray2.length + 1];
                        System.arraycopy(iAdaptableArray2, 0, iAdaptableArray3, 0, iAdaptableArray2.length);
                        iAdaptableArray3[iAdaptableArray3.length - 1] = iAdaptableArray[0];
                        iWorkingSet.setElements(iAdaptableArray3);
                    }
                }
            });
            ++n;
        }
    }

    @Override
    public void setRecentWorkingSetsLength(int n) {
        if (n < 1 || n > 99) {
            throw new IllegalArgumentException("Invalid recent working sets length: " + n);
        }
        IPreferenceStore iPreferenceStore = PrefUtil.getAPIPreferenceStore();
        iPreferenceStore.setValue("RECENTLY_USED_WORKINGSETS_SIZE", n);
        this.sizeRecentWorkingSets();
    }

    private void sizeRecentWorkingSets() {
        int n = this.getRecentWorkingSetsLength();
        while (this.recentWorkingSets.size() > n) {
            int n2 = this.recentWorkingSets.size() - 1;
            this.recentWorkingSets.remove(n2);
        }
    }

    @Override
    public int getRecentWorkingSetsLength() {
        IPreferenceStore iPreferenceStore = PrefUtil.getAPIPreferenceStore();
        return iPreferenceStore.getInt("RECENTLY_USED_WORKINGSETS_SIZE");
    }

    static abstract class WorkingSetRunnable
    implements ISafeRunnable {
        WorkingSetRunnable() {
        }

        public void handleException(Throwable throwable) {
            StatusManager.getManager().handle(StatusUtil.newStatus("org.eclipse.ui", throwable));
        }
    }
}

