/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.internal.AbstractWorkingSetManager;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.util.Util;

public abstract class AbstractWorkingSet
implements IAdaptable,
IWorkingSet {
    protected static final String FACTORY_ID = "org.eclipse.ui.internal.WorkingSetFactory";
    static final String TAG_AGGREGATE = "aggregate";
    private String name;
    protected ArrayList elements;
    private IWorkingSetManager manager;
    protected IMemento workingSetMemento;
    private String label;
    private String uniqueId;
    private static int counter;
    private boolean labelBoundToName;

    public AbstractWorkingSet(String string, String string2) {
        Assert.isNotNull((Object)string, (String)"name must not be null");
        this.name = string;
        this.label = string2;
        this.labelBoundToName = Util.equals(string, string2);
        this.uniqueId = String.valueOf(Long.toString(System.currentTimeMillis())) + "_" + counter++;
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IWorkingSet.class || clazz == IPersistableElement.class) {
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, clazz);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        IWorkingSet iWorkingSet;
        Assert.isNotNull((Object)string, (String)"Working set name must not be null");
        if (this.manager != null && (iWorkingSet = this.manager.getWorkingSet(string)) != this) {
            Assert.isTrue((iWorkingSet == null ? 1 : 0) != 0, (String)"working set with same name already registered");
        }
        this.name = string;
        this.fireWorkingSetChanged("workingSetNameChange", null);
        if (this.labelBoundToName) {
            this.setLabel(string);
        }
    }

    public void connect(IWorkingSetManager iWorkingSetManager) {
        Assert.isTrue((this.manager == null ? 1 : 0) != 0, (String)"A working set can only be connected to one manager");
        this.manager = iWorkingSetManager;
    }

    public void disconnect() {
        this.manager = null;
    }

    protected void fireWorkingSetChanged(String string, Object object) {
        AbstractWorkingSetManager abstractWorkingSetManager = this.manager != null ? (AbstractWorkingSetManager)this.manager : (AbstractWorkingSetManager)WorkbenchPlugin.getDefault().getWorkingSetManager();
        abstractWorkingSetManager.workingSetChanged(this, string, object);
    }

    protected void internalSetElements(IAdaptable[] iAdaptableArray) {
        Assert.isNotNull((Object)iAdaptableArray, (String)"Working set elements array must not be null");
        this.elements = new ArrayList(iAdaptableArray.length);
        int n = 0;
        while (n < iAdaptableArray.length) {
            this.elements.add(iAdaptableArray[n]);
            ++n;
        }
    }

    @Override
    public IAdaptable[] getElements() {
        ArrayList arrayList = this.getElementsArray();
        return arrayList.toArray(new IAdaptable[arrayList.size()]);
    }

    protected ArrayList getElementsArray() {
        if (this.elements == null) {
            this.restoreWorkingSet();
            this.workingSetMemento = null;
        }
        return this.elements;
    }

    abstract void restoreWorkingSet();

    protected IWorkingSetManager getManager() {
        return this.manager;
    }

    @Override
    public String getFactoryId() {
        return FACTORY_ID;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String string) {
        this.label = string == null ? this.getName() : string;
        this.labelBoundToName = Util.equals(string, this.name);
        this.fireWorkingSetChanged("workingSetLabelChange", null);
    }

    @Override
    public boolean isEmpty() {
        return this.getElementsArray().isEmpty();
    }

    @Override
    public final ImageDescriptor getImage() {
        return this.getImageDescriptor();
    }

    String getUniqueId() {
        return this.uniqueId;
    }

    void setUniqueId(String string) {
        this.uniqueId = string;
    }
}

