/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.Hashtable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.AbstractPartSelectionTracker;
import org.eclipse.ui.internal.WorkbenchPlugin;

public abstract class AbstractSelectionService
implements ISelectionService {
    private ListenerList listeners = new ListenerList();
    private ListenerList postListeners = new ListenerList();
    private IWorkbenchPart activePart;
    private ISelectionProvider activeProvider;
    private Hashtable perPartTrackers;
    private ISelectionChangedListener selListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            AbstractSelectionService.this.fireSelection(AbstractSelectionService.this.activePart, selectionChangedEvent.getSelection());
        }
    };
    private ISelectionChangedListener postSelListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            AbstractSelectionService.this.firePostSelection(AbstractSelectionService.this.activePart, selectionChangedEvent.getSelection());
        }
    };

    protected AbstractSelectionService() {
    }

    @Override
    public void addSelectionListener(ISelectionListener iSelectionListener) {
        this.listeners.add((Object)iSelectionListener);
    }

    @Override
    public void addSelectionListener(String string, ISelectionListener iSelectionListener) {
        this.getPerPartTracker(string).addSelectionListener(iSelectionListener);
    }

    @Override
    public void addPostSelectionListener(ISelectionListener iSelectionListener) {
        this.postListeners.add((Object)iSelectionListener);
    }

    @Override
    public void addPostSelectionListener(String string, ISelectionListener iSelectionListener) {
        this.getPerPartTracker(string).addPostSelectionListener(iSelectionListener);
    }

    @Override
    public void removeSelectionListener(ISelectionListener iSelectionListener) {
        this.listeners.remove((Object)iSelectionListener);
    }

    @Override
    public void removePostSelectionListener(String string, ISelectionListener iSelectionListener) {
        this.getPerPartTracker(string).removePostSelectionListener(iSelectionListener);
    }

    @Override
    public void removePostSelectionListener(ISelectionListener iSelectionListener) {
        this.postListeners.remove((Object)iSelectionListener);
    }

    @Override
    public void removeSelectionListener(String string, ISelectionListener iSelectionListener) {
        this.getPerPartTracker(string).removeSelectionListener(iSelectionListener);
    }

    protected void fireSelection(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ISelectionListener iSelectionListener = (ISelectionListener)objectArray[n];
            if (iWorkbenchPart != null && iSelection != null || iSelectionListener instanceof INullSelectionListener) {
                try {
                    iSelectionListener.selectionChanged(iWorkbenchPart, iSelection);
                }
                catch (Exception exception) {
                    WorkbenchPlugin.log(exception);
                }
            }
            ++n;
        }
    }

    protected void firePostSelection(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        Object[] objectArray = this.postListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ISelectionListener iSelectionListener = (ISelectionListener)objectArray[n];
            if (iWorkbenchPart != null && iSelection != null || iSelectionListener instanceof INullSelectionListener) {
                try {
                    iSelectionListener.selectionChanged(iWorkbenchPart, iSelection);
                }
                catch (Exception exception) {
                    WorkbenchPlugin.log(exception);
                }
            }
            ++n;
        }
    }

    protected AbstractPartSelectionTracker getPerPartTracker(String string) {
        AbstractPartSelectionTracker abstractPartSelectionTracker;
        if (this.perPartTrackers == null) {
            this.perPartTrackers = new Hashtable(4);
        }
        if ((abstractPartSelectionTracker = (AbstractPartSelectionTracker)this.perPartTrackers.get(string)) == null) {
            abstractPartSelectionTracker = this.createPartTracker(string);
            this.perPartTrackers.put(string, abstractPartSelectionTracker);
        }
        return abstractPartSelectionTracker;
    }

    protected abstract AbstractPartSelectionTracker createPartTracker(String var1);

    @Override
    public ISelection getSelection() {
        if (this.activeProvider != null) {
            return this.activeProvider.getSelection();
        }
        return null;
    }

    @Override
    public ISelection getSelection(String string) {
        return this.getPerPartTracker(string).getSelection();
    }

    public void setActivePart(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart == this.activePart) {
            return;
        }
        ISelectionProvider iSelectionProvider = null;
        if (iWorkbenchPart != null && (iSelectionProvider = iWorkbenchPart.getSite().getSelectionProvider()) == null) {
            iWorkbenchPart = null;
        }
        if (iWorkbenchPart == this.activePart) {
            return;
        }
        if (this.activePart != null) {
            if (this.activeProvider != null) {
                this.activeProvider.removeSelectionChangedListener(this.selListener);
                if (this.activeProvider instanceof IPostSelectionProvider) {
                    ((IPostSelectionProvider)this.activeProvider).removePostSelectionChangedListener(this.postSelListener);
                } else {
                    this.activeProvider.removeSelectionChangedListener(this.postSelListener);
                }
                this.activeProvider = null;
            }
            this.activePart = null;
        }
        this.activePart = iWorkbenchPart;
        if (iWorkbenchPart != null) {
            this.activeProvider = iSelectionProvider;
            this.activeProvider.addSelectionChangedListener(this.selListener);
            ISelection iSelection = this.activeProvider.getSelection();
            this.fireSelection(iWorkbenchPart, iSelection);
            if (this.activeProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)this.activeProvider).addPostSelectionChangedListener(this.postSelListener);
            } else {
                this.activeProvider.addSelectionChangedListener(this.postSelListener);
            }
            this.firePostSelection(iWorkbenchPart, iSelection);
        } else {
            this.fireSelection(null, null);
            this.firePostSelection(null, null);
        }
    }
}

