/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractPartSelectionTracker {
    private ListenerList fListeners = new ListenerList();
    private ListenerList postListeners = new ListenerList();
    private String fPartId;

    public AbstractPartSelectionTracker(String string) {
        this.setPartId(string);
    }

    public void addSelectionListener(ISelectionListener iSelectionListener) {
        this.fListeners.add((Object)iSelectionListener);
    }

    public void addPostSelectionListener(ISelectionListener iSelectionListener) {
        this.postListeners.add((Object)iSelectionListener);
    }

    public abstract ISelection getSelection();

    public void removeSelectionListener(ISelectionListener iSelectionListener) {
        this.fListeners.remove((Object)iSelectionListener);
    }

    public void removePostSelectionListener(ISelectionListener iSelectionListener) {
        this.postListeners.remove((Object)iSelectionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ListenerList listenerList = this.fListeners;
        synchronized (listenerList) {
            Object[] objectArray = this.fListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                this.fListeners.remove(objectArray[n]);
                this.postListeners.remove(objectArray[n]);
                ++n;
            }
        }
    }

    protected void fireSelection(final IWorkbenchPart iWorkbenchPart, final ISelection iSelection) {
        Object[] objectArray = this.fListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final ISelectionListener iSelectionListener = (ISelectionListener)objectArray[n];
            if (iWorkbenchPart != null && iSelection != null || iSelectionListener instanceof INullSelectionListener) {
                Platform.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        iSelectionListener.selectionChanged(iWorkbenchPart, iSelection);
                    }
                });
            }
            ++n;
        }
    }

    protected void firePostSelection(final IWorkbenchPart iWorkbenchPart, final ISelection iSelection) {
        Object[] objectArray = this.postListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final ISelectionListener iSelectionListener = (ISelectionListener)objectArray[n];
            if (iWorkbenchPart != null && iSelection != null || iSelectionListener instanceof INullSelectionListener) {
                Platform.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        iSelectionListener.selectionChanged(iWorkbenchPart, iSelection);
                    }
                });
            }
            ++n;
        }
    }

    private void setPartId(String string) {
        this.fPartId = string;
    }

    protected String getPartId() {
        return this.fPartId;
    }
}

