/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.help;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.help.IContext;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.help.IContextComputer;
import org.eclipse.ui.help.WorkbenchHelp;

public class ViewContextComputer
implements IContextComputer {
    private IViewPart view;
    private ArrayList contextList;
    private Object context;

    public ViewContextComputer(IViewPart iViewPart, Object object) {
        Assert.isTrue((object instanceof String || object instanceof IContext ? 1 : 0) != 0);
        this.view = iViewPart;
        this.context = object;
    }

    private void addContexts(Object object, HelpEvent helpEvent) {
        Assert.isTrue((object instanceof Object[] || object instanceof IContextComputer || object instanceof String ? 1 : 0) != 0);
        if (object instanceof String) {
            this.contextList.add(object);
            return;
        }
        Object[] objectArray = object instanceof IContextComputer ? ((IContextComputer)object).getLocalContexts(helpEvent) : (Object[])object;
        int n = 0;
        while (n < objectArray.length) {
            this.contextList.add(objectArray[n]);
            ++n;
        }
    }

    private void addContextsForControl(Control control, HelpEvent helpEvent) {
        Object object = WorkbenchHelp.getHelp(control);
        if (object == null || object == this) {
            return;
        }
        this.addContexts(object, helpEvent);
    }

    @Override
    public Object[] computeContexts(HelpEvent helpEvent) {
        this.contextList = new ArrayList();
        this.contextList.add(this.context);
        this.addContextsForControl((Control)this.view.getSite().getShell(), helpEvent);
        return this.contextList.toArray();
    }

    @Override
    public Object[] getLocalContexts(HelpEvent helpEvent) {
        return new Object[]{this.context};
    }
}

