/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.handlers;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.FastViewBar;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.ShowViewDialog;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.views.IViewDescriptor;

public final class ShowViewHandler
extends AbstractHandler {
    private boolean makeFast = false;

    public ShowViewHandler() {
    }

    public ShowViewHandler(boolean bl) {
        this.makeFast = bl;
    }

    public final Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IWorkbenchWindow iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked(executionEvent);
        Map map = executionEvent.getParameters();
        Object v = map.get("org.eclipse.ui.views.showView.viewId");
        Object v2 = map.get("org.eclipse.ui.views.showView.secondaryId");
        this.makeFast = "true".equals(map.get("org.eclipse.ui.views.showView.makeFast"));
        if (v == null) {
            this.openOther(iWorkbenchWindow);
        } else {
            try {
                this.openView((String)v, (String)v2, iWorkbenchWindow);
            }
            catch (PartInitException partInitException) {
                throw new ExecutionException("Part could not be initialized", (Throwable)((Object)partInitException));
            }
        }
        return null;
    }

    private final void openOther(IWorkbenchWindow iWorkbenchWindow) {
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage == null) {
            return;
        }
        ShowViewDialog showViewDialog = new ShowViewDialog(iWorkbenchWindow, WorkbenchPlugin.getDefault().getViewRegistry());
        showViewDialog.open();
        if (showViewDialog.getReturnCode() == 1) {
            return;
        }
        IViewDescriptor[] iViewDescriptorArray = showViewDialog.getSelection();
        int n = 0;
        while (n < iViewDescriptorArray.length) {
            try {
                this.openView(iViewDescriptorArray[n].getId(), null, iWorkbenchWindow);
            }
            catch (PartInitException partInitException) {
                StatusUtil.handleStatus(partInitException.getStatus(), String.valueOf(WorkbenchMessages.ShowView_errorTitle) + ": " + partInitException.getMessage(), 2);
            }
            ++n;
        }
    }

    private final void openView(String string, String string2, IWorkbenchWindow iWorkbenchWindow) throws PartInitException {
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage == null) {
            return;
        }
        if (this.makeFast) {
            WorkbenchPage workbenchPage = (WorkbenchPage)iWorkbenchPage;
            Perspective perspective = workbenchPage.getActivePerspective();
            boolean bl = Perspective.useNewMinMax(perspective);
            if (bl) {
                IViewReference iViewReference = perspective.getViewReference(string, string2);
                if (iViewReference == null) {
                    return;
                }
                perspective.getFastViewManager().addViewReference(FastViewBar.FASTVIEWBAR_ID, -1, iViewReference, true);
                workbenchPage.activate(iViewReference.getPart(true));
                return;
            }
            IViewReference iViewReference = workbenchPage.findViewReference(string, string2);
            if (iViewReference == null) {
                IViewPart iViewPart = workbenchPage.showView(string, string2, 3);
                iViewReference = (IViewReference)workbenchPage.getReference(iViewPart);
            }
            if (!workbenchPage.isFastView(iViewReference)) {
                workbenchPage.addFastView(iViewReference);
            }
            workbenchPage.activate(iViewReference.getPart(true));
        } else {
            iWorkbenchPage.showView(string, string2, 1);
        }
    }
}

