/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.handlers;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.SelectPerspectiveDialog;

public final class ShowPerspectiveHandler
extends AbstractHandler {
    public final Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IWorkbenchWindow iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked(executionEvent);
        Map map = executionEvent.getParameters();
        Object v = map.get("org.eclipse.ui.perspectives.showPerspective.perspectiveId");
        String string = (String)map.get("org.eclipse.ui.perspectives.showPerspective.newWindow");
        if (v == null) {
            this.openOther(iWorkbenchWindow);
        } else if (string == null || string.equalsIgnoreCase("false")) {
            this.openPerspective((String)v, iWorkbenchWindow);
        } else {
            this.openNewWindowPerspective((String)v, iWorkbenchWindow);
        }
        return null;
    }

    private void openNewWindowPerspective(String string, IWorkbenchWindow iWorkbenchWindow) throws ExecutionException {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        try {
            IAdaptable iAdaptable = ((Workbench)iWorkbench).getDefaultPageInput();
            iWorkbench.openWorkbenchWindow(string, iAdaptable);
        }
        catch (WorkbenchException workbenchException) {
            ErrorDialog.openError((Shell)iWorkbenchWindow.getShell(), (String)WorkbenchMessages.ChangeToPerspectiveMenu_errorTitle, (String)workbenchException.getMessage(), (IStatus)workbenchException.getStatus());
        }
    }

    private final void openOther(IWorkbenchWindow iWorkbenchWindow) throws ExecutionException {
        SelectPerspectiveDialog selectPerspectiveDialog = new SelectPerspectiveDialog(iWorkbenchWindow.getShell(), WorkbenchPlugin.getDefault().getPerspectiveRegistry());
        selectPerspectiveDialog.open();
        if (selectPerspectiveDialog.getReturnCode() == 1) {
            return;
        }
        IPerspectiveDescriptor iPerspectiveDescriptor = selectPerspectiveDialog.getSelection();
        if (iPerspectiveDescriptor != null) {
            int n = WorkbenchPlugin.getDefault().getPreferenceStore().getInt("OPEN_PERSPECTIVE_MODE");
            IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
            IPerspectiveDescriptor iPerspectiveDescriptor2 = iWorkbenchPage == null ? null : iWorkbenchPage.getPerspective();
            String string = iPerspectiveDescriptor.getId();
            if (2 == n && iPerspectiveDescriptor2 != null) {
                this.openNewWindowPerspective(string, iWorkbenchWindow);
            } else {
                this.openPerspective(string, iWorkbenchWindow);
            }
        }
    }

    private final void openPerspective(String string, IWorkbenchWindow iWorkbenchWindow) throws ExecutionException {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        IPerspectiveDescriptor iPerspectiveDescriptor = iWorkbenchWindow.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(string);
        if (iPerspectiveDescriptor == null) {
            throw new ExecutionException("Perspective " + string + " cannot be found.");
        }
        try {
            if (iWorkbenchPage != null) {
                iWorkbenchPage.setPerspective(iPerspectiveDescriptor);
            } else {
                IAdaptable iAdaptable = ((Workbench)iWorkbench).getDefaultPageInput();
                iWorkbenchWindow.openPage(string, iAdaptable);
            }
        }
        catch (WorkbenchException workbenchException) {
            throw new ExecutionException("Perspective could not be opened.", (Throwable)((Object)workbenchException));
        }
    }
}

