/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.handlers;

import java.util.Collection;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;

public class HandlerUtil {
    private static void noVariableFound(ExecutionEvent executionEvent, String string) throws ExecutionException {
        throw new ExecutionException("No " + string + " found while executing " + executionEvent.getCommand().getId());
    }

    private static void incorrectTypeFound(ExecutionEvent executionEvent, String string, Class clazz, Class clazz2) throws ExecutionException {
        throw new ExecutionException("Incorrect type for " + string + " found while executing " + executionEvent.getCommand().getId() + ", expected " + clazz.getName() + " found " + clazz2.getName());
    }

    public static Object getVariable(ExecutionEvent executionEvent, String string) {
        if (executionEvent.getApplicationContext() instanceof IEvaluationContext) {
            Object object = ((IEvaluationContext)executionEvent.getApplicationContext()).getVariable(string);
            return object == IEvaluationContext.UNDEFINED_VARIABLE ? null : object;
        }
        return null;
    }

    public static Object getVariableChecked(ExecutionEvent executionEvent, String string) throws ExecutionException {
        Object object = HandlerUtil.getVariable(executionEvent, string);
        if (object == null) {
            HandlerUtil.noVariableFound(executionEvent, string);
        }
        return object;
    }

    public static Object getVariable(Object object, String string) {
        if (object instanceof IEvaluationContext) {
            Object object2 = ((IEvaluationContext)object).getVariable(string);
            return object2 == IEvaluationContext.UNDEFINED_VARIABLE ? null : object2;
        }
        return null;
    }

    public static Collection getActiveContexts(ExecutionEvent executionEvent) {
        Object object = HandlerUtil.getVariable(executionEvent, "activeContexts");
        if (object instanceof Collection) {
            return (Collection)object;
        }
        return null;
    }

    public static Collection getActiveContextsChecked(ExecutionEvent executionEvent) throws ExecutionException {
        Object object = HandlerUtil.getVariableChecked(executionEvent, "activeContexts");
        if (!(object instanceof Collection)) {
            HandlerUtil.incorrectTypeFound(executionEvent, "activeContexts", Collection.class, object.getClass());
        }
        return (Collection)object;
    }

    public static Shell getActiveShell(ExecutionEvent executionEvent) {
        Object object = HandlerUtil.getVariable(executionEvent, "activeShell");
        if (object instanceof Shell) {
            return (Shell)object;
        }
        return null;
    }

    public static Shell getActiveShellChecked(ExecutionEvent executionEvent) throws ExecutionException {
        Object object = HandlerUtil.getVariableChecked(executionEvent, "activeShell");
        if (!(object instanceof Shell)) {
            HandlerUtil.incorrectTypeFound(executionEvent, "activeShell", Shell.class, object.getClass());
        }
        return (Shell)object;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow(ExecutionEvent executionEvent) {
        Object object = HandlerUtil.getVariable(executionEvent, "activeWorkbenchWindow");
        if (object instanceof IWorkbenchWindow) {
            return (IWorkbenchWindow)object;
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindowChecked(ExecutionEvent executionEvent) throws ExecutionException {
        Object object = HandlerUtil.getVariableChecked(executionEvent, "activeWorkbenchWindow");
        if (!(object instanceof IWorkbenchWindow)) {
            HandlerUtil.incorrectTypeFound(executionEvent, "activeWorkbenchWindow", IWorkbenchWindow.class, object.getClass());
        }
        return (IWorkbenchWindow)object;
    }

    public static IEditorPart getActiveEditor(ExecutionEvent executionEvent) {
        Object object = HandlerUtil.getVariable(executionEvent, "activeEditor");
        if (object instanceof IEditorPart) {
            return (IEditorPart)object;
        }
        return null;
    }

    public static IEditorPart getActiveEditorChecked(ExecutionEvent executionEvent) throws ExecutionException {
        Object object = HandlerUtil.getVariableChecked(executionEvent, "activeEditor");
        if (!(object instanceof IEditorPart)) {
            HandlerUtil.incorrectTypeFound(executionEvent, "activeEditor", IEditorPart.class, object.getClass());
        }
        return (IEditorPart)object;
    }

    public static String getActiveEditorId(ExecutionEvent executionEvent) {
        Object object = HandlerUtil.getVariable(executionEvent, "activeEditorId");
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public static String getActiveEditorIdChecked(ExecutionEvent executionEvent) throws ExecutionException {
        Object object = HandlerUtil.getVariableChecked(executionEvent, "activeEditorId");
        if (!(object instanceof String)) {
            HandlerUtil.incorrectTypeFound(executionEvent, "activeEditorId", String.class, object.getClass());
        }
        return (String)object;
    }

    public static IEditorInput getActiveEditorInput(ExecutionEvent executionEvent) {
        Object object = HandlerUtil.getVariable(executionEvent, "activeEditorInput");
        if (object instanceof IEditorInput) {
            return (IEditorInput)object;
        }
        return null;
    }

    public static IEditorInput getActiveEditorInputChecked(ExecutionEvent executionEvent) throws ExecutionException {
        Object object = HandlerUtil.getVariableChecked(executionEvent, "activeEditorInput");
        if (!(object instanceof IEditorInput)) {
            HandlerUtil.incorrectTypeFound(executionEvent, "activeEditorInput", IEditorInput.class, object.getClass());
        }
        return (IEditorInput)object;
    }

    public static IWorkbenchPart getActivePart(ExecutionEvent executionEvent) {
        Object object = HandlerUtil.getVariable(executionEvent, "activePart");
        if (object instanceof IWorkbenchPart) {
            return (IWorkbenchPart)object;
        }
        return null;
    }

    public static IWorkbenchPart getActivePartChecked(ExecutionEvent executionEvent) throws ExecutionException {
        Object object = HandlerUtil.getVariableChecked(executionEvent, "activePart");
        if (!(object instanceof IWorkbenchPart)) {
            HandlerUtil.incorrectTypeFound(executionEvent, "activePart", IWorkbenchPart.class, object.getClass());
        }
        return (IWorkbenchPart)object;
    }

    public static String getActivePartId(ExecutionEvent executionEvent) {
        Object object = HandlerUtil.getVariable(executionEvent, "activePartId");
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public static String getActivePartIdChecked(ExecutionEvent executionEvent) throws ExecutionException {
        Object object = HandlerUtil.getVariableChecked(executionEvent, "activePartId");
        if (!(object instanceof String)) {
            HandlerUtil.incorrectTypeFound(executionEvent, "activePartId", String.class, object.getClass());
        }
        return (String)object;
    }

    public static IWorkbenchSite getActiveSite(ExecutionEvent executionEvent) {
        Object object = HandlerUtil.getVariable(executionEvent, "activeSite");
        if (object instanceof IWorkbenchSite) {
            return (IWorkbenchSite)object;
        }
        return null;
    }

    public static IWorkbenchSite getActiveSiteChecked(ExecutionEvent executionEvent) throws ExecutionException {
        Object object = HandlerUtil.getVariableChecked(executionEvent, "activeSite");
        if (!(object instanceof IWorkbenchSite)) {
            HandlerUtil.incorrectTypeFound(executionEvent, "activeSite", IWorkbenchSite.class, object.getClass());
        }
        return (IWorkbenchSite)object;
    }

    public static ISelection getCurrentSelection(ExecutionEvent executionEvent) {
        Object object = HandlerUtil.getVariable(executionEvent, "selection");
        if (object instanceof ISelection) {
            return (ISelection)object;
        }
        return null;
    }

    public static ISelection getCurrentSelectionChecked(ExecutionEvent executionEvent) throws ExecutionException {
        Object object = HandlerUtil.getVariableChecked(executionEvent, "selection");
        if (!(object instanceof ISelection)) {
            HandlerUtil.incorrectTypeFound(executionEvent, "selection", ISelection.class, object.getClass());
        }
        return (ISelection)object;
    }

    public static Collection getActiveMenus(ExecutionEvent executionEvent) {
        Object object = HandlerUtil.getVariable(executionEvent, "activeMenu");
        if (object instanceof Collection) {
            return (Collection)object;
        }
        return null;
    }

    public static Collection getActiveMenusChecked(ExecutionEvent executionEvent) throws ExecutionException {
        Object object = HandlerUtil.getVariableChecked(executionEvent, "activeMenu");
        if (!(object instanceof Collection)) {
            HandlerUtil.incorrectTypeFound(executionEvent, "activeMenu", Collection.class, object.getClass());
        }
        return (Collection)object;
    }

    public static ISelection getActiveMenuSelection(ExecutionEvent executionEvent) {
        Object object = HandlerUtil.getVariable(executionEvent, "activeMenuSelection");
        if (object instanceof ISelection) {
            return (ISelection)object;
        }
        return null;
    }

    public static ISelection getActiveMenuSelectionChecked(ExecutionEvent executionEvent) throws ExecutionException {
        Object object = HandlerUtil.getVariableChecked(executionEvent, "activeMenuSelection");
        if (!(object instanceof ISelection)) {
            HandlerUtil.incorrectTypeFound(executionEvent, "activeMenuSelection", ISelection.class, object.getClass());
        }
        return (ISelection)object;
    }

    public static ISelection getActiveMenuEditorInput(ExecutionEvent executionEvent) {
        Object object = HandlerUtil.getVariable(executionEvent, "activeMenuEditorInput");
        if (object instanceof ISelection) {
            return (ISelection)object;
        }
        return null;
    }

    public static ISelection getActiveMenuEditorInputChecked(ExecutionEvent executionEvent) throws ExecutionException {
        Object object = HandlerUtil.getVariableChecked(executionEvent, "activeMenuEditorInput");
        if (!(object instanceof ISelection)) {
            HandlerUtil.incorrectTypeFound(executionEvent, "activeMenuEditorInput", ISelection.class, object.getClass());
        }
        return (ISelection)object;
    }

    public static ISelection getShowInSelection(ExecutionEvent executionEvent) {
        Object object = HandlerUtil.getVariable(executionEvent, "showInSelection");
        if (object instanceof ISelection) {
            return (ISelection)object;
        }
        return null;
    }

    public static ISelection getShowInSelectionChecked(ExecutionEvent executionEvent) throws ExecutionException {
        Object object = HandlerUtil.getVariableChecked(executionEvent, "showInSelection");
        if (!(object instanceof ISelection)) {
            HandlerUtil.incorrectTypeFound(executionEvent, "showInSelection", ISelection.class, object.getClass());
        }
        return (ISelection)object;
    }

    public static Object getShowInInput(ExecutionEvent executionEvent) {
        Object object = HandlerUtil.getVariable(executionEvent, "showInInput");
        return object;
    }

    public static Object getShowInInputChecked(ExecutionEvent executionEvent) throws ExecutionException {
        Object object = HandlerUtil.getVariableChecked(executionEvent, "showInInput");
        return object;
    }

    public static boolean toggleCommandState(Command command) throws ExecutionException {
        State state = command.getState("org.eclipse.ui.commands.toggleState");
        if (state == null) {
            throw new ExecutionException("The command does not have a toggle state");
        }
        if (!(state.getValue() instanceof Boolean)) {
            throw new ExecutionException("The command's toggle state doesn't contain a boolean value");
        }
        boolean bl = (Boolean)state.getValue();
        state.setValue((Object)new Boolean(!bl));
        return bl;
    }

    public static boolean matchesRadioState(ExecutionEvent executionEvent) throws ExecutionException {
        String string = executionEvent.getParameter("org.eclipse.ui.commands.radioStateParameter");
        if (string == null) {
            throw new ExecutionException("The event does not have the radio state parameter");
        }
        Command command = executionEvent.getCommand();
        State state = command.getState("org.eclipse.ui.commands.radioState");
        if (state == null) {
            throw new ExecutionException("The command does not have a radio state");
        }
        if (!(state.getValue() instanceof String)) {
            throw new ExecutionException("The command's radio state doesn't contain a String value");
        }
        return string.equals(state.getValue());
    }

    public static void updateRadioState(Command command, String string) throws ExecutionException {
        State state = command.getState("org.eclipse.ui.commands.radioState");
        if (state == null) {
            throw new ExecutionException("The command does not have a radio state");
        }
        state.setValue((Object)string);
    }
}

