/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.fieldassist;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.swt.IFocusService;

public class ContentAssistCommandAdapter
extends ContentProposalAdapter {
    private static final String CONTENT_ASSIST_DECORATION_ID = "org.eclipse.ui.fieldAssist.ContentAssistField";
    private static final String CONTROL_ID_PREFIX = "org.eclipse.ui.fieldAssist.ContentAssistField.ControlID";
    private String commandId;
    public static final String CONTENT_PROPOSAL_COMMAND = "org.eclipse.ui.edit.text.contentAssist.proposals";
    private static final int DEFAULT_AUTO_ACTIVATION_DELAY = 500;
    private ContentAssistHandler proposalHandler = new ContentAssistHandler();
    private ControlDecoration decoration;

    public ContentAssistCommandAdapter(Control control, IControlContentAdapter iControlContentAdapter, IContentProposalProvider iContentProposalProvider, String string, char[] cArray) {
        this(control, iControlContentAdapter, iContentProposalProvider, string, cArray, false);
    }

    public ContentAssistCommandAdapter(Control control, IControlContentAdapter iControlContentAdapter, IContentProposalProvider iContentProposalProvider, String string, char[] cArray, boolean bl) {
        super(control, iControlContentAdapter, iContentProposalProvider, null, cArray);
        this.commandId = string;
        if (string == null) {
            this.commandId = CONTENT_PROPOSAL_COMMAND;
        }
        if (cArray == null) {
            this.setAutoActivationCharacters(new char[0]);
        }
        this.setAutoActivationDelay(500);
        this.activateHandler(control);
        if (bl) {
            this.decoration = new ControlDecoration(control, 16512);
            this.decoration.setShowOnlyOnFocus(true);
            FieldDecoration fieldDecoration = this.getContentAssistFieldDecoration();
            this.decoration.setImage(fieldDecoration.getImage());
            this.decoration.setDescriptionText(fieldDecoration.getDescription());
        }
    }

    public String getCommandId() {
        return this.commandId;
    }

    private FieldDecoration getContentAssistFieldDecoration() {
        Object object;
        String string;
        FieldDecorationRegistry fieldDecorationRegistry = FieldDecorationRegistry.getDefault();
        FieldDecoration fieldDecoration = fieldDecorationRegistry.getFieldDecoration(string = CONTENT_ASSIST_DECORATION_ID + this.getCommandId());
        if (fieldDecoration == null) {
            object = fieldDecorationRegistry.getFieldDecoration("DEC_CONTENT_PROPOSAL");
            fieldDecorationRegistry.registerFieldDecoration(string, null, object.getImage());
            fieldDecoration = fieldDecorationRegistry.getFieldDecoration(string);
        }
        object = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        fieldDecoration.setDescription(NLS.bind((String)WorkbenchMessages.ContentAssist_Cue_Description_Key, (Object)object.getBestActiveBindingFormattedFor(this.getCommandId())));
        return fieldDecoration;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.decoration != null) {
            if (bl) {
                this.decoration.show();
            } else {
                this.decoration.hide();
            }
        }
        this.proposalHandler.setEnabled(bl);
    }

    private void activateHandler(final Control control) {
        IFocusService iFocusService = (IFocusService)PlatformUI.getWorkbench().getService(IFocusService.class);
        final IHandlerService iHandlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        if (iFocusService != null && iHandlerService != null) {
            iFocusService.addFocusTracker(control, CONTROL_ID_PREFIX + ((Object)((Object)this)).hashCode());
            final IHandlerActivation iHandlerActivation = iHandlerService.activateHandler(this.commandId, (IHandler)this.proposalHandler, new Expression(){

                public EvaluationResult evaluate(IEvaluationContext iEvaluationContext) {
                    return iEvaluationContext.getVariable("activeFocusControl") == control ? EvaluationResult.TRUE : EvaluationResult.FALSE;
                }

                public void collectExpressionInfo(ExpressionInfo expressionInfo) {
                    expressionInfo.addVariableNameAccess("activeFocusControl");
                }
            });
            control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    iHandlerService.deactivateHandler(iHandlerActivation);
                }
            });
        }
    }

    private class ContentAssistHandler
    extends AbstractHandler {
        private ContentAssistHandler() {
        }

        public Object execute(ExecutionEvent executionEvent) {
            ContentAssistCommandAdapter.this.openProposalPopup();
            return null;
        }

        void setEnabled(boolean bl) {
            this.setBaseEnabled(bl);
        }
    }
}

