/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.SimpleWorkingSetSelectionDialog;

public class WorkingSetConfigurationBlock {
    private static final IWorkingSet[] EMPTY_WORKING_SET_ARRAY = new IWorkingSet[0];
    private static final String WORKINGSET_SELECTION_HISTORY = "workingset_selection_history";
    private static final int MAX_HISTORY_SIZE = 5;
    private Label workingSetLabel;
    private Combo workingSetCombo;
    private Button selectButton;
    private Button enableButton;
    private IWorkingSet[] selectedWorkingSets;
    private ArrayList selectionHistory;
    private final IDialogSettings dialogSettings;
    private final String[] workingSetTypeIds;
    private final String selectLabel;
    private final String comboLabel;
    private final String addButtonLabel;

    public static IWorkingSet[] filter(IWorkingSet[] iWorkingSetArray, String[] stringArray) {
        Object[] objectArray = new String[stringArray.length];
        System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
        Arrays.sort(objectArray);
        ArrayList<IWorkingSet> arrayList = new ArrayList<IWorkingSet>();
        int n = 0;
        while (n < iWorkingSetArray.length) {
            if (Arrays.binarySearch(objectArray, iWorkingSetArray[n].getId()) >= 0) {
                arrayList.add(iWorkingSetArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new IWorkingSet[arrayList.size()]);
    }

    public WorkingSetConfigurationBlock(String[] stringArray, IDialogSettings iDialogSettings) {
        this(stringArray, iDialogSettings, null, null, null);
    }

    public WorkingSetConfigurationBlock(String[] stringArray, IDialogSettings iDialogSettings, String string, String string2, String string3) {
        Assert.isNotNull((Object)stringArray);
        Assert.isNotNull((Object)iDialogSettings);
        this.workingSetTypeIds = stringArray;
        Arrays.sort(stringArray);
        this.selectedWorkingSets = EMPTY_WORKING_SET_ARRAY;
        this.dialogSettings = iDialogSettings;
        this.selectionHistory = this.loadSelectionHistory(iDialogSettings, stringArray);
        this.addButtonLabel = string == null ? WorkbenchMessages.WorkingSetGroup_EnableWorkingSet_button : string;
        this.comboLabel = string2 == null ? WorkbenchMessages.WorkingSetConfigurationBlock_WorkingSetText_name : string2;
        this.selectLabel = string3 == null ? WorkbenchMessages.WorkingSetConfigurationBlock_SelectWorkingSet_button : string3;
    }

    public void setSelection(IStructuredSelection iStructuredSelection) {
        this.selectedWorkingSets = this.findApplicableWorkingSets(iStructuredSelection);
        if (this.workingSetCombo != null) {
            this.updateSelectedWorkingSets();
        }
    }

    public void setWorkingSets(IWorkingSet[] iWorkingSetArray) {
        this.selectedWorkingSets = this.filterWorkingSets(Arrays.asList(iWorkingSetArray));
        if (this.workingSetCombo != null) {
            this.updateSelectedWorkingSets();
        }
    }

    public IWorkingSet[] findApplicableWorkingSets(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection == null) {
            return EMPTY_WORKING_SET_ARRAY;
        }
        return this.filterWorkingSets(iStructuredSelection.toList());
    }

    private IWorkingSet[] filterWorkingSets(Collection collection) {
        ArrayList arrayList = new ArrayList();
        for (Object e : collection) {
            if (!(e instanceof IWorkingSet) || !this.verifyWorkingSet((IWorkingSet)e)) continue;
            arrayList.add(e);
        }
        return arrayList.toArray(new IWorkingSet[arrayList.size()]);
    }

    private boolean verifyWorkingSet(IWorkingSet iWorkingSet) {
        return !iWorkingSet.isAggregateWorkingSet() && Arrays.binarySearch(this.workingSetTypeIds, iWorkingSet.getId()) >= 0;
    }

    public IWorkingSet[] getSelectedWorkingSets() {
        if (this.enableButton.getSelection()) {
            return this.selectedWorkingSets;
        }
        return EMPTY_WORKING_SET_ARRAY;
    }

    public void createContent(final Composite composite) {
        int n = 3;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 128, true, false));
        composite2.setLayout((Layout)new GridLayout(n, false));
        this.enableButton = new Button(composite2, 32);
        this.enableButton.setText(this.addButtonLabel);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = n;
        this.enableButton.setLayoutData((Object)gridData);
        this.enableButton.setSelection(this.selectedWorkingSets.length > 0);
        this.workingSetLabel = new Label(composite2, 0);
        this.workingSetLabel.setText(this.comboLabel);
        this.workingSetCombo = new Combo(composite2, 2056);
        GridData gridData2 = new GridData(4, 0x1000000, true, false);
        gridData2.horizontalSpan = n - 2;
        gridData2.horizontalIndent = 0;
        this.workingSetCombo.setLayoutData((Object)gridData2);
        this.selectButton = new Button(composite2, 8);
        this.selectButton.setText(this.selectLabel);
        this.setButtonLayoutData(this.selectButton);
        this.selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SimpleWorkingSetSelectionDialog simpleWorkingSetSelectionDialog = new SimpleWorkingSetSelectionDialog(composite.getShell(), WorkingSetConfigurationBlock.this.workingSetTypeIds, WorkingSetConfigurationBlock.this.selectedWorkingSets, false);
                simpleWorkingSetSelectionDialog.setMessage(WorkbenchMessages.WorkingSetGroup_WorkingSetSelection_message);
                if (simpleWorkingSetSelectionDialog.open() == 0) {
                    IWorkingSet[] iWorkingSetArray = simpleWorkingSetSelectionDialog.getSelection();
                    if (iWorkingSetArray != null && iWorkingSetArray.length > 0) {
                        WorkingSetConfigurationBlock.this.selectedWorkingSets = iWorkingSetArray;
                        PlatformUI.getWorkbench().getWorkingSetManager().addRecentWorkingSet(iWorkingSetArray[0]);
                    } else {
                        WorkingSetConfigurationBlock.this.selectedWorkingSets = EMPTY_WORKING_SET_ARRAY;
                    }
                    WorkingSetConfigurationBlock.this.updateWorkingSetSelection();
                }
            }
        });
        this.enableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkingSetConfigurationBlock.this.updateEnableState(WorkingSetConfigurationBlock.this.enableButton.getSelection());
            }
        });
        this.updateEnableState(this.enableButton.getSelection());
        this.workingSetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkingSetConfigurationBlock.this.updateSelectedWorkingSets();
            }
        });
        this.workingSetCombo.setItems(this.getHistoryEntries());
        if (this.selectedWorkingSets.length == 0 && this.selectionHistory.size() > 0) {
            this.workingSetCombo.select(this.historyIndex((String)this.selectionHistory.get(0)));
            this.updateSelectedWorkingSets();
        } else {
            this.updateWorkingSetSelection();
        }
    }

    private void updateEnableState(boolean bl) {
        this.workingSetLabel.setEnabled(bl);
        this.workingSetCombo.setEnabled(bl && (this.selectedWorkingSets.length > 0 || this.getHistoryEntries().length > 0));
        this.selectButton.setEnabled(bl);
    }

    private void updateWorkingSetSelection() {
        if (this.selectedWorkingSets.length > 0) {
            this.workingSetCombo.setEnabled(true);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.selectedWorkingSets[0].getLabel());
            int n = 1;
            while (n < this.selectedWorkingSets.length) {
                IWorkingSet iWorkingSet = this.selectedWorkingSets[n];
                stringBuffer.append(',').append(' ');
                stringBuffer.append(iWorkingSet.getLabel());
                ++n;
            }
            String string = stringBuffer.toString();
            int n2 = this.historyIndex(string);
            this.historyInsert(string);
            if (n2 >= 0) {
                this.workingSetCombo.select(n2);
            } else {
                this.workingSetCombo.setItems(this.getHistoryEntries());
                this.workingSetCombo.select(this.historyIndex(string));
            }
        } else {
            this.enableButton.setSelection(false);
            this.updateEnableState(false);
        }
    }

    private String[] getHistoryEntries() {
        String[] stringArray = this.selectionHistory.toArray(new String[this.selectionHistory.size()]);
        Arrays.sort(stringArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return Collator.getInstance().compare(object, object2);
            }
        });
        return stringArray;
    }

    private void historyInsert(String string) {
        this.selectionHistory.remove(string);
        this.selectionHistory.add(0, string);
        this.storeSelectionHistory(this.dialogSettings);
    }

    private int historyIndex(String string) {
        int n = 0;
        while (n < this.workingSetCombo.getItemCount()) {
            if (this.workingSetCombo.getItem(n).equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private String[] split(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    private void updateSelectedWorkingSets() {
        String string = this.workingSetCombo.getItem(this.workingSetCombo.getSelectionIndex());
        String[] stringArray = this.split(string, ", ");
        IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        this.selectedWorkingSets = new IWorkingSet[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            IWorkingSet iWorkingSet = iWorkingSetManager.getWorkingSet(stringArray[n]);
            Assert.isNotNull((Object)iWorkingSet);
            this.selectedWorkingSets[n] = iWorkingSet;
            ++n;
        }
    }

    private void storeSelectionHistory(IDialogSettings iDialogSettings) {
        String[] stringArray;
        if (this.selectionHistory.size() > 5) {
            List list = this.selectionHistory.subList(0, 5);
            stringArray = list.toArray(new String[list.size()]);
        } else {
            stringArray = this.selectionHistory.toArray(new String[this.selectionHistory.size()]);
        }
        iDialogSettings.put(WORKINGSET_SELECTION_HISTORY, stringArray);
    }

    private ArrayList loadSelectionHistory(IDialogSettings iDialogSettings, String[] stringArray) {
        String[] stringArray2 = iDialogSettings.getArray(WORKINGSET_SELECTION_HISTORY);
        if (stringArray2 == null || stringArray2.length == 0) {
            return new ArrayList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        int n = 0;
        while (n < stringArray2.length) {
            String[] stringArray3 = this.split(stringArray2[n], ", ");
            boolean bl = true;
            int n2 = 0;
            while (n2 < stringArray3.length && bl) {
                IWorkingSet iWorkingSet = iWorkingSetManager.getWorkingSet(stringArray3[n2]);
                if (iWorkingSet == null) {
                    bl = false;
                } else if (!hashSet.contains(iWorkingSet.getId())) {
                    bl = false;
                }
                ++n2;
            }
            if (bl) {
                arrayList.add(stringArray2[n]);
            }
            ++n;
        }
        return arrayList;
    }

    private GridData setButtonLayoutData(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        GC gC = new GC((Drawable)button);
        gC.setFont(button.getFont());
        FontMetrics fontMetrics = gC.getFontMetrics();
        gC.dispose();
        GridData gridData = new GridData(256);
        int n = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        Point point = button.computeSize(-1, -1, true);
        gridData.widthHint = Math.max(n, point.x);
        button.setLayoutData((Object)gridData);
        return gridData;
    }
}

