/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FileEditorMappingLabelProvider;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.registry.EditorRegistry;

public class TypeFilteringDialog
extends SelectionDialog {
    Button addTypesButton;
    Collection initialSelections;
    CheckboxTableViewer listViewer;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;
    private static final String TYPE_DELIMITER = WorkbenchMessages.TypesFiltering_typeDelimiter;
    private String filterTitle = WorkbenchMessages.TypesFiltering_otherExtensions;
    Text userDefinedText;
    IFileEditorMapping[] currentInput;

    public TypeFilteringDialog(Shell shell, Collection collection) {
        super(shell);
        this.setTitle(WorkbenchMessages.TypesFiltering_title);
        this.initialSelections = collection;
        this.setMessage(WorkbenchMessages.TypesFiltering_message);
        this.setShellStyle(this.getShellStyle() | 0x10000000);
    }

    public TypeFilteringDialog(Shell shell, Collection collection, String string) {
        this(shell, collection);
        this.filterTitle = string;
    }

    private void addSelectionButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 131072);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(640);
        gridData.grabExcessHorizontalSpace = true;
        composite.setData((Object)gridData);
        Button button = this.createButton(composite2, 18, WorkbenchMessages.WizardTransferPage_selectAll, false);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TypeFilteringDialog.this.listViewer.setAllChecked(true);
            }
        };
        button.addSelectionListener((SelectionListener)selectionAdapter);
        Button button2 = this.createButton(composite2, 19, WorkbenchMessages.WizardTransferPage_deselectAll, false);
        selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TypeFilteringDialog.this.listViewer.setAllChecked(false);
            }
        };
        button2.addSelectionListener((SelectionListener)selectionAdapter);
    }

    private void addUserDefinedEntries(List list) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.userDefinedText.getText(), TYPE_DELIMITER);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            if (string.equals("")) continue;
            if (string.startsWith("*.")) {
                list.add(string.substring(2));
                continue;
            }
            if (string.startsWith(".")) {
                list.add(string.substring(1));
                continue;
            }
            list.add(string);
        }
    }

    private void checkInitialSelections() {
        Object object;
        IFileEditorMapping[] iFileEditorMappingArray = ((EditorRegistry)PlatformUI.getWorkbench().getEditorRegistry()).getUnifiedMappings();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < iFileEditorMappingArray.length) {
            object = iFileEditorMappingArray[n];
            if (this.initialSelections.contains(object.getExtension())) {
                this.listViewer.setChecked(object, true);
                arrayList.add(object.getExtension());
            } else if (this.initialSelections.contains(object.getLabel())) {
                this.listViewer.setChecked(object, true);
                arrayList.add(object.getLabel());
            }
            ++n;
        }
        Iterator iterator = this.initialSelections.iterator();
        object = new StringBuffer();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (arrayList.contains(string)) continue;
            if (((StringBuffer)object).length() != 0) {
                ((StringBuffer)object).append(',');
            }
            ((StringBuffer)object).append(string);
        }
        this.userDefinedText.setText(((StringBuffer)object).toString());
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.type_filtering_dialog_context");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.createMessageArea(composite2);
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite2, (int)2048);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 250;
        gridData.widthHint = 300;
        this.listViewer.getTable().setLayoutData((Object)gridData);
        this.listViewer.getTable().setFont(composite.getFont());
        this.listViewer.setLabelProvider((IBaseLabelProvider)FileEditorMappingLabelProvider.INSTANCE);
        this.listViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.listViewer.setComparator(new ViewerComparator());
        this.addSelectionButtons(composite2);
        this.createUserEntryGroup(composite2);
        this.initializeViewer();
        if (this.initialSelections != null && !this.initialSelections.isEmpty()) {
            this.checkInitialSelections();
        }
        return composite2;
    }

    private void createUserEntryGroup(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(272));
        Label label = new Label(composite2, 0);
        label.setFont(font);
        label.setText(this.filterTitle);
        this.userDefinedText = new Text(composite2, 2052);
        this.userDefinedText.setFont(font);
        GridData gridData = new GridData(768);
        this.userDefinedText.setLayoutData((Object)gridData);
    }

    private IFileEditorMapping[] getInput() {
        if (this.currentInput == null) {
            ArrayList<IFileEditorMapping> arrayList = new ArrayList<IFileEditorMapping>();
            IFileEditorMapping[] iFileEditorMappingArray = ((EditorRegistry)PlatformUI.getWorkbench().getEditorRegistry()).getUnifiedMappings();
            int n = 0;
            while (n < iFileEditorMappingArray.length) {
                if (iFileEditorMappingArray[n].getName().equals("*")) {
                    arrayList.add(iFileEditorMappingArray[n]);
                }
                ++n;
            }
            this.currentInput = new IFileEditorMapping[arrayList.size()];
            arrayList.toArray(this.currentInput);
        }
        return this.currentInput;
    }

    private void initializeViewer() {
        this.listViewer.setInput((Object)this.getInput());
    }

    protected void okPressed() {
        IFileEditorMapping[] iFileEditorMappingArray = this.getInput();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < iFileEditorMappingArray.length) {
            IFileEditorMapping iFileEditorMapping = iFileEditorMappingArray[n];
            if (this.listViewer.getChecked((Object)iFileEditorMapping)) {
                arrayList.add(iFileEditorMapping.getExtension());
            }
            ++n;
        }
        this.addUserDefinedEntries(arrayList);
        this.setResult(arrayList);
        super.okPressed();
    }
}

