/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.AbstractElementListSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.TwoArrayQuickSorter;

public class TwoPaneElementSelector
extends AbstractElementListSelectionDialog {
    private String fUpperListLabel;
    private String fLowerListLabel;
    private Comparator fLowerListComparator = null;
    private ILabelProvider fQualifierRenderer;
    private Object[] fElements = new Object[0];
    private Table fLowerList;
    private Object[] fQualifierElements;

    public TwoPaneElementSelector(Shell shell, ILabelProvider iLabelProvider, ILabelProvider iLabelProvider2) {
        super(shell, iLabelProvider);
        this.setSize(50, 15);
        this.setAllowDuplicates(false);
        this.fQualifierRenderer = iLabelProvider2;
    }

    public void setUpperListLabel(String string) {
        this.fUpperListLabel = string;
    }

    public void setLowerListLabel(String string) {
        this.fLowerListLabel = string;
    }

    public void setLowerListComparator(Comparator comparator) {
        this.fLowerListComparator = comparator;
    }

    public void setElements(Object[] objectArray) {
        this.fElements = objectArray;
    }

    public Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.createMessageArea(composite2);
        this.createFilterText(composite2);
        this.createLabel(composite2, this.fUpperListLabel);
        this.createFilteredList(composite2);
        this.createLabel(composite2, this.fLowerListLabel);
        this.createLowerList(composite2);
        this.setListElements(this.fElements);
        List list = this.getInitialElementSelections();
        if (!list.isEmpty()) {
            Object e = list.get(0);
            this.setSelection(new Object[]{e});
            this.setLowerSelectedElement(e);
        }
        return composite2;
    }

    protected Label createLabel(Composite composite, String string) {
        if (string == null) {
            return null;
        }
        Label label = new Label(composite, 0);
        label.setText(string);
        label.setFont(composite.getFont());
        return label;
    }

    protected Table createLowerList(Composite composite) {
        Table table = new Table(composite, 2816);
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TwoPaneElementSelector.this.handleLowerSelectionChanged();
            }
        });
        table.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                TwoPaneElementSelector.this.handleDefaultSelected();
            }
        });
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                TwoPaneElementSelector.this.fQualifierRenderer.dispose();
            }
        });
        GridData gridData = new GridData();
        gridData.widthHint = this.convertWidthInCharsToPixels(50);
        gridData.heightHint = this.convertHeightInCharsToPixels(5);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        table.setLayoutData((Object)gridData);
        table.setFont(composite.getFont());
        this.fLowerList = table;
        return table;
    }

    @Override
    protected void computeResult() {
        Object[] objectArray = new Object[]{this.getLowerSelectedElement()};
        this.setResult(Arrays.asList(objectArray));
    }

    @Override
    protected void handleDefaultSelected() {
        if (this.validateCurrentSelection() && this.getLowerSelectedElement() != null) {
            this.buttonPressed(0);
        }
    }

    @Override
    protected void handleSelectionChanged() {
        this.handleUpperSelectionChanged();
    }

    private void handleUpperSelectionChanged() {
        int[] nArray = this.getSelectionIndices();
        this.fLowerList.removeAll();
        int n = 0;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(nArray.length * 5);
        int n2 = 0;
        while (n2 < nArray.length) {
            Object[] objectArray = this.getFoldedElements(nArray[n2]);
            if (objectArray != null) {
                n += objectArray.length;
                arrayList.add(this.getFoldedElements(nArray[n2]));
            }
            ++n2;
        }
        if (n > 0) {
            this.fQualifierElements = new Object[n];
            n2 = 0;
            for (Object[] objectArray : arrayList) {
                System.arraycopy(objectArray, 0, this.fQualifierElements, n2, objectArray.length);
                n2 += objectArray.length;
            }
            this.updateLowerListWidget(this.fQualifierElements);
        } else {
            this.fQualifierElements = null;
            this.updateLowerListWidget(new Object[0]);
        }
        this.validateCurrentSelection();
    }

    private void handleLowerSelectionChanged() {
        this.validateCurrentSelection();
    }

    protected void setLowerSelectedElement(Object object) {
        if (this.fQualifierElements == null) {
            return;
        }
        int n = 0;
        while (n != this.fQualifierElements.length) {
            if (this.fQualifierElements[n].equals(object)) break;
            ++n;
        }
        if (n != this.fQualifierElements.length) {
            this.fLowerList.setSelection(n);
        }
    }

    protected Object getLowerSelectedElement() {
        int n = this.fLowerList.getSelectionIndex();
        if (n >= 0) {
            return this.fQualifierElements[n];
        }
        return null;
    }

    private void updateLowerListWidget(Object[] objectArray) {
        int n = objectArray.length;
        Object[] objectArray2 = new String[n];
        int n2 = 0;
        while (n2 != n) {
            String string = this.fQualifierRenderer.getText(objectArray[n2]);
            if (string == null) {
                string = "";
            }
            objectArray2[n2] = string;
            ++n2;
        }
        TwoArrayQuickSorter twoArrayQuickSorter = this.fLowerListComparator == null ? new TwoArrayQuickSorter(this.isCaseIgnored()) : new TwoArrayQuickSorter(this.fLowerListComparator);
        twoArrayQuickSorter.sort(objectArray2, objectArray);
        int n3 = 0;
        while (n3 != n) {
            TableItem tableItem = new TableItem(this.fLowerList, 0);
            tableItem.setText((String)objectArray2[n3]);
            tableItem.setImage(this.fQualifierRenderer.getImage(objectArray[n3]));
            ++n3;
        }
        if (this.fLowerList.getItemCount() > 0) {
            this.fLowerList.setSelection(0);
        }
    }

    @Override
    protected void handleEmptyList() {
        super.handleEmptyList();
        this.fLowerList.setEnabled(false);
    }

    @Override
    protected boolean validateCurrentSelection() {
        ISelectionStatusValidator iSelectionStatusValidator = this.getValidator();
        Object object = this.getLowerSelectedElement();
        if (iSelectionStatusValidator != null && object != null) {
            IStatus iStatus = iSelectionStatusValidator.validate(new Object[]{object});
            this.updateStatus(iStatus);
            return iStatus.isOK();
        }
        return super.validateCurrentSelection();
    }
}

