/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.Comparator;
import org.eclipse.core.runtime.Assert;

class TwoArrayQuickSorter {
    private Comparator fComparator;

    public TwoArrayQuickSorter(boolean bl) {
        this.fComparator = new StringComparator(bl);
    }

    public TwoArrayQuickSorter(Comparator comparator) {
        this.fComparator = comparator;
    }

    public void sort(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null || objectArray2 == null) {
            Assert.isTrue((boolean)false, (String)"Either keys or values in null");
            return;
        }
        if (objectArray.length <= 1) {
            return;
        }
        this.internalSort(objectArray, objectArray2, 0, objectArray.length - 1);
    }

    private void internalSort(Object[] objectArray, Object[] objectArray2, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        Object object = objectArray[(n + n2) / 2];
        while (true) {
            if (this.fComparator.compare(objectArray[n], object) < 0) {
                ++n;
                continue;
            }
            while (this.fComparator.compare(object, objectArray[n2]) < 0) {
                --n2;
            }
            if (n <= n2) {
                TwoArrayQuickSorter.swap(objectArray, n, n2);
                TwoArrayQuickSorter.swap(objectArray2, n, n2);
                ++n;
                --n2;
            }
            if (n > n2) break;
        }
        if (n3 < n2) {
            this.internalSort(objectArray, objectArray2, n3, n2);
        }
        if (n < n4) {
            this.internalSort(objectArray, objectArray2, n, n4);
        }
    }

    private static final void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    public static final class StringComparator
    implements Comparator {
        private boolean fIgnoreCase;

        StringComparator(boolean bl) {
            this.fIgnoreCase = bl;
        }

        public int compare(Object object, Object object2) {
            return this.fIgnoreCase ? ((String)object).compareToIgnoreCase((String)object2) : ((String)object).compareTo((String)object2);
        }
    }
}

