/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.MessageLine;

public abstract class SelectionStatusDialog
extends SelectionDialog {
    private MessageLine fStatusLine;
    private IStatus fLastStatus;
    private Image fImage;
    private boolean fStatusLineAboveButtons = false;

    public SelectionStatusDialog(Shell shell) {
        super(shell);
    }

    public void setStatusLineAboveButtons(boolean bl) {
        this.fStatusLineAboveButtons = bl;
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    public Object getFirstResult() {
        Object[] objectArray = this.getResult();
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        return objectArray[0];
    }

    protected void setResult(int n, Object object) {
        Object[] objectArray = this.getResult();
        objectArray[n] = object;
        this.setResult(Arrays.asList(objectArray));
    }

    protected abstract void computeResult();

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fImage != null) {
            shell.setImage(this.fImage);
        }
    }

    protected void updateStatus(IStatus iStatus) {
        this.fLastStatus = iStatus;
        if (this.fStatusLine != null && !this.fStatusLine.isDisposed()) {
            this.updateButtonsEnableState(iStatus);
            this.fStatusLine.setErrorStatus(iStatus);
        }
    }

    protected void updateButtonsEnableState(IStatus iStatus) {
        Button button = this.getOkButton();
        if (button != null && !button.isDisposed()) {
            button.setEnabled(!iStatus.matches(4));
        }
    }

    protected void okPressed() {
        this.computeResult();
        super.okPressed();
    }

    public void create() {
        super.create();
        if (this.fLastStatus != null) {
            this.updateStatus(this.fLastStatus);
        }
    }

    protected Control createButtonBar(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        if (!this.fStatusLineAboveButtons) {
            gridLayout.numColumns = 2;
        }
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = this.convertHorizontalDLUsToPixels(7);
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        composite2.setFont(font);
        if (!this.fStatusLineAboveButtons && this.isHelpAvailable()) {
            this.createHelpControl(composite2);
        }
        this.fStatusLine = new MessageLine(composite2);
        this.fStatusLine.setAlignment(16384);
        GridData gridData = new GridData(768);
        this.fStatusLine.setErrorStatus(null);
        this.fStatusLine.setFont(font);
        if (this.fStatusLineAboveButtons && this.isHelpAvailable()) {
            gridData.horizontalSpan = 2;
            this.createHelpControl(composite2);
        }
        this.fStatusLine.setLayoutData(gridData);
        boolean bl = this.isHelpAvailable();
        this.setHelpAvailable(false);
        super.createButtonBar(composite2);
        this.setHelpAvailable(bl);
        return composite2;
    }
}

