/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.WorkbenchMessages;

public abstract class SelectionDialog
extends TrayDialog {
    private Object[] result;
    private List initialSelections = new ArrayList();
    private String title;
    private String message = "";
    private int dialogBoundsStrategy = 3;
    private IDialogSettings dialogBoundsSettings = null;
    static String SELECT_ALL_TITLE = WorkbenchMessages.SelectionDialog_selectLabel;
    static String DESELECT_ALL_TITLE = WorkbenchMessages.SelectionDialog_deselectLabel;

    protected SelectionDialog(Shell shell) {
        super(shell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Label createMessageArea(Composite composite) {
        Label label = new Label(composite, 0);
        if (this.message != null) {
            label.setText(this.message);
        }
        label.setFont(composite.getFont());
        return label;
    }

    protected List getInitialSelections() {
        if (this.initialSelections.isEmpty()) {
            return null;
        }
        return this.getInitialElementSelections();
    }

    protected List getInitialElementSelections() {
        return this.initialSelections;
    }

    protected String getMessage() {
        return this.message;
    }

    public Button getOkButton() {
        return this.getButton(0);
    }

    public Object[] getResult() {
        return this.result;
    }

    public void setInitialSelections(Object[] objectArray) {
        this.initialSelections = new ArrayList(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            this.initialSelections.add(objectArray[n]);
            ++n;
        }
    }

    public void setInitialElementSelections(List list) {
        this.initialSelections = list;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    protected void setResult(List list) {
        if (list == null) {
            this.result = null;
        } else {
            this.result = new Object[list.size()];
            list.toArray(this.result);
        }
    }

    protected void setSelectionResult(Object[] objectArray) {
        this.result = objectArray;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setDialogBoundsSettings(IDialogSettings iDialogSettings, int n) {
        this.dialogBoundsStrategy = n;
        this.dialogBoundsSettings = iDialogSettings;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.dialogBoundsSettings;
    }

    protected int getDialogBoundsStrategy() {
        return this.dialogBoundsStrategy;
    }

    protected boolean isResizable() {
        return true;
    }
}

