/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import org.eclipse.ui.internal.misc.StringMatcher;

public class SearchPattern {
    public static final int RULE_EXACT_MATCH = 0;
    public static final int RULE_PREFIX_MATCH = 1;
    public static final int RULE_PATTERN_MATCH = 2;
    public static final int RULE_CASE_SENSITIVE = 8;
    public static final int RULE_BLANK_MATCH = 32;
    public static final int RULE_CAMELCASE_MATCH = 128;
    private int matchRule;
    private String stringPattern;
    private String initialPattern;
    private StringMatcher stringMatcher;
    private static final char END_SYMBOL = '<';
    private static final char ANY_STRING = '*';
    private static final char BLANK = ' ';
    private int allowedRules;

    public SearchPattern() {
        this(163);
    }

    public SearchPattern(int n) {
        this.allowedRules = n;
    }

    public String getPattern() {
        return this.stringPattern;
    }

    public void setPattern(String string) {
        this.initialPattern = string;
        this.stringPattern = string;
        this.initializePatternAndMatchRule(string);
        this.matchRule &= this.allowedRules;
        if (this.matchRule == 2) {
            this.stringMatcher = new StringMatcher(this.stringPattern, true, false);
        }
    }

    public boolean matches(String string) {
        switch (this.matchRule) {
            case 32: {
                return true;
            }
            case 2: {
                return this.stringMatcher.match(string);
            }
            case 0: {
                return this.stringPattern.equalsIgnoreCase(string);
            }
            case 128: {
                if (!this.camelCaseMatch(this.stringPattern, string)) break;
                return true;
            }
        }
        return this.startsWithIgnoreCase(string, this.stringPattern);
    }

    private void initializePatternAndMatchRule(String string) {
        int n = string.length();
        if (n == 0) {
            this.matchRule = 32;
            this.stringPattern = string;
            return;
        }
        char c = string.charAt(n - 1);
        if (string.indexOf(42) != -1 || string.indexOf(63) != -1) {
            this.matchRule = 2;
            switch (c) {
                case ' ': 
                case '<': {
                    this.stringPattern = string.substring(0, n - 1);
                    break;
                }
                case '*': {
                    this.stringPattern = string;
                    break;
                }
                default: {
                    this.stringPattern = String.valueOf(string) + '*';
                }
            }
            return;
        }
        if (this.validateMatchRule(string, 128) == 128) {
            this.matchRule = 128;
            this.stringPattern = string;
            return;
        }
        if (c == '<' || c == ' ') {
            this.matchRule = 0;
            this.stringPattern = string.substring(0, n - 1);
            return;
        }
        this.matchRule = 1;
        this.stringPattern = string;
    }

    private boolean startsWithIgnoreCase(String string, String string2) {
        int n;
        int n2 = string.length();
        if (n2 < (n = string2.length())) {
            return false;
        }
        int n3 = n - 1;
        while (n3 >= 0) {
            if (Character.toLowerCase(string2.charAt(n3)) != Character.toLowerCase(string.charAt(n3))) {
                return false;
            }
            --n3;
        }
        return true;
    }

    private boolean camelCaseMatch(String string, String string2) {
        if (string == null) {
            return true;
        }
        if (string2 == null) {
            return false;
        }
        return this.camelCaseMatch(string, 0, string.length(), string2, 0, string2.length());
    }

    private boolean camelCaseMatch(String string, int n, int n2, String string2, int n3, int n4) {
        if (string2 == null) {
            return false;
        }
        if (string == null) {
            return true;
        }
        if (n2 < 0) {
            n2 = string.length();
        }
        if (n4 < 0) {
            n4 = string2.length();
        }
        if (n2 <= n) {
            return n4 <= n3;
        }
        if (n4 <= n3) {
            return false;
        }
        if (string2.charAt(n3) != string.charAt(n)) {
            return false;
        }
        int n5 = n2;
        if (string.charAt(n2 - 1) == '<' || string.charAt(n2 - 1) == ' ') {
            n5 = n2 - 1;
        }
        int n6 = n;
        int n7 = n3;
        block0: while (true) {
            char c;
            ++n7;
            if (++n6 == n2) {
                return true;
            }
            if (n7 == n4) {
                return n6 == n5;
            }
            char c2 = string.charAt(n6);
            if (c2 == string2.charAt(n7)) continue;
            if (!this.isPatternCharAllowed(c2)) {
                return false;
            }
            while (true) {
                if (n7 == n4) {
                    return n6 == n5 && (c2 == '<' || c2 == ' ');
                }
                c = string2.charAt(n7);
                if (n6 == n5 && (c2 == '<' || c2 == ' ')) {
                    if (this.isNameCharAllowed(c)) {
                        return false;
                    }
                    ++n7;
                    continue;
                }
                if (Character.isDigit(c)) {
                    if (c2 == c) continue block0;
                    ++n7;
                    continue;
                }
                if (this.isNameCharAllowed(c)) break;
                ++n7;
            }
            if (c2 != c) break;
        }
        return false;
    }

    protected boolean isPatternCharAllowed(char c) {
        return c == '<' || c == ' ' || Character.isUpperCase(c) || Character.isDigit(c);
    }

    protected boolean isNameCharAllowed(char c) {
        return Character.isUpperCase(c);
    }

    public final int getMatchRule() {
        return this.matchRule;
    }

    private int validateMatchRule(String string, int n) {
        int n2 = string.indexOf(42);
        int n3 = string.indexOf(63);
        n = n2 < 0 && n3 < 0 ? (n &= 0xFFFFFFFD) : (n |= 2);
        if ((n & 2) != 0) {
            n &= 0xFFFFFF7F;
            n &= 0xFFFFFFFE;
        }
        if ((n & 0x80) != 0) {
            int n4 = string.length();
            boolean bl = true;
            int n5 = 0;
            while (n5 < n4 && bl) {
                char c = string.charAt(n5);
                bl = this.isValidCamelCaseChar(c);
                ++n5;
            }
            boolean bl2 = bl = bl && Character.isUpperCase(string.charAt(0));
            if (bl) {
                if ((n & 1) != 0 && (n & 8) != 0) {
                    n &= 0xFFFFFFFE;
                    n &= 0xFFFFFFF7;
                }
            } else if (((n &= 0xFFFFFF7F) & 1) == 0) {
                n |= 1;
                n |= 8;
            }
        }
        return n;
    }

    protected boolean isValidCamelCaseChar(char c) {
        return true;
    }

    public boolean equalsPattern(SearchPattern searchPattern) {
        return SearchPattern.trimWildcardCharacters(searchPattern.initialPattern).equals(SearchPattern.trimWildcardCharacters(this.initialPattern));
    }

    public boolean isSubPattern(SearchPattern searchPattern) {
        return SearchPattern.trimWildcardCharacters(searchPattern.initialPattern).startsWith(SearchPattern.trimWildcardCharacters(this.initialPattern));
    }

    private static String trimWildcardCharacters(String string) {
        int n = string.indexOf("**");
        if (n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = 0;
        do {
            if (n2 != 0 && n2 == n) continue;
            stringBuffer.append(string.substring(n2, n + 1));
        } while ((n = string.indexOf(42, n2 = n + 1)) != -1);
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }
}

