/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;

public class PropertyDialogAction
extends SelectionProviderAction {
    private IShellProvider shellProvider;
    private String initialPageId;

    public PropertyDialogAction(Shell shell, ISelectionProvider iSelectionProvider) {
        this((IShellProvider)new SameShellProvider((Control)shell), iSelectionProvider);
    }

    public PropertyDialogAction(IShellProvider iShellProvider, ISelectionProvider iSelectionProvider) {
        super(iSelectionProvider, WorkbenchMessages.PropertyDialog_text);
        Assert.isNotNull((Object)iShellProvider);
        this.shellProvider = iShellProvider;
        this.setToolTipText(WorkbenchMessages.PropertyDialog_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.property_dialog_action_context");
    }

    private boolean hasPropertyPagesFor(IStructuredSelection iStructuredSelection) {
        return PropertyPageContributorManager.getManager().getApplicableContributors(iStructuredSelection).size() != 0;
    }

    public boolean isApplicableForSelection() {
        if (!this.isEnabled()) {
            return false;
        }
        return this.isApplicableForSelection(this.getStructuredSelection());
    }

    public boolean isApplicableForSelection(IStructuredSelection iStructuredSelection) {
        return !iStructuredSelection.isEmpty() && this.hasPropertyPagesFor(iStructuredSelection);
    }

    public void run() {
        PreferenceDialog preferenceDialog = this.createDialog();
        if (preferenceDialog != null) {
            preferenceDialog.open();
        }
    }

    public PreferenceDialog createDialog() {
        if (this.getStructuredSelection().isEmpty()) {
            return null;
        }
        return PropertyDialog.createDialogOn(this.shellProvider.getShell(), this.initialPageId, this.getStructuredSelection());
    }

    @Override
    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(!iStructuredSelection.isEmpty());
    }
}

