/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.dialogs.FilteredPreferenceDialog;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceDialog;

public final class PreferencesUtil {
    public static final int OPTION_NONE = 0;
    public static final int OPTION_FILTER_LOCKED = 1;

    private static void applyOptions(Object object, String[] stringArray, FilteredPreferenceDialog filteredPreferenceDialog, int n) {
        if (object != null) {
            filteredPreferenceDialog.setPageData(object);
            IPreferencePage iPreferencePage = filteredPreferenceDialog.getCurrentPage();
            if (iPreferencePage instanceof PreferencePage) {
                ((PreferencePage)iPreferencePage).applyData(object);
            }
        }
        if (stringArray != null) {
            filteredPreferenceDialog.showOnly(stringArray);
        }
        if ((n & 1) != 0) {
            filteredPreferenceDialog.setLocked(true);
        }
    }

    public static final PreferenceDialog createPreferenceDialogOn(Shell shell, String string, String[] stringArray, Object object) {
        return PreferencesUtil.createPreferenceDialogOn(shell, string, stringArray, object, 0);
    }

    public static final PreferenceDialog createPropertyDialogOn(Shell shell, IAdaptable iAdaptable, String string, String[] stringArray, Object object) {
        return PreferencesUtil.createPropertyDialogOn(shell, iAdaptable, string, stringArray, object, 0);
    }

    public static final PreferenceDialog createPreferenceDialogOn(Shell shell, String string, String[] stringArray, Object object, int n) {
        WorkbenchPreferenceDialog workbenchPreferenceDialog = WorkbenchPreferenceDialog.createDialogOn(shell, string);
        PreferencesUtil.applyOptions(object, stringArray, workbenchPreferenceDialog, n);
        return workbenchPreferenceDialog;
    }

    public static final PreferenceDialog createPropertyDialogOn(Shell shell, IAdaptable iAdaptable, String string, String[] stringArray, Object object, int n) {
        PropertyDialog propertyDialog = PropertyDialog.createDialogOn(shell, string, iAdaptable);
        if (propertyDialog == null) {
            return null;
        }
        PreferencesUtil.applyOptions(object, stringArray, propertyDialog, n);
        return propertyDialog;
    }

    public static final PreferenceDialog createPropertyDialogOn(Shell shell, Object object, String string, String[] stringArray, Object object2, int n) {
        PropertyDialog propertyDialog = PropertyDialog.createDialogOn(shell, string, object);
        if (propertyDialog == null) {
            return null;
        }
        PreferencesUtil.applyOptions(object2, stringArray, propertyDialog, n);
        return propertyDialog;
    }

    public static boolean hasPropertiesContributors(Object object) {
        if (object == null || !(object instanceof IAdaptable)) {
            return false;
        }
        Collection collection = PropertyPageContributorManager.getManager().getApplicableContributors(object);
        return collection != null && collection.size() > 0;
    }

    public static IPreferenceNode[] propertiesContributorsFor(Object object) {
        PropertyPageManager propertyPageManager = new PropertyPageManager();
        if (object == null) {
            return null;
        }
        PropertyPageContributorManager.getManager().contribute(propertyPageManager, object);
        List list = propertyPageManager.getElements(0);
        IPreferenceNode[] iPreferenceNodeArray = new IPreferenceNode[list.size()];
        list.toArray(iPreferenceNodeArray);
        return iPreferenceNodeArray;
    }
}

