/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import com.ibm.icu.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.internal.misc.StringMatcher;

public class PatternFilter
extends ViewerFilter {
    private Map cache = new HashMap();
    private Map foundAnyCache = new HashMap();
    private boolean useCache = false;
    private boolean includeLeadingWildcard = false;
    private StringMatcher matcher;
    private boolean useEarlyReturnIfMatcherIsNull = true;
    private static Object[] EMPTY = new Object[0];

    public Object[] filter(Viewer viewer, Object object, Object[] objectArray) {
        if (this.matcher == null && this.useEarlyReturnIfMatcherIsNull) {
            return objectArray;
        }
        if (!this.useCache) {
            return super.filter(viewer, object, objectArray);
        }
        Object[] objectArray2 = (Object[])this.cache.get(object);
        if (objectArray2 == null) {
            Boolean bl = (Boolean)this.foundAnyCache.get(object);
            objectArray2 = bl != null && bl == false ? EMPTY : super.filter(viewer, object, objectArray);
            this.cache.put(object, objectArray2);
        }
        return objectArray2;
    }

    private boolean isAnyVisible(Viewer viewer, Object object, Object[] objectArray) {
        if (this.matcher == null) {
            return true;
        }
        if (!this.useCache) {
            return this.computeAnyVisible(viewer, objectArray);
        }
        Object[] objectArray2 = (Object[])this.cache.get(object);
        if (objectArray2 != null) {
            return objectArray2.length > 0;
        }
        Boolean bl = (Boolean)this.foundAnyCache.get(object);
        if (bl == null) {
            bl = this.computeAnyVisible(viewer, objectArray) ? Boolean.TRUE : Boolean.FALSE;
            this.foundAnyCache.put(object, bl);
        }
        return bl;
    }

    private boolean computeAnyVisible(Viewer viewer, Object[] objectArray) {
        boolean bl = false;
        int n = 0;
        while (n < objectArray.length && !bl) {
            Object object = objectArray[n];
            bl = this.isElementVisible(viewer, object);
            ++n;
        }
        return bl;
    }

    public final boolean select(Viewer viewer, Object object, Object object2) {
        return this.isElementVisible(viewer, object2);
    }

    public final void setIncludeLeadingWildcard(boolean bl) {
        this.includeLeadingWildcard = bl;
    }

    public void setPattern(String string) {
        if ("org.eclipse.ui.keys.optimization.true".equals(string)) {
            this.useEarlyReturnIfMatcherIsNull = true;
            return;
        }
        if ("org.eclipse.ui.keys.optimization.false".equals(string)) {
            this.useEarlyReturnIfMatcherIsNull = false;
            return;
        }
        this.clearCaches();
        if (string == null || string.equals("")) {
            this.matcher = null;
        } else {
            String string2 = String.valueOf(string) + "*";
            if (this.includeLeadingWildcard) {
                string2 = "*" + string2;
            }
            this.matcher = new StringMatcher(string2, true, false);
        }
    }

    void clearCaches() {
        this.cache.clear();
        this.foundAnyCache.clear();
    }

    private boolean match(String string) {
        if (this.matcher == null) {
            return true;
        }
        return this.matcher.match(string);
    }

    public boolean isElementSelectable(Object object) {
        return object != null;
    }

    public boolean isElementVisible(Viewer viewer, Object object) {
        return this.isParentMatch(viewer, object) || this.isLeafMatch(viewer, object);
    }

    protected boolean isParentMatch(Viewer viewer, Object object) {
        Object[] objectArray = ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getChildren(object);
        if (objectArray != null && objectArray.length > 0) {
            return this.isAnyVisible(viewer, object, objectArray);
        }
        return false;
    }

    protected boolean isLeafMatch(Viewer viewer, Object object) {
        String string = ((ILabelProvider)((StructuredViewer)viewer).getLabelProvider()).getText(object);
        if (string == null) {
            return false;
        }
        return this.wordMatches(string);
    }

    private String[] getWords(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        int n = breakIterator.first();
        while (n != -1 && n < string.length()) {
            int n2 = breakIterator.following(n);
            if (n2 == -1) {
                n2 = string.length();
            }
            if (Character.isLetterOrDigit(string.charAt(n))) {
                String string2 = string.substring(n, n2);
                arrayList.add(string2);
            }
            n = n2;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected boolean wordMatches(String string) {
        if (string == null) {
            return false;
        }
        if (this.match(string)) {
            return true;
        }
        String[] stringArray = this.getWords(string);
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (this.match(string2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void setUseCache(boolean bl) {
        this.useCache = bl;
    }
}

