/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.WorkbenchMessages;

public class ListSelectionDialog
extends SelectionDialog {
    private Object inputElement;
    private ILabelProvider labelProvider;
    private IStructuredContentProvider contentProvider;
    CheckboxTableViewer listViewer;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;

    public ListSelectionDialog(Shell shell, Object object, IStructuredContentProvider iStructuredContentProvider, ILabelProvider iLabelProvider, String string) {
        super(shell);
        this.setTitle(WorkbenchMessages.ListSelection_title);
        this.inputElement = object;
        this.contentProvider = iStructuredContentProvider;
        this.labelProvider = iLabelProvider;
        if (string != null) {
            this.setMessage(string);
        } else {
            this.setMessage(WorkbenchMessages.ListSelection_message);
        }
    }

    private void addSelectionButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(0x1000008, 128, true, false));
        Button button = this.createButton(composite2, 18, SELECT_ALL_TITLE, false);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ListSelectionDialog.this.listViewer.setAllChecked(true);
            }
        };
        button.addSelectionListener((SelectionListener)selectionAdapter);
        Button button2 = this.createButton(composite2, 19, DESELECT_ALL_TITLE, false);
        selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ListSelectionDialog.this.listViewer.setAllChecked(false);
            }
        };
        button2.addSelectionListener((SelectionListener)selectionAdapter);
    }

    private void checkInitialSelections() {
        Iterator iterator = this.getInitialElementSelections().iterator();
        while (iterator.hasNext()) {
            this.listViewer.setChecked(iterator.next(), true);
        }
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.list_selection_dialog_context");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.initializeDialogUnits((Control)composite2);
        this.createMessageArea(composite2);
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite2, (int)2048);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 250;
        gridData.widthHint = 300;
        this.listViewer.getTable().setLayoutData((Object)gridData);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.listViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.addSelectionButtons(composite2);
        this.initializeViewer();
        if (!this.getInitialElementSelections().isEmpty()) {
            this.checkInitialSelections();
        }
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected CheckboxTableViewer getViewer() {
        return this.listViewer;
    }

    private void initializeViewer() {
        this.listViewer.setInput(this.inputElement);
    }

    protected void okPressed() {
        Object[] objectArray = this.contentProvider.getElements(this.inputElement);
        if (objectArray != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                if (this.listViewer.getChecked(object)) {
                    arrayList.add(object);
                }
                ++n;
            }
            this.setResult(arrayList);
        }
        super.okPressed();
    }
}

