/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ListDialog
extends SelectionDialog {
    private IStructuredContentProvider fContentProvider;
    private ILabelProvider fLabelProvider;
    private Object fInput;
    private TableViewer fTableViewer;
    private boolean fAddCancelButton = true;
    private int widthInChars = 55;
    private int heightInChars = 15;

    public ListDialog(Shell shell) {
        super(shell);
    }

    public void setInput(Object object) {
        this.fInput = object;
    }

    public void setContentProvider(IStructuredContentProvider iStructuredContentProvider) {
        this.fContentProvider = iStructuredContentProvider;
    }

    public void setLabelProvider(ILabelProvider iLabelProvider) {
        this.fLabelProvider = iLabelProvider;
    }

    public void setAddCancelButton(boolean bl) {
        this.fAddCancelButton = bl;
    }

    public TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    @Override
    protected void createButtonsForButtonBar(Composite composite) {
        if (!this.fAddCancelButton) {
            this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        } else {
            super.createButtonsForButtonBar(composite);
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.createMessageArea(composite2);
        this.fTableViewer = new TableViewer(composite2, this.getTableStyle());
        this.fTableViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fTableViewer.setInput(this.fInput);
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                if (ListDialog.this.fAddCancelButton) {
                    ListDialog.this.okPressed();
                }
            }
        });
        List list = this.getInitialElementSelections();
        if (list != null) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection(list));
        }
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.convertHeightInCharsToPixels(this.heightInChars);
        gridData.widthHint = this.convertWidthInCharsToPixels(this.widthInChars);
        Table table = this.fTableViewer.getTable();
        table.setLayoutData((Object)gridData);
        table.setFont(composite.getFont());
        return composite2;
    }

    protected int getTableStyle() {
        return 2820;
    }

    protected void okPressed() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTableViewer.getSelection();
        this.setResult(iStructuredSelection.toList());
        super.okPressed();
    }

    public int getHeightInChars() {
        return this.heightInChars;
    }

    public int getWidthInChars() {
        return this.widthInChars;
    }

    public void setHeightInChars(int n) {
        this.heightInChars = n;
    }

    public void setWidthInChars(int n) {
        this.widthInChars = n;
    }
}

