/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.WorkbenchJob;

public class FilteredTree
extends Composite {
    protected Text filterText;
    protected ToolBarManager filterToolBar;
    protected Control clearButtonControl;
    protected TreeViewer treeViewer;
    protected Composite filterComposite;
    private PatternFilter patternFilter;
    protected String initialText = "";
    private Job refreshJob;
    protected Composite parent;
    protected boolean showFilterControls;
    protected Composite treeComposite;
    private boolean useNewLook = false;
    private static final String CLEAR_ICON = "org.eclipse.ui.internal.dialogs.CLEAR_ICON";
    private static final String DISABLED_CLEAR_ICON = "org.eclipse.ui.internal.dialogs.DCLEAR_ICON";
    private static final long SOFT_MAX_EXPAND_TIME = 200L;
    private static Boolean useNativeSearchField;
    private String previousFilterText;
    private boolean narrowingDown;

    static {
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin("org.eclipse.ui", "$nl$/icons/full/etool16/clear_co.gif");
        if (imageDescriptor != null) {
            JFaceResources.getImageRegistry().put(CLEAR_ICON, imageDescriptor);
        }
        if ((imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin("org.eclipse.ui", "$nl$/icons/full/dtool16/clear_co.gif")) != null) {
            JFaceResources.getImageRegistry().put(DISABLED_CLEAR_ICON, imageDescriptor);
        }
    }

    public FilteredTree(Composite composite, int n, PatternFilter patternFilter) {
        super(composite, 0);
        this.parent = composite;
        this.init(n, patternFilter);
    }

    public FilteredTree(Composite composite, int n, PatternFilter patternFilter, boolean bl) {
        super(composite, 0);
        this.parent = composite;
        this.useNewLook = bl;
        this.init(n, patternFilter);
    }

    protected FilteredTree(Composite composite) {
        super(composite, 0);
        this.parent = composite;
    }

    protected FilteredTree(Composite composite, boolean bl) {
        super(composite, 0);
        this.parent = composite;
        this.useNewLook = bl;
    }

    protected void init(int n, PatternFilter patternFilter) {
        this.patternFilter = patternFilter;
        this.showFilterControls = PlatformUI.getPreferenceStore().getBoolean("SHOW_FILTERED_TEXTS");
        this.createControl(this.parent, n);
        this.createRefreshJob();
        this.setInitialText(WorkbenchMessages.FilteredTree_FilterMessage);
        this.setFont(this.parent.getFont());
    }

    protected void createControl(Composite composite, int n) {
        GridLayout gridLayout;
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        this.setLayout((Layout)gridLayout2);
        this.setLayoutData(new GridData(4, 4, true, true));
        if (this.showFilterControls) {
            if (!this.useNewLook || FilteredTree.useNativeSearchField(composite)) {
                this.filterComposite = new Composite((Composite)this, 0);
            } else {
                this.filterComposite = new Composite((Composite)this, 2048);
                this.filterComposite.setBackground(this.getDisplay().getSystemColor(25));
            }
            gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            this.filterComposite.setLayout((Layout)gridLayout);
            this.filterComposite.setFont(composite.getFont());
            this.createFilterControls(this.filterComposite);
            this.filterComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        }
        this.treeComposite = new Composite((Composite)this, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.treeComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, true);
        this.treeComposite.setLayoutData((Object)gridData);
        this.createTreeControl(this.treeComposite, n);
    }

    private static boolean useNativeSearchField(Composite composite) {
        if (useNativeSearchField == null) {
            useNativeSearchField = Boolean.FALSE;
            Text text = null;
            try {
                text = new Text(composite, 384);
                useNativeSearchField = new Boolean((text.getStyle() & 0x100) != 0);
            }
            finally {
                if (text != null) {
                    text.dispose();
                }
            }
        }
        return useNativeSearchField;
    }

    protected Composite createFilterControls(Composite composite) {
        this.createFilterText(composite);
        if (this.useNewLook) {
            this.createClearTextNew(composite);
        } else {
            this.createClearTextOld(composite);
        }
        if (this.clearButtonControl != null) {
            this.clearButtonControl.setVisible(false);
        }
        if (this.filterToolBar != null) {
            this.filterToolBar.update(false);
            this.filterToolBar.getControl().setVisible(false);
        }
        return composite;
    }

    protected Control createTreeControl(Composite composite, int n) {
        this.treeViewer = this.doCreateTreeViewer(composite, n);
        GridData gridData = new GridData(4, 4, true, true);
        this.treeViewer.getControl().setLayoutData((Object)gridData);
        this.treeViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                FilteredTree.this.refreshJob.cancel();
            }
        });
        if (this.treeViewer instanceof NotifyingTreeViewer) {
            this.patternFilter.setUseCache(true);
        }
        this.treeViewer.addFilter((ViewerFilter)this.patternFilter);
        return this.treeViewer.getControl();
    }

    protected TreeViewer doCreateTreeViewer(Composite composite, int n) {
        return new NotifyingTreeViewer(composite, n);
    }

    private TreeItem getFirstMatchingItem(TreeItem[] treeItemArray) {
        int n = 0;
        while (n < treeItemArray.length) {
            if (this.patternFilter.isLeafMatch((Viewer)this.treeViewer, treeItemArray[n].getData()) && this.patternFilter.isElementSelectable(treeItemArray[n].getData())) {
                return treeItemArray[n];
            }
            TreeItem treeItem = this.getFirstMatchingItem(treeItemArray[n].getItems());
            if (treeItem != null) {
                return treeItem;
            }
            ++n;
        }
        return null;
    }

    private void createRefreshJob() {
        this.refreshJob = this.doCreateRefreshJob();
        this.refreshJob.setSystem(true);
    }

    protected WorkbenchJob doCreateRefreshJob() {
        return new WorkbenchJob("Refresh Filter"){

            @Override
            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                boolean bl;
                if (FilteredTree.this.treeViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                String string = FilteredTree.this.getFilterString();
                if (string == null) {
                    return Status.OK_STATUS;
                }
                boolean bl2 = bl = FilteredTree.this.initialText != null && FilteredTree.this.initialText.equals(string);
                if (bl) {
                    FilteredTree.this.patternFilter.setPattern(null);
                } else if (string != null) {
                    FilteredTree.this.patternFilter.setPattern(string);
                }
                Composite composite = FilteredTree.this.treeComposite != null ? FilteredTree.this.treeComposite : FilteredTree.this.treeViewer.getControl();
                try {
                    int n;
                    TreeItem[] treeItemArray;
                    composite.setRedraw(false);
                    if (!FilteredTree.this.narrowingDown) {
                        treeItemArray = FilteredTree.this.treeViewer.getTree().getItems();
                        n = 0;
                        while (n < treeItemArray.length) {
                            TreeItem treeItem = treeItemArray[n];
                            if (treeItem.getExpanded()) {
                                FilteredTree.this.treeViewer.setExpandedState(treeItem.getData(), false);
                            }
                            ++n;
                        }
                    }
                    FilteredTree.this.treeViewer.refresh(true);
                    if (string.length() > 0 && !bl) {
                        treeItemArray = FilteredTree.this.getViewer().getTree().getItems();
                        n = FilteredTree.this.getViewer().getTree().getBounds().height;
                        int n2 = n / FilteredTree.this.getViewer().getTree().getItemHeight();
                        long l = 200L + System.currentTimeMillis();
                        boolean bl3 = false;
                        if (treeItemArray.length > 0 && this.recursiveExpand(treeItemArray, iProgressMonitor, l, new int[]{n2})) {
                            bl3 = true;
                        }
                        FilteredTree.this.updateToolbar(true);
                        if (bl3) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                    } else {
                        FilteredTree.this.updateToolbar(false);
                    }
                }
                finally {
                    TreeItem[] treeItemArray = FilteredTree.this.getViewer().getTree().getItems();
                    if (treeItemArray.length > 0 && FilteredTree.this.getViewer().getTree().getSelectionCount() == 0) {
                        FilteredTree.this.treeViewer.getTree().setTopItem(treeItemArray[0]);
                    }
                    composite.setRedraw(true);
                }
                return Status.OK_STATUS;
            }

            private boolean recursiveExpand(TreeItem[] treeItemArray, IProgressMonitor iProgressMonitor, long l, int[] nArray) {
                boolean bl = false;
                int n = 0;
                while (!bl && n < treeItemArray.length) {
                    boolean bl2;
                    TreeItem treeItem = treeItemArray[n];
                    int n2 = nArray[0];
                    nArray[0] = n2 - 1;
                    boolean bl3 = bl2 = n2 >= 0;
                    if (iProgressMonitor.isCanceled() || !bl2 && System.currentTimeMillis() > l) {
                        bl = true;
                    } else {
                        Object object = treeItem.getData();
                        if (object != null) {
                            if (!treeItem.getExpanded()) {
                                FilteredTree.this.treeViewer.setExpandedState(object, true);
                            }
                            TreeItem[] treeItemArray2 = treeItem.getItems();
                            if (treeItemArray.length > 0) {
                                bl = this.recursiveExpand(treeItemArray2, iProgressMonitor, l, nArray);
                            }
                        }
                    }
                    ++n;
                }
                return bl;
            }
        };
    }

    protected void updateToolbar(boolean bl) {
        if (this.clearButtonControl != null) {
            this.clearButtonControl.setVisible(bl);
        }
        if (this.filterToolBar != null) {
            this.filterToolBar.getControl().setVisible(bl);
        }
    }

    protected void createFilterText(Composite composite) {
        this.filterText = this.doCreateFilterText(composite);
        this.filterText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                String string = FilteredTree.this.filterText.getText();
                accessibleEvent.result = string.length() == 0 || string.equals(FilteredTree.this.initialText) ? FilteredTree.this.initialText : NLS.bind((String)WorkbenchMessages.FilteredTree_AccessibleListenerFiltered, (Object[])new String[]{string, String.valueOf(this.getFilteredItemsCount())});
            }

            private int getFilteredItemsCount() {
                int n = 0;
                TreeItem[] treeItemArray = FilteredTree.this.getViewer().getTree().getItems();
                int n2 = 0;
                while (n2 < treeItemArray.length) {
                    n += this.itemCount(treeItemArray[n2]);
                    ++n2;
                }
                return n;
            }

            private int itemCount(TreeItem treeItem) {
                int n = 1;
                TreeItem[] treeItemArray = treeItem.getItems();
                int n2 = 0;
                while (n2 < treeItemArray.length) {
                    n += this.itemCount(treeItemArray[n2]);
                    ++n2;
                }
                return n;
            }
        });
        this.filterText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                if (!FilteredTree.this.useNewLook) {
                    Display display = FilteredTree.this.filterText.getDisplay();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!(this).FilteredTree.this.filterText.isDisposed() && FilteredTree.this.getInitialText().equals((this).FilteredTree.this.filterText.getText().trim())) {
                                (this).FilteredTree.this.filterText.selectAll();
                            }
                        }
                    });
                    return;
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                if (!FilteredTree.this.useNewLook) {
                    return;
                }
                if (FilteredTree.this.filterText.getText().equals(FilteredTree.this.initialText)) {
                    FilteredTree.this.setFilterText("");
                    FilteredTree.this.textChanged();
                }
            }
        });
        if (this.useNewLook) {
            this.filterText.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent mouseEvent) {
                    if (FilteredTree.this.filterText.getText().equals(FilteredTree.this.initialText)) {
                        FilteredTree.this.setFilterText("");
                        FilteredTree.this.textChanged();
                    }
                }
            });
        }
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                boolean bl;
                boolean bl2 = bl = FilteredTree.this.getViewer().getTree().getItemCount() > 0;
                if (bl && keyEvent.keyCode == 0x1000002) {
                    FilteredTree.this.treeViewer.getTree().setFocus();
                    return;
                }
            }
        });
        this.filterText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 4) {
                    traverseEvent.doit = false;
                    if (FilteredTree.this.getViewer().getTree().getItemCount() == 0) {
                        Display.getCurrent().beep();
                    } else {
                        Tree tree;
                        TreeItem treeItem;
                        boolean bl;
                        boolean bl2 = FilteredTree.this.getViewer().getTree().setFocus();
                        boolean bl3 = bl = !FilteredTree.this.getInitialText().equals(FilteredTree.this.filterText.getText().trim());
                        if (bl2 && bl && FilteredTree.this.filterText.getText().trim().length() > 0 && (treeItem = (tree = FilteredTree.this.getViewer().getTree()).getSelectionCount() > 0 ? FilteredTree.this.getFirstMatchingItem(tree.getSelection()) : FilteredTree.this.getFirstMatchingItem(tree.getItems())) != null) {
                            tree.setSelection(new TreeItem[]{treeItem});
                            ISelection iSelection = FilteredTree.this.getViewer().getSelection();
                            FilteredTree.this.getViewer().setSelection(iSelection, true);
                        }
                    }
                }
            }
        });
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                FilteredTree.this.textChanged();
            }
        });
        if ((this.filterText.getStyle() & 0x100) != 0) {
            this.filterText.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    if (selectionEvent.detail == 256) {
                        FilteredTree.this.clearText();
                    }
                }
            });
        }
        GridData gridData = new GridData(4, 0x1000000, true, false);
        if ((this.filterText.getStyle() & 0x100) != 0) {
            gridData.horizontalSpan = 2;
        }
        this.filterText.setLayoutData((Object)gridData);
    }

    protected Text doCreateFilterText(Composite composite) {
        if (!this.useNewLook || FilteredTree.useNativeSearchField(composite)) {
            return new Text(composite, 2436);
        }
        return new Text(composite, 4);
    }

    protected void textChanged() {
        this.narrowingDown = this.previousFilterText == null || this.previousFilterText.equals(WorkbenchMessages.FilteredTree_FilterMessage) || this.getFilterString().startsWith(this.previousFilterText);
        this.previousFilterText = this.getFilterString();
        this.refreshJob.cancel();
        this.refreshJob.schedule(this.getRefreshJobDelay());
    }

    protected long getRefreshJobDelay() {
        return 200L;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.filterComposite != null && (!this.useNewLook || FilteredTree.useNativeSearchField(this.filterComposite))) {
            this.filterComposite.setBackground(color);
        }
        if (this.filterToolBar != null && this.filterToolBar.getControl() != null) {
            this.filterToolBar.getControl().setBackground(color);
        }
    }

    private void createClearTextOld(Composite composite) {
        if ((this.filterText.getStyle() & 0x100) == 0) {
            this.filterToolBar = new ToolBarManager(0x800100);
            this.filterToolBar.createControl(composite);
            Action action = new Action("", 1){

                public void run() {
                    FilteredTree.this.clearText();
                }
            };
            action.setToolTipText(WorkbenchMessages.FilteredTree_ClearToolTip);
            action.setImageDescriptor(JFaceResources.getImageRegistry().getDescriptor(CLEAR_ICON));
            action.setDisabledImageDescriptor(JFaceResources.getImageRegistry().getDescriptor(DISABLED_CLEAR_ICON));
            this.filterToolBar.add((IAction)action);
        }
    }

    private void createClearTextNew(Composite composite) {
        if ((this.filterText.getStyle() & 0x100) == 0) {
            final Image image = JFaceResources.getImageRegistry().getDescriptor(DISABLED_CLEAR_ICON).createImage();
            final Image image2 = JFaceResources.getImageRegistry().getDescriptor(CLEAR_ICON).createImage();
            final Image image3 = new Image((Device)this.getDisplay(), image2, 2);
            final Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            label.setImage(image);
            label.setBackground(composite.getDisplay().getSystemColor(25));
            label.setToolTipText(WorkbenchMessages.FilteredTree_ClearToolTip);
            label.addMouseListener((MouseListener)new MouseAdapter(){
                private MouseMoveListener fMoveListener;

                public void mouseDown(MouseEvent mouseEvent) {
                    label.setImage(image3);
                    this.fMoveListener = new MouseMoveListener(){
                        private boolean fMouseInButton = true;

                        public void mouseMove(MouseEvent mouseEvent) {
                            boolean bl = this.isMouseInButton(mouseEvent);
                            if (bl != this.fMouseInButton) {
                                this.fMouseInButton = bl;
                                label.setImage(bl ? image3 : image);
                            }
                        }
                    };
                    label.addMouseMoveListener(this.fMoveListener);
                }

                public void mouseUp(MouseEvent mouseEvent) {
                    if (this.fMoveListener != null) {
                        label.removeMouseMoveListener(this.fMoveListener);
                        this.fMoveListener = null;
                        boolean bl = this.isMouseInButton(mouseEvent);
                        label.setImage(bl ? image2 : image);
                        if (bl) {
                            FilteredTree.this.clearText();
                            FilteredTree.this.filterText.setFocus();
                        }
                    }
                }

                private boolean isMouseInButton(MouseEvent mouseEvent) {
                    Point point = label.getSize();
                    return mouseEvent.x >= 0 && mouseEvent.x < point.x && mouseEvent.y >= 0 && mouseEvent.y < point.y;
                }
            });
            label.addMouseTrackListener(new MouseTrackListener(){

                public void mouseEnter(MouseEvent mouseEvent) {
                    label.setImage(image2);
                }

                public void mouseExit(MouseEvent mouseEvent) {
                    label.setImage(image);
                }

                public void mouseHover(MouseEvent mouseEvent) {
                }
            });
            label.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    image.dispose();
                    image2.dispose();
                    image3.dispose();
                }
            });
            label.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent accessibleEvent) {
                    accessibleEvent.result = WorkbenchMessages.FilteredTree_AccessibleListenerClearButton;
                }
            });
            label.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

                public void getRole(AccessibleControlEvent accessibleControlEvent) {
                    accessibleControlEvent.detail = 43;
                }
            });
            this.clearButtonControl = label;
        }
    }

    protected void clearText() {
        this.setFilterText("");
        this.textChanged();
    }

    protected void setFilterText(String string) {
        if (this.filterText != null) {
            this.filterText.setText(string);
            this.selectAll();
        }
    }

    public final PatternFilter getPatternFilter() {
        return this.patternFilter;
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public Text getFilterControl() {
        return this.filterText;
    }

    protected String getFilterString() {
        return this.filterText != null ? this.filterText.getText() : null;
    }

    public void setInitialText(String string) {
        this.initialText = string;
        if (this.useNewLook && this.filterText != null) {
            this.filterText.setMessage(string);
            if (this.filterText.isFocusControl()) {
                this.setFilterText(this.initialText);
                this.textChanged();
            } else {
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!FilteredTree.this.filterText.isDisposed() && FilteredTree.this.filterText.isFocusControl()) {
                            FilteredTree.this.setFilterText(FilteredTree.this.initialText);
                            FilteredTree.this.textChanged();
                        }
                    }
                });
            }
        } else {
            this.setFilterText(this.initialText);
            this.textChanged();
        }
    }

    protected void selectAll() {
        if (this.filterText != null) {
            this.filterText.selectAll();
        }
    }

    protected String getInitialText() {
        return this.initialText;
    }

    public static Font getBoldFont(Object object, FilteredTree filteredTree, PatternFilter patternFilter) {
        String string = filteredTree.getFilterString();
        if (string == null) {
            return null;
        }
        String string2 = filteredTree.getInitialText();
        if (!string.equals("") && !string.equals(string2)) {
            if (filteredTree.getPatternFilter() != patternFilter) {
                boolean bl;
                boolean bl2 = bl = string2 != null && string2.equals(string);
                if (bl) {
                    patternFilter.setPattern(null);
                } else if (string != null) {
                    patternFilter.setPattern(string);
                }
            }
            if (patternFilter.isElementVisible((Viewer)filteredTree.getViewer(), object) && patternFilter.isLeafMatch((Viewer)filteredTree.getViewer(), object)) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
        }
        return null;
    }

    class NotifyingTreeViewer
    extends TreeViewer {
        public NotifyingTreeViewer(Composite composite, int n) {
            super(composite, n);
        }

        public void add(Object object, Object object2) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.add(object, object2);
        }

        public void add(Object object, Object[] objectArray) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.add(object, objectArray);
        }

        protected void inputChanged(Object object, Object object2) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.inputChanged(object, object2);
        }

        public void insert(Object object, Object object2, int n) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.insert(object, object2, n);
        }

        public void refresh() {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.refresh();
        }

        public void refresh(boolean bl) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.refresh(bl);
        }

        public void refresh(Object object) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.refresh(object);
        }

        public void refresh(Object object, boolean bl) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.refresh(object, bl);
        }

        public void remove(Object object) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.remove(object);
        }

        public void remove(Object object, Object[] objectArray) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.remove(object, objectArray);
        }

        public void remove(Object[] objectArray) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.remove(objectArray);
        }

        public void replace(Object object, int n, Object object2) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.replace(object, n, object2);
        }

        public void setChildCount(Object object, int n) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.setChildCount(object, n);
        }

        public void setContentProvider(IContentProvider iContentProvider) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.setContentProvider(iContentProvider);
        }

        public void setHasChildren(Object object, boolean bl) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.setHasChildren(object, bl);
        }
    }
}

