/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Vector;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.TwoArrayQuickSorter;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.misc.StringMatcher;
import org.eclipse.ui.progress.WorkbenchJob;

public class FilteredList
extends Composite {
    private Table fList;
    ILabelProvider fLabelProvider;
    private boolean fMatchEmptyString = true;
    private boolean fIgnoreCase;
    private boolean fAllowDuplicates;
    private String fFilter = "";
    private TwoArrayQuickSorter fSorter;
    Object[] fElements = new Object[0];
    Label[] fLabels;
    Vector fImages = new Vector();
    int[] fFoldedIndices;
    int fFoldedCount;
    int[] fFilteredIndices;
    int fFilteredCount;
    private FilterMatcher fFilterMatcher = new DefaultFilterMatcher();
    Comparator fComparator;
    TableUpdateJob fUpdateJob;

    public FilteredList(Composite composite, int n, ILabelProvider iLabelProvider, boolean bl, boolean bl2, boolean bl3) {
        super(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.fList = new Table((Composite)this, n);
        this.fList.setLayoutData((Object)new GridData(1808));
        this.fList.setFont(composite.getFont());
        this.fList.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                FilteredList.this.fLabelProvider.dispose();
                if (FilteredList.this.fUpdateJob != null) {
                    FilteredList.this.fUpdateJob.cancel();
                }
            }
        });
        this.fLabelProvider = iLabelProvider;
        this.fIgnoreCase = bl;
        this.fSorter = new TwoArrayQuickSorter(new LabelComparator(bl));
        this.fAllowDuplicates = bl2;
        this.fMatchEmptyString = bl3;
    }

    public void setElements(Object[] objectArray) {
        if (objectArray == null) {
            this.fElements = new Object[0];
        } else {
            this.fElements = new Object[objectArray.length];
            System.arraycopy(objectArray, 0, this.fElements, 0, objectArray.length);
        }
        int n = this.fElements.length;
        this.fLabels = new Label[n];
        HashSet<Image> hashSet = new HashSet<Image>();
        int n2 = 0;
        while (n2 != n) {
            String string = this.fLabelProvider.getText(this.fElements[n2]);
            Image image = this.fLabelProvider.getImage(this.fElements[n2]);
            this.fLabels[n2] = new Label(string, image);
            hashSet.add(image);
            ++n2;
        }
        this.fImages.clear();
        this.fImages.addAll(hashSet);
        this.fSorter.sort(this.fLabels, this.fElements);
        this.fFilteredIndices = new int[n];
        this.fFoldedIndices = new int[n];
        this.updateList();
    }

    public boolean isEmpty() {
        return this.fElements == null || this.fElements.length == 0;
    }

    public void setFilterMatcher(FilterMatcher filterMatcher) {
        Assert.isNotNull((Object)filterMatcher);
        this.fFilterMatcher = filterMatcher;
    }

    public void setComparator(Comparator comparator) {
        Assert.isNotNull((Object)comparator);
        this.fComparator = comparator;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.fList.addSelectionListener(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.fList.removeSelectionListener(selectionListener);
    }

    public void setSelection(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            this.fList.deselectAll();
        } else if (this.fUpdateJob == null) {
            this.fList.setSelection(nArray);
            this.fList.notifyListeners(13, new Event());
        } else {
            this.fUpdateJob.updateSelection(nArray);
        }
    }

    public int[] getSelectionIndices() {
        return this.fList.getSelectionIndices();
    }

    public int getSelectionIndex() {
        return this.fList.getSelectionIndex();
    }

    public void setSelection(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            this.fList.deselectAll();
            return;
        }
        if (this.fElements == null) {
            return;
        }
        int[] nArray = new int[objectArray.length];
        int n = 0;
        while (n != objectArray.length) {
            int n2 = 0;
            while (n2 != this.fFoldedCount) {
                int n3 = n2 == this.fFoldedCount - 1 ? this.fFilteredCount : this.fFoldedIndices[n2 + 1];
                int n4 = this.fFoldedIndices[n2];
                while (n4 != n3) {
                    if (this.fElements[this.fFilteredIndices[n4]].equals(objectArray[n])) {
                        nArray[n] = n2;
                        break;
                    }
                    ++n4;
                }
                if (n4 != n3) break;
                ++n2;
            }
            if (n2 == this.fFoldedCount) {
                nArray[n] = 0;
            }
            ++n;
        }
        this.setSelection(nArray);
    }

    public Object[] getSelection() {
        if (this.fList.isDisposed() || this.fList.getSelectionCount() == 0) {
            return new Object[0];
        }
        int[] nArray = this.fList.getSelectionIndices();
        Object[] objectArray = new Object[nArray.length];
        int n = 0;
        while (n != nArray.length) {
            objectArray[n] = this.fElements[this.fFilteredIndices[this.fFoldedIndices[nArray[n]]]];
            ++n;
        }
        return objectArray;
    }

    public void setFilter(String string) {
        this.fFilter = string == null ? "" : string;
        this.updateList();
    }

    private void updateList() {
        this.fFilteredCount = this.filter();
        this.fFoldedCount = this.fold();
        if (this.fUpdateJob != null) {
            this.fUpdateJob.cancel();
        }
        this.fUpdateJob = new TableUpdateJob(this.fList, this.fFoldedCount);
        this.fUpdateJob.schedule();
    }

    public String getFilter() {
        return this.fFilter;
    }

    public Object[] getFoldedElements(int n) {
        if (n < 0 || n >= this.fFoldedCount) {
            return null;
        }
        int n2 = this.fFoldedIndices[n];
        int n3 = n == this.fFoldedCount - 1 ? this.fFilteredCount - n2 : this.fFoldedIndices[n + 1] - n2;
        Object[] objectArray = new Object[n3];
        int n4 = 0;
        while (n4 != n3) {
            objectArray[n4] = this.fElements[this.fFilteredIndices[n2 + n4]];
            ++n4;
        }
        return objectArray;
    }

    private int fold() {
        if (this.fAllowDuplicates) {
            int n = 0;
            while (n != this.fFilteredCount) {
                this.fFoldedIndices[n] = n;
                ++n;
            }
            return this.fFilteredCount;
        }
        int n = 0;
        Label label = null;
        int n2 = 0;
        while (n2 != this.fFilteredCount) {
            int n3 = this.fFilteredIndices[n2];
            Label label2 = this.fLabels[n3];
            if (!label2.equals(label)) {
                this.fFoldedIndices[n] = n2;
                ++n;
                label = label2;
            }
            ++n2;
        }
        return n;
    }

    private int filter() {
        if (!(this.fFilter != null && this.fFilter.length() != 0 || this.fMatchEmptyString)) {
            return 0;
        }
        this.fFilterMatcher.setFilter(this.fFilter.trim(), this.fIgnoreCase, false);
        int n = 0;
        int n2 = 0;
        while (n2 != this.fElements.length) {
            if (this.fFilterMatcher.match(this.fElements[n2])) {
                this.fFilteredIndices[n++] = n2;
            }
            ++n2;
        }
        return n;
    }

    public boolean getAllowDuplicates() {
        return this.fAllowDuplicates;
    }

    public void setAllowDuplicates(boolean bl) {
        this.fAllowDuplicates = bl;
    }

    public boolean getIgnoreCase() {
        return this.fIgnoreCase;
    }

    public void setIgnoreCase(boolean bl) {
        this.fIgnoreCase = bl;
    }

    public boolean getMatchEmptyString() {
        return this.fMatchEmptyString;
    }

    public void setMatchEmptyString(boolean bl) {
        this.fMatchEmptyString = bl;
    }

    public ILabelProvider getLabelProvider() {
        return this.fLabelProvider;
    }

    public void setLabelProvider(ILabelProvider iLabelProvider) {
        this.fLabelProvider = iLabelProvider;
    }

    public Accessible getAccessible() {
        return this.fList.getAccessible();
    }

    private class DefaultFilterMatcher
    implements FilterMatcher {
        private StringMatcher fMatcher;

        private DefaultFilterMatcher() {
        }

        @Override
        public void setFilter(String string, boolean bl, boolean bl2) {
            this.fMatcher = new StringMatcher(String.valueOf(string) + '*', bl, bl2);
        }

        @Override
        public boolean match(Object object) {
            return this.fMatcher.match(FilteredList.this.fLabelProvider.getText(object));
        }
    }

    public static interface FilterMatcher {
        public void setFilter(String var1, boolean var2, boolean var3);

        public boolean match(Object var1);
    }

    private static class Label {
        public final String string;
        public final Image image;

        public Label(String string, Image image) {
            this.string = string == null ? "" : string;
            this.image = image;
        }

        public boolean equals(Label label) {
            if (label == null) {
                return false;
            }
            if (this.string == null && label.string != null) {
                return false;
            }
            if (this.string != null && !this.string.equals(label.string)) {
                return false;
            }
            if (this.image == null) {
                return label.image == null;
            }
            return this.image.equals((Object)label.image);
        }
    }

    private final class LabelComparator
    implements Comparator {
        private boolean labelIgnoreCase;

        LabelComparator(boolean bl) {
            this.labelIgnoreCase = bl;
        }

        public int compare(Object object, Object object2) {
            Label label = (Label)object;
            Label label2 = (Label)object2;
            int n = FilteredList.this.fComparator == null ? (this.labelIgnoreCase ? label.string.compareToIgnoreCase(label2.string) : label.string.compareTo(label2.string)) : FilteredList.this.fComparator.compare(label.string, label2.string);
            if (n != 0) {
                return n;
            }
            if (label.image == null) {
                return label2.image == null ? 0 : -1;
            }
            if (label2.image == null) {
                return 1;
            }
            return FilteredList.this.fImages.indexOf(label.image) - FilteredList.this.fImages.indexOf(label2.image);
        }
    }

    private class TableUpdateJob
    extends WorkbenchJob {
        final Table fTable;
        final int fCount;
        private int currentIndex;
        int[] indicesToSelect;
        private boolean readyForSelection;

        public TableUpdateJob(Table table, int n) {
            super(WorkbenchMessages.FilteredList_UpdateJobName);
            this.currentIndex = 0;
            this.readyForSelection = false;
            this.setSystem(true);
            this.fTable = table;
            this.fCount = n;
        }

        @Override
        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            if (this.fTable.isDisposed()) {
                return Status.CANCEL_STATUS;
            }
            int n = this.fTable.getItemCount();
            if (this.fCount < n) {
                this.fTable.setRedraw(false);
                this.fTable.remove(this.fCount, n - 1);
                this.fTable.setRedraw(true);
                n = this.fTable.getItemCount();
            }
            if (this.fCount == 0) {
                this.fTable.notifyListeners(13, new Event());
                return Status.OK_STATUS;
            }
            int n2 = Math.min(10, this.fCount - this.currentIndex);
            int n3 = 0;
            while (n3 < n2) {
                if (iProgressMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                TableItem tableItem = this.currentIndex < n ? this.fTable.getItem(this.currentIndex) : new TableItem(this.fTable, 0);
                Label label = FilteredList.this.fLabels[FilteredList.this.fFilteredIndices[FilteredList.this.fFoldedIndices[this.currentIndex]]];
                tableItem.setText(label.string);
                tableItem.setImage(label.image);
                ++this.currentIndex;
                ++n3;
            }
            if (iProgressMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (this.currentIndex < this.fCount) {
                this.schedule(100L);
            } else {
                if (this.indicesToSelect == null) {
                    if (this.fCount > 0) {
                        if (this.fTable.getSelectionIndices().length == 0) {
                            this.defaultSelect();
                        } else {
                            this.fTable.notifyListeners(13, new Event());
                        }
                    }
                } else {
                    this.selectAndNotify(this.indicesToSelect);
                }
                this.readyForSelection = true;
            }
            return Status.OK_STATUS;
        }

        void updateSelection(int[] nArray) {
            this.indicesToSelect = nArray;
            if (this.readyForSelection) {
                this.selectAndNotify(nArray);
            }
        }

        private void defaultSelect() {
            this.selectAndNotify(new int[1]);
        }

        private void selectAndNotify(int[] nArray) {
            if (this.fTable.isDisposed()) {
                return;
            }
            this.fTable.setSelection(nArray);
            this.fTable.notifyListeners(13, new Event());
        }
    }
}

