/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class FilteredItemsSelectionDialog
extends SelectionStatusDialog {
    private static final String DIALOG_BOUNDS_SETTINGS = "DialogBoundsSettings";
    private static final String SHOW_STATUS_LINE = "ShowStatusLine";
    private static final String HISTORY_SETTINGS = "History";
    private static final String DIALOG_HEIGHT = "DIALOG_HEIGHT";
    private static final String DIALOG_WIDTH = "DIALOG_WIDTH";
    public static final int NONE = 0;
    public static final int CARET_BEGINNING = 1;
    public static final int FULL_SELECTION = 2;
    private Text pattern;
    private TableViewer list;
    private DetailsContentViewer details;
    private ILabelProvider detailsLabelProvider;
    private ItemsListLabelProvider itemsListLabelProvider;
    private MenuManager menuManager;
    private MenuManager contextMenuManager;
    private boolean multi;
    private ToolBar toolBar;
    private ToolItem toolItem;
    private Label progressLabel;
    private ToggleStatusLineAction toggleStatusLineAction;
    private RemoveHistoryItemAction removeHistoryItemAction;
    private ActionContributionItem removeHistoryActionContributionItem;
    private IStatus status;
    private RefreshCacheJob refreshCacheJob;
    private RefreshProgressMessageJob refreshProgressMessageJob = new RefreshProgressMessageJob();
    private Object[] currentSelection;
    private ContentProvider contentProvider;
    private FilterHistoryJob filterHistoryJob;
    private FilterJob filterJob;
    private ItemsFilter filter;
    private List lastCompletedResult;
    private ItemsFilter lastCompletedFilter;
    private String initialPatternText;
    private int selectionMode;
    private ItemsListSeparator itemsListSeparator;
    private static final String EMPTY_STRING = "";
    private boolean refreshWithLastSelection = false;
    private IHandlerActivation showViewHandler;

    public FilteredItemsSelectionDialog(Shell shell, boolean bl) {
        super(shell);
        this.multi = bl;
        this.filterHistoryJob = new FilterHistoryJob();
        this.filterJob = new FilterJob();
        this.contentProvider = new ContentProvider();
        this.refreshCacheJob = new RefreshCacheJob();
        this.itemsListSeparator = new ItemsListSeparator(WorkbenchMessages.FilteredItemsSelectionDialog_separatorLabel);
        this.selectionMode = 0;
    }

    public FilteredItemsSelectionDialog(Shell shell) {
        this(shell, false);
    }

    protected void addListFilter(ViewerFilter viewerFilter) {
        this.contentProvider.addFilter(viewerFilter);
    }

    public void setListLabelProvider(ILabelProvider iLabelProvider) {
        this.getItemsListLabelProvider().setProvider(iLabelProvider);
    }

    private ILabelDecorator getListSelectionLabelDecorator() {
        return this.getItemsListLabelProvider().getSelectionDecorator();
    }

    public void setListSelectionLabelDecorator(ILabelDecorator iLabelDecorator) {
        this.getItemsListLabelProvider().setSelectionDecorator(iLabelDecorator);
    }

    private ItemsListLabelProvider getItemsListLabelProvider() {
        if (this.itemsListLabelProvider == null) {
            this.itemsListLabelProvider = new ItemsListLabelProvider((ILabelProvider)new LabelProvider(), null);
        }
        return this.itemsListLabelProvider;
    }

    public void setDetailsLabelProvider(ILabelProvider iLabelProvider) {
        this.detailsLabelProvider = iLabelProvider;
        if (this.details != null) {
            this.details.setLabelProvider((IBaseLabelProvider)iLabelProvider);
        }
    }

    private ILabelProvider getDetailsLabelProvider() {
        if (this.detailsLabelProvider == null) {
            this.detailsLabelProvider = new LabelProvider();
        }
        return this.detailsLabelProvider;
    }

    @Override
    public void create() {
        super.create();
        this.pattern.setFocus();
    }

    protected void restoreDialog(IDialogSettings iDialogSettings) {
        boolean bl = true;
        if (iDialogSettings.get(SHOW_STATUS_LINE) != null) {
            bl = iDialogSettings.getBoolean(SHOW_STATUS_LINE);
        }
        this.toggleStatusLineAction.setChecked(bl);
        this.details.setVisible(bl);
        String string = iDialogSettings.get(HISTORY_SETTINGS);
        if (string != null) {
            try {
                XMLMemento xMLMemento = XMLMemento.createReadRoot(new StringReader(string));
                this.contentProvider.loadHistory(xMLMemento);
            }
            catch (WorkbenchException workbenchException) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.ui", 4, WorkbenchMessages.FilteredItemsSelectionDialog_restoreError, (Throwable)((Object)workbenchException)));
            }
        }
    }

    public boolean close() {
        this.filterJob.cancel();
        this.refreshCacheJob.cancel();
        this.refreshProgressMessageJob.cancel();
        if (this.showViewHandler != null) {
            IHandlerService iHandlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            iHandlerService.deactivateHandler(this.showViewHandler);
            this.showViewHandler.getHandler().dispose();
            this.showViewHandler = null;
        }
        if (this.menuManager != null) {
            this.menuManager.dispose();
        }
        if (this.contextMenuManager != null) {
            this.contextMenuManager.dispose();
        }
        this.storeDialog(this.getDialogSettings());
        return super.close();
    }

    protected void storeDialog(IDialogSettings iDialogSettings) {
        iDialogSettings.put(SHOW_STATUS_LINE, this.toggleStatusLineAction.isChecked());
        XMLMemento xMLMemento = XMLMemento.createWriteRoot(HISTORY_SETTINGS);
        this.contentProvider.saveHistory(xMLMemento);
        StringWriter stringWriter = new StringWriter();
        try {
            xMLMemento.save(stringWriter);
            iDialogSettings.put(HISTORY_SETTINGS, stringWriter.getBuffer().toString());
        }
        catch (IOException iOException) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.ui", 4, WorkbenchMessages.FilteredItemsSelectionDialog_storeError, (Throwable)iOException));
        }
    }

    private Label createHeader(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(this.getMessage() != null && this.getMessage().trim().length() > 0 ? this.getMessage() : WorkbenchMessages.FilteredItemsSelectionDialog_patternLabel);
        label.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 128 && traverseEvent.doit) {
                    traverseEvent.detail = 0;
                    FilteredItemsSelectionDialog.this.pattern.setFocus();
                }
            }
        });
        GridData gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        this.createViewMenu(composite2);
        composite2.setLayoutData((Object)gridData);
        return label;
    }

    private Label createLabels(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(WorkbenchMessages.FilteredItemsSelectionDialog_listLabel);
        label.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 128 && traverseEvent.doit) {
                    traverseEvent.detail = 0;
                    FilteredItemsSelectionDialog.this.list.getTable().setFocus();
                }
            }
        });
        GridData gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        this.progressLabel = new Label(composite2, 131072);
        this.progressLabel.setLayoutData((Object)gridData);
        composite2.setLayoutData((Object)gridData);
        return label;
    }

    private void createViewMenu(Composite composite) {
        this.toolBar = new ToolBar(composite, 0x800000);
        this.toolItem = new ToolItem(this.toolBar, 8, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 3;
        this.toolBar.setLayoutData((Object)gridData);
        this.toolBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                FilteredItemsSelectionDialog.this.showViewMenu();
            }
        });
        this.toolItem.setImage(WorkbenchImages.getImage("IMG_LCL_VIEW_MENU"));
        this.toolItem.setToolTipText(WorkbenchMessages.FilteredItemsSelectionDialog_menu);
        this.toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FilteredItemsSelectionDialog.this.showViewMenu();
            }
        });
        this.menuManager = new MenuManager();
        this.fillViewMenu((IMenuManager)this.menuManager);
        IHandlerService iHandlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        AbstractHandler abstractHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent executionEvent) {
                FilteredItemsSelectionDialog.this.showViewMenu();
                return null;
            }
        };
        this.showViewHandler = iHandlerService.activateHandler("org.eclipse.ui.window.showViewMenu", (IHandler)abstractHandler, new ActiveShellExpression(this.getShell()));
    }

    protected void fillViewMenu(IMenuManager iMenuManager) {
        this.toggleStatusLineAction = new ToggleStatusLineAction();
        iMenuManager.add((IAction)this.toggleStatusLineAction);
    }

    private void showViewMenu() {
        Menu menu = this.menuManager.createContextMenu((Control)this.getShell());
        Rectangle rectangle = this.toolItem.getBounds();
        Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
        point = this.toolBar.toDisplay(point);
        menu.setLocation(point.x, point.y);
        menu.setVisible(true);
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        List list = ((StructuredSelection)this.list.getSelection()).toList();
        Object var3_32 = null;
        for (Object var3_32 : list) {
            if (!(var3_32 instanceof ItemsListSeparator) && this.isHistoryElement(var3_32)) continue;
            return;
        }
        if (list.size() > 0) {
            this.removeHistoryItemAction.setText(WorkbenchMessages.FilteredItemsSelectionDialog_removeItemsFromHistoryAction);
            iMenuManager.add((IContributionItem)this.removeHistoryActionContributionItem);
        }
    }

    private void createPopupMenu() {
        this.removeHistoryItemAction = new RemoveHistoryItemAction();
        this.removeHistoryActionContributionItem = new ActionContributionItem((IAction)this.removeHistoryItemAction);
        this.contextMenuManager = new MenuManager();
        this.contextMenuManager.setRemoveAllWhenShown(true);
        this.contextMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                FilteredItemsSelectionDialog.this.fillContextMenu(iMenuManager);
            }
        });
        Table table = this.list.getTable();
        Menu menu = this.contextMenuManager.createContextMenu((Control)table);
        table.setMenu(menu);
    }

    protected abstract Control createExtendedContentArea(Composite var1);

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        GridData gridData = new GridData(1808);
        composite3.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite3.setLayout((Layout)gridLayout);
        final Label label = this.createHeader(composite3);
        this.pattern = new Text(composite3, 2436);
        this.pattern.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = LegacyActionTools.removeMnemonics((String)label.getText());
            }
        });
        gridData = new GridData(768);
        this.pattern.setLayoutData((Object)gridData);
        final Label label2 = this.createLabels(composite3);
        this.list = new TableViewer(composite3, (this.multi ? 2 : 4) | 0x800 | 0x200 | 0x10000000);
        this.list.getTable().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                if (accessibleEvent.childID == -1) {
                    accessibleEvent.result = LegacyActionTools.removeMnemonics((String)label2.getText());
                }
            }
        });
        this.list.setContentProvider((IContentProvider)this.contentProvider);
        this.list.setLabelProvider((IBaseLabelProvider)this.getItemsListLabelProvider());
        this.list.setInput((Object)new Object[0]);
        this.list.setItemCount(this.contentProvider.getNumberOfElements());
        gridData = new GridData(1808);
        FilteredItemsSelectionDialog.applyDialogFont((Control)this.list.getTable());
        gridData.heightHint = this.list.getTable().getItemHeight() * 15;
        this.list.getTable().setLayoutData((Object)gridData);
        this.createPopupMenu();
        this.pattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                FilteredItemsSelectionDialog.this.applyFilter();
            }
        });
        this.pattern.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 0x1000002 && FilteredItemsSelectionDialog.this.list.getTable().getItemCount() > 0) {
                    FilteredItemsSelectionDialog.this.list.getTable().setFocus();
                }
            }
        });
        this.list.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                StructuredSelection structuredSelection = (StructuredSelection)selectionChangedEvent.getSelection();
                FilteredItemsSelectionDialog.this.handleSelected(structuredSelection);
            }
        });
        this.list.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                FilteredItemsSelectionDialog.this.handleDoubleClick();
            }
        });
        this.list.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                Object object2;
                List list;
                if (keyEvent.keyCode == 127) {
                    list = ((StructuredSelection)FilteredItemsSelectionDialog.this.list.getSelection()).toList();
                    object2 = null;
                    boolean bl = true;
                    for (Object object2 : list) {
                        if (!(object2 instanceof ItemsListSeparator) && FilteredItemsSelectionDialog.this.isHistoryElement(object2)) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        FilteredItemsSelectionDialog.this.removeSelectedItems(list);
                    }
                }
                if (keyEvent.keyCode == 0x1000001 && (keyEvent.stateMask & 0x20000) != 0 && (keyEvent.stateMask & 0x40000) != 0 && (list = (StructuredSelection)FilteredItemsSelectionDialog.this.list.getSelection()).size() == 1) {
                    object2 = list.getFirstElement();
                    if (object2.equals(FilteredItemsSelectionDialog.this.list.getElementAt(0))) {
                        FilteredItemsSelectionDialog.this.pattern.setFocus();
                    }
                    if (FilteredItemsSelectionDialog.this.list.getElementAt(FilteredItemsSelectionDialog.this.list.getTable().getSelectionIndex() - 1) instanceof ItemsListSeparator) {
                        FilteredItemsSelectionDialog.this.list.getTable().setSelection(FilteredItemsSelectionDialog.this.list.getTable().getSelectionIndex() - 1);
                    }
                    FilteredItemsSelectionDialog.this.list.getTable().notifyListeners(13, new Event());
                }
                if (keyEvent.keyCode == 0x1000002 && (keyEvent.stateMask & 0x20000) != 0 && (keyEvent.stateMask & 0x40000) != 0) {
                    if (FilteredItemsSelectionDialog.this.list.getElementAt(FilteredItemsSelectionDialog.this.list.getTable().getSelectionIndex() + 1) instanceof ItemsListSeparator) {
                        FilteredItemsSelectionDialog.this.list.getTable().setSelection(FilteredItemsSelectionDialog.this.list.getTable().getSelectionIndex() + 1);
                    }
                    FilteredItemsSelectionDialog.this.list.getTable().notifyListeners(13, new Event());
                }
            }
        });
        this.createExtendedContentArea(composite3);
        this.details = new DetailsContentViewer(composite3, 0x800800);
        this.details.setVisible(this.toggleStatusLineAction.isChecked());
        this.details.setContentProvider(new NullContentProvider());
        this.details.setLabelProvider((IBaseLabelProvider)this.getDetailsLabelProvider());
        FilteredItemsSelectionDialog.applyDialogFont((Control)composite3);
        this.restoreDialog(this.getDialogSettings());
        if (this.initialPatternText != null) {
            this.pattern.setText(this.initialPatternText);
        }
        switch (this.selectionMode) {
            case 1: {
                this.pattern.setSelection(0, 0);
                break;
            }
            case 2: {
                this.pattern.setSelection(0, this.initialPatternText.length());
            }
        }
        this.applyFilter();
        return composite2;
    }

    protected void handleDoubleClick() {
        this.okPressed();
    }

    private void refreshDetails() {
        StructuredSelection structuredSelection = this.getSelectedItems();
        switch (structuredSelection.size()) {
            case 0: {
                this.details.setInput(null);
                break;
            }
            case 1: {
                this.details.setInput(structuredSelection.getFirstElement());
                break;
            }
            default: {
                this.details.setInput(NLS.bind((String)WorkbenchMessages.FilteredItemsSelectionDialog_nItemsSelected, (Object)new Integer(structuredSelection.size())));
            }
        }
    }

    protected void handleSelected(StructuredSelection structuredSelection) {
        Status status = new Status(0, "org.eclipse.ui", 0, EMPTY_STRING, null);
        Object[] objectArray = this.currentSelection;
        this.currentSelection = structuredSelection.toArray();
        if (structuredSelection.size() == 0) {
            status = new Status(4, "org.eclipse.ui", 4, EMPTY_STRING, null);
            if (objectArray != null && this.getListSelectionLabelDecorator() != null) {
                this.list.update(objectArray, null);
            }
            this.currentSelection = null;
        } else {
            status = new Status(4, "org.eclipse.ui", 4, EMPTY_STRING, null);
            List list = structuredSelection.toList();
            Object var5_5 = null;
            IStatus iStatus = null;
            for (Object e : list) {
                if (e instanceof ItemsListSeparator) continue;
                var5_5 = e;
                iStatus = this.validateItem(var5_5);
                if (iStatus.isOK()) {
                    status = new Status(0, "org.eclipse.ui", 0, EMPTY_STRING, null);
                    continue;
                }
                status = iStatus;
                break;
            }
            if (objectArray != null && this.getListSelectionLabelDecorator() != null) {
                this.list.update(objectArray, null);
            }
            if (this.getListSelectionLabelDecorator() != null) {
                this.list.update(this.currentSelection, null);
            }
        }
        this.refreshDetails();
        this.updateStatus((IStatus)status);
    }

    @Override
    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(DIALOG_BOUNDS_SETTINGS);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(DIALOG_BOUNDS_SETTINGS);
            iDialogSettings2.put(DIALOG_HEIGHT, 500);
            iDialogSettings2.put(DIALOG_WIDTH, 600);
        }
        return iDialogSettings2;
    }

    protected abstract IDialogSettings getDialogSettings();

    public void refresh() {
        if (this.list != null && !this.list.getTable().isDisposed()) {
            List list = ((StructuredSelection)this.list.getSelection()).toList();
            this.list.getTable().deselectAll();
            this.list.setItemCount(this.contentProvider.getNumberOfElements());
            this.list.refresh();
            if (this.list.getTable().getItemCount() > 0) {
                if (this.refreshWithLastSelection && list != null && list.size() > 0) {
                    this.list.setSelection((ISelection)new StructuredSelection(list));
                } else {
                    this.refreshWithLastSelection = true;
                    this.list.getTable().setSelection(0);
                    this.list.getTable().notifyListeners(13, new Event());
                }
            } else {
                this.list.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        }
        this.scheduleProgressMessageRefresh();
    }

    public void updateProgressLabel() {
        this.scheduleProgressMessageRefresh();
    }

    public void reloadCache(boolean bl, IProgressMonitor iProgressMonitor) {
        if (this.list != null && !this.list.getTable().isDisposed() && this.contentProvider != null) {
            this.contentProvider.reloadCache(bl, iProgressMonitor);
        }
    }

    public void scheduleRefresh() {
        this.refreshCacheJob.cancelAll();
        this.refreshCacheJob.schedule();
    }

    public void scheduleProgressMessageRefresh() {
        if (this.filterJob.getState() != 4 && this.refreshProgressMessageJob.getState() != 4) {
            this.refreshProgressMessageJob.scheduleProgressRefresh(null);
        }
    }

    @Override
    protected void computeResult() {
        List list = ((StructuredSelection)this.list.getSelection()).toList();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object e2 = null;
        for (Object e2 : list) {
            if (e2 instanceof ItemsListSeparator) continue;
            this.accessedHistoryItem(e2);
            arrayList.add(e2);
        }
        this.setResult(arrayList);
    }

    @Override
    protected void updateStatus(IStatus iStatus) {
        this.status = iStatus;
        super.updateStatus(iStatus);
    }

    @Override
    protected void okPressed() {
        if (this.status != null && (this.status.isOK() || this.status.getCode() == 1)) {
            super.okPressed();
        }
    }

    public void setInitialPattern(String string) {
        this.setInitialPattern(string, 2);
    }

    public void setInitialPattern(String string, int n) {
        this.initialPatternText = string;
        this.selectionMode = n;
    }

    protected String getInitialPattern() {
        return this.initialPatternText;
    }

    protected StructuredSelection getSelectedItems() {
        StructuredSelection structuredSelection = (StructuredSelection)this.list.getSelection();
        List list = structuredSelection.toList();
        Object var3_3 = null;
        for (Object e : structuredSelection) {
            if (!(e instanceof ItemsListSeparator)) continue;
            var3_3 = e;
            break;
        }
        if (var3_3 == null) {
            return new StructuredSelection(list);
        }
        ArrayList arrayList = new ArrayList(list);
        arrayList.remove(var3_3);
        return new StructuredSelection((List)arrayList);
    }

    protected abstract IStatus validateItem(Object var1);

    protected abstract ItemsFilter createFilter();

    protected void applyFilter() {
        ItemsFilter itemsFilter = this.createFilter();
        if (this.filter != null && this.filter.equalsFilter(itemsFilter)) {
            return;
        }
        this.filterHistoryJob.cancel();
        this.filterJob.cancel();
        this.filter = itemsFilter;
        if (this.filter != null) {
            this.filterHistoryJob.schedule();
        }
    }

    protected abstract Comparator getItemsComparator();

    protected abstract void fillContentProvider(AbstractContentProvider var1, ItemsFilter var2, IProgressMonitor var3) throws CoreException;

    private void removeSelectedItems(List list) {
        for (Object e : list) {
            this.removeHistoryItem(e);
        }
        this.refreshWithLastSelection = false;
        this.contentProvider.refresh();
    }

    protected Object removeHistoryItem(Object object) {
        return this.contentProvider.removeHistoryElement(object);
    }

    protected void accessedHistoryItem(Object object) {
        this.contentProvider.addHistoryElement(object);
    }

    private Comparator getHistoryComparator() {
        return new HistoryComparator();
    }

    protected SelectionHistory getSelectionHistory() {
        return this.contentProvider.getSelectionHistory();
    }

    protected void setSelectionHistory(SelectionHistory selectionHistory) {
        if (this.contentProvider != null) {
            this.contentProvider.setSelectionHistory(selectionHistory);
        }
    }

    public boolean isHistoryElement(Object object) {
        return this.contentProvider.isHistoryElement(object);
    }

    public boolean isDuplicateElement(Object object) {
        return this.contentProvider.isDuplicateElement(object);
    }

    public void setSeparatorLabel(String string) {
        this.itemsListSeparator = new ItemsListSeparator(string);
    }

    public abstract String getElementName(Object var1);

    private static boolean showColoredLabels() {
        return PlatformUI.getPreferenceStore().getBoolean("USE_COLORED_LABELS");
    }

    public Control getPatternControl() {
        return this.pattern;
    }

    protected abstract class AbstractContentProvider {
        protected AbstractContentProvider() {
        }

        public abstract void add(Object var1, ItemsFilter var2);
    }

    private class ContentProvider
    extends AbstractContentProvider
    implements IStructuredContentProvider,
    ILazyContentProvider {
        private SelectionHistory selectionHistory;
        private Set items = Collections.synchronizedSet(new HashSet(2048));
        private Set duplicates = Collections.synchronizedSet(new HashSet(256));
        private List filters;
        private List lastFilteredItems = new ArrayList();
        private List lastSortedItems = Collections.synchronizedList(new ArrayList(2048));
        private boolean reset;

        public void setSelectionHistory(SelectionHistory selectionHistory) {
            this.selectionHistory = selectionHistory;
        }

        public SelectionHistory getSelectionHistory() {
            return this.selectionHistory;
        }

        public void reset() {
            this.reset = true;
            this.items.clear();
            this.duplicates.clear();
            this.lastSortedItems.clear();
        }

        public void stopReloadingCache() {
            this.reset = true;
        }

        @Override
        public void add(Object object, ItemsFilter itemsFilter) {
            if (itemsFilter == FilteredItemsSelectionDialog.this.filter) {
                if (itemsFilter != null) {
                    if (itemsFilter.matchItem(object)) {
                        this.items.add(object);
                    }
                } else {
                    this.items.add(object);
                }
            }
        }

        public void addHistoryItems(ItemsFilter itemsFilter) {
            if (this.selectionHistory != null) {
                Object[] objectArray = this.selectionHistory.getHistoryItems();
                int n = 0;
                while (n < objectArray.length) {
                    Object object = objectArray[n];
                    if (itemsFilter == FilteredItemsSelectionDialog.this.filter && itemsFilter != null && itemsFilter.matchItem(object)) {
                        if (itemsFilter.isConsistentItem(object)) {
                            this.items.add(object);
                        } else {
                            this.selectionHistory.remove(object);
                        }
                    }
                    ++n;
                }
            }
        }

        public void refresh() {
            FilteredItemsSelectionDialog.this.scheduleRefresh();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object removeHistoryElement(Object object) {
            if (this.selectionHistory != null) {
                this.selectionHistory.remove(object);
            }
            if (FilteredItemsSelectionDialog.this.filter == null || FilteredItemsSelectionDialog.this.filter.getPattern().length() == 0) {
                this.items.remove(object);
                this.duplicates.remove(object);
                this.lastSortedItems.remove(object);
            }
            List list = this.lastSortedItems;
            synchronized (list) {
                Collections.sort(this.lastSortedItems, FilteredItemsSelectionDialog.this.getHistoryComparator());
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addHistoryElement(Object object) {
            if (this.selectionHistory != null) {
                this.selectionHistory.accessed(object);
            }
            if (FilteredItemsSelectionDialog.this.filter == null || !FilteredItemsSelectionDialog.this.filter.matchItem(object)) {
                this.items.remove(object);
                this.duplicates.remove(object);
                this.lastSortedItems.remove(object);
            }
            List list = this.lastSortedItems;
            synchronized (list) {
                Collections.sort(this.lastSortedItems, FilteredItemsSelectionDialog.this.getHistoryComparator());
            }
            this.refresh();
        }

        public boolean isHistoryElement(Object object) {
            if (this.selectionHistory != null) {
                return this.selectionHistory.contains(object);
            }
            return false;
        }

        public void setDuplicateElement(Object object, boolean bl) {
            if (this.items.contains(object)) {
                if (bl) {
                    this.duplicates.add(object);
                } else {
                    this.duplicates.remove(object);
                }
            }
        }

        public boolean isDuplicateElement(Object object) {
            return this.duplicates.contains(object);
        }

        public void loadHistory(IMemento iMemento) {
            if (this.selectionHistory != null) {
                this.selectionHistory.load(iMemento);
            }
        }

        public void saveHistory(IMemento iMemento) {
            if (this.selectionHistory != null) {
                this.selectionHistory.save(iMemento);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object[] getSortedItems() {
            if (this.lastSortedItems.size() != this.items.size()) {
                List list = this.lastSortedItems;
                synchronized (list) {
                    this.lastSortedItems.clear();
                    this.lastSortedItems.addAll(this.items);
                    Collections.sort(this.lastSortedItems, FilteredItemsSelectionDialog.this.getHistoryComparator());
                }
            }
            return this.lastSortedItems.toArray();
        }

        public void rememberResult(ItemsFilter itemsFilter) {
            List<Object> list = Collections.synchronizedList(Arrays.asList(this.getSortedItems()));
            if (itemsFilter == FilteredItemsSelectionDialog.this.filter) {
                FilteredItemsSelectionDialog.this.lastCompletedFilter = itemsFilter;
                FilteredItemsSelectionDialog.this.lastCompletedResult = list;
            }
        }

        public Object[] getElements(Object object) {
            return this.lastFilteredItems.toArray();
        }

        public int getNumberOfElements() {
            return this.lastFilteredItems.size();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public void updateElement(int n) {
            FilteredItemsSelectionDialog.this.list.replace(this.lastFilteredItems.size() > n ? this.lastFilteredItems.get(n) : null, n);
        }

        public void reloadCache(boolean bl, IProgressMonitor iProgressMonitor) {
            this.reset = false;
            if (iProgressMonitor != null) {
                int n = bl ? 200 : 100;
                iProgressMonitor.beginTask(WorkbenchMessages.FilteredItemsSelectionDialog_cacheRefreshJob, n);
            }
            this.lastFilteredItems = Arrays.asList(this.getFilteredItems(FilteredItemsSelectionDialog.this.list.getInput(), (IProgressMonitor)(iProgressMonitor != null ? new SubProgressMonitor(iProgressMonitor, 100) : null)));
            if (this.reset || iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                if (iProgressMonitor != null) {
                    iProgressMonitor.done();
                }
                return;
            }
            if (bl) {
                this.checkDuplicates(iProgressMonitor);
            }
            if (iProgressMonitor != null) {
                iProgressMonitor.done();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkDuplicates(IProgressMonitor iProgressMonitor) {
            List list = this.lastFilteredItems;
            synchronized (list) {
                SubProgressMonitor subProgressMonitor = null;
                int n = this.lastFilteredItems.size() / 20;
                if (iProgressMonitor != null) {
                    subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 100);
                    subProgressMonitor.beginTask(WorkbenchMessages.FilteredItemsSelectionDialog_cacheRefreshJob_checkDuplicates, 5);
                }
                HashMap hashMap = new HashMap();
                int n2 = 0;
                while (n2 < this.lastFilteredItems.size()) {
                    if (this.reset || subProgressMonitor != null && subProgressMonitor.isCanceled()) {
                        return;
                    }
                    Object e = this.lastFilteredItems.get(n2);
                    if (!(e instanceof ItemsListSeparator)) {
                        Object v = hashMap.put(FilteredItemsSelectionDialog.this.getElementName(e), e);
                        if (v != null) {
                            this.setDuplicateElement(v, true);
                            this.setDuplicateElement(e, true);
                        } else {
                            this.setDuplicateElement(e, false);
                        }
                    }
                    if (subProgressMonitor != null && n != 0 && (n2 + 1) % n == 0) {
                        subProgressMonitor.worked(1);
                    }
                    ++n2;
                }
                hashMap.clear();
            }
        }

        protected Object[] getFilteredItems(Object object, IProgressMonitor iProgressMonitor) {
            int n = 100;
            if (iProgressMonitor == null) {
                iProgressMonitor = new NullProgressMonitor();
            }
            iProgressMonitor.beginTask(WorkbenchMessages.FilteredItemsSelectionDialog_cacheRefreshJob_getFilteredElements, n);
            n = this.filters != null ? (n /= this.filters.size() + 2) : (n /= 2);
            Object[] objectArray = this.getSortedItems();
            iProgressMonitor.worked(n);
            if (this.filters != null && objectArray != null) {
                for (ViewerFilter viewerFilter : this.filters) {
                    objectArray = viewerFilter.filter((Viewer)FilteredItemsSelectionDialog.this.list, object, objectArray);
                    iProgressMonitor.worked(n);
                }
            }
            if (objectArray == null || iProgressMonitor.isCanceled()) {
                iProgressMonitor.done();
                return new Object[0];
            }
            ArrayList arrayList = new ArrayList();
            boolean bl = false;
            if (objectArray.length > 0 && this.isHistoryElement(objectArray[0])) {
                bl = true;
            }
            int n2 = objectArray.length / n;
            int n3 = 0;
            while (n3 < objectArray.length) {
                Object object2 = objectArray[n3];
                if (bl && !this.isHistoryElement(object2)) {
                    arrayList.add(FilteredItemsSelectionDialog.this.itemsListSeparator);
                    bl = false;
                }
                arrayList.add(object2);
                if (n2 != 0 && (n3 + 1) % n2 == 0) {
                    iProgressMonitor.worked(1);
                }
                ++n3;
            }
            iProgressMonitor.done();
            return arrayList.toArray();
        }

        public void addFilter(ViewerFilter viewerFilter) {
            if (this.filters == null) {
                this.filters = new ArrayList();
            }
            this.filters.add(viewerFilter);
        }
    }

    private class DetailsContentViewer
    extends ContentViewer {
        private CLabel label;
        private ViewForm viewForm;

        public DetailsContentViewer(Composite composite, int n) {
            this.viewForm = new ViewForm(composite, n);
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            this.viewForm.setLayoutData((Object)gridData);
            this.label = new CLabel((Composite)this.viewForm, 0x800000);
            this.label.setFont(composite.getFont());
            this.viewForm.setContent((Control)this.label);
            this.hookControl((Control)this.label);
        }

        public void setVisible(boolean bl) {
            this.viewForm.setVisible(bl);
            GridData gridData = (GridData)this.viewForm.getLayoutData();
            gridData.exclude = !bl;
            this.viewForm.getParent().layout();
        }

        protected void inputChanged(Object object, Object object2) {
            if (object2 == null) {
                if (object == null) {
                    return;
                }
                this.refresh();
                return;
            }
            this.refresh();
        }

        protected void handleLabelProviderChanged(LabelProviderChangedEvent labelProviderChangedEvent) {
            if (labelProviderChangedEvent != null) {
                this.refresh(labelProviderChangedEvent.getElements());
            }
        }

        public Control getControl() {
            return this.label;
        }

        public ISelection getSelection() {
            return null;
        }

        public void refresh() {
            Object object = this.getInput();
            if (object != null) {
                ILabelProvider iLabelProvider = (ILabelProvider)this.getLabelProvider();
                this.doRefresh(iLabelProvider.getText(object), iLabelProvider.getImage(object));
            } else {
                this.doRefresh(null, null);
            }
        }

        private void doRefresh(String string, Image image) {
            if (string != null) {
                string = LegacyActionTools.escapeMnemonics((String)string);
            }
            this.label.setText(string);
            this.label.setImage(image);
        }

        public void setSelection(ISelection iSelection, boolean bl) {
        }

        private void refresh(Object[] objectArray) {
            if (objectArray == null || this.getInput() == null) {
                return;
            }
            Object object = this.getInput();
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n].equals(object)) {
                    this.refresh();
                    break;
                }
                ++n;
            }
        }
    }

    private class FilterHistoryJob
    extends Job {
        private ItemsFilter itemsFilter;

        public FilterHistoryJob() {
            super(WorkbenchMessages.FilteredItemsSelectionDialog_jobLabel);
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            this.itemsFilter = FilteredItemsSelectionDialog.this.filter;
            FilteredItemsSelectionDialog.this.contentProvider.reset();
            FilteredItemsSelectionDialog.this.refreshWithLastSelection = false;
            FilteredItemsSelectionDialog.this.contentProvider.addHistoryItems(this.itemsFilter);
            if (FilteredItemsSelectionDialog.this.lastCompletedFilter == null || !FilteredItemsSelectionDialog.this.lastCompletedFilter.isSubFilter(this.itemsFilter)) {
                FilteredItemsSelectionDialog.this.contentProvider.refresh();
            }
            FilteredItemsSelectionDialog.this.filterJob.schedule();
            return Status.OK_STATUS;
        }
    }

    private class FilterJob
    extends Job {
        protected ItemsFilter itemsFilter;

        public FilterJob() {
            super(WorkbenchMessages.FilteredItemsSelectionDialog_jobLabel);
            this.setSystem(true);
        }

        protected final IStatus run(IProgressMonitor iProgressMonitor) {
            GranualProgressMonitor granualProgressMonitor = new GranualProgressMonitor(iProgressMonitor);
            return this.doRun(granualProgressMonitor);
        }

        protected IStatus doRun(GranualProgressMonitor granualProgressMonitor) {
            try {
                this.internalRun(granualProgressMonitor);
            }
            catch (CoreException coreException) {
                this.cancel();
                return new Status(4, "org.eclipse.ui", 4, WorkbenchMessages.FilteredItemsSelectionDialog_jobError, (Throwable)coreException);
            }
            return Status.OK_STATUS;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void internalRun(GranualProgressMonitor granualProgressMonitor) throws CoreException {
            try {
                if (granualProgressMonitor.isCanceled()) {
                    return;
                }
                this.itemsFilter = FilteredItemsSelectionDialog.this.filter;
                if (FilteredItemsSelectionDialog.this.filter.getPattern().length() != 0) {
                    this.filterContent(granualProgressMonitor);
                }
                if (granualProgressMonitor.isCanceled()) {
                    return;
                }
                FilteredItemsSelectionDialog.this.contentProvider.refresh();
                return;
            }
            finally {
                granualProgressMonitor.done();
            }
        }

        protected void filterContent(GranualProgressMonitor granualProgressMonitor) throws CoreException {
            if (FilteredItemsSelectionDialog.this.lastCompletedFilter != null && FilteredItemsSelectionDialog.this.lastCompletedFilter.isSubFilter(this.itemsFilter)) {
                int n = FilteredItemsSelectionDialog.this.lastCompletedResult.size() / 500;
                granualProgressMonitor.beginTask(WorkbenchMessages.FilteredItemsSelectionDialog_cacheSearchJob_taskName, n);
                int n2 = 0;
                while (n2 < FilteredItemsSelectionDialog.this.lastCompletedResult.size()) {
                    Object e = FilteredItemsSelectionDialog.this.lastCompletedResult.get(n2);
                    if (!granualProgressMonitor.isCanceled()) {
                        FilteredItemsSelectionDialog.this.contentProvider.add(e, this.itemsFilter);
                        if (n2 % 500 == 0) {
                            granualProgressMonitor.worked(1);
                        }
                        ++n2;
                        continue;
                    }
                    break;
                }
            } else {
                FilteredItemsSelectionDialog.this.lastCompletedFilter = null;
                FilteredItemsSelectionDialog.this.lastCompletedResult = null;
                SubProgressMonitor subProgressMonitor = null;
                if (granualProgressMonitor != null) {
                    granualProgressMonitor.beginTask(WorkbenchMessages.FilteredItemsSelectionDialog_searchJob_taskName, 100);
                    subProgressMonitor = new SubProgressMonitor((IProgressMonitor)granualProgressMonitor, 95);
                }
                FilteredItemsSelectionDialog.this.fillContentProvider(FilteredItemsSelectionDialog.this.contentProvider, this.itemsFilter, (IProgressMonitor)subProgressMonitor);
                if (granualProgressMonitor != null && !granualProgressMonitor.isCanceled()) {
                    granualProgressMonitor.worked(2);
                    FilteredItemsSelectionDialog.this.contentProvider.rememberResult(this.itemsFilter);
                    granualProgressMonitor.worked(3);
                }
            }
        }
    }

    private class GranualProgressMonitor
    extends ProgressMonitorWrapper {
        private String name;
        private String subName;
        private int totalWork;
        private double worked;
        private boolean done;

        public GranualProgressMonitor(IProgressMonitor iProgressMonitor) {
            super(iProgressMonitor);
        }

        public boolean isDone() {
            return this.done;
        }

        public void setTaskName(String string) {
            super.setTaskName(string);
            this.name = string;
            this.subName = null;
        }

        public void subTask(String string) {
            super.subTask(string);
            this.subName = string;
        }

        public void beginTask(String string, int n) {
            super.beginTask(string, n);
            if (this.name == null) {
                this.name = string;
            }
            this.totalWork = n;
            FilteredItemsSelectionDialog.this.refreshProgressMessageJob.scheduleProgressRefresh(this);
        }

        public void worked(int n) {
            super.worked(n);
            this.internalWorked(n);
        }

        public void done() {
            this.done = true;
            super.done();
        }

        public void setCanceled(boolean bl) {
            this.done = bl;
            super.setCanceled(bl);
        }

        public void internalWorked(double d) {
            this.worked += d;
        }

        private String getMessage() {
            String string;
            if (this.done) {
                return FilteredItemsSelectionDialog.EMPTY_STRING;
            }
            if (this.name == null) {
                string = this.subName == null ? FilteredItemsSelectionDialog.EMPTY_STRING : this.subName;
            } else {
                String string2 = string = this.subName == null ? this.name : NLS.bind((String)WorkbenchMessages.FilteredItemsSelectionDialog_subtaskProgressMessage, (Object[])new Object[]{this.name, this.subName});
            }
            if (this.totalWork == 0) {
                return string;
            }
            return NLS.bind((String)WorkbenchMessages.FilteredItemsSelectionDialog_taskProgressMessage, (Object[])new Object[]{string, new Integer((int)(this.worked * 100.0 / (double)this.totalWork))});
        }
    }

    private class HistoryComparator
    implements Comparator {
        private HistoryComparator() {
        }

        public int compare(Object object, Object object2) {
            boolean bl;
            boolean bl2 = FilteredItemsSelectionDialog.this.isHistoryElement(object);
            if (bl2 == (bl = FilteredItemsSelectionDialog.this.isHistoryElement(object2))) {
                return FilteredItemsSelectionDialog.this.getItemsComparator().compare(object, object2);
            }
            if (bl2) {
                return -2;
            }
            if (bl) {
                return 2;
            }
            return 0;
        }
    }

    protected abstract class ItemsFilter {
        protected SearchPattern patternMatcher;

        public ItemsFilter() {
            this(new SearchPattern());
        }

        public ItemsFilter(SearchPattern searchPattern) {
            this.patternMatcher = searchPattern;
            String string = FilteredItemsSelectionDialog.EMPTY_STRING;
            if (FilteredItemsSelectionDialog.this.pattern != null && !FilteredItemsSelectionDialog.this.pattern.getText().equals("*")) {
                string = FilteredItemsSelectionDialog.this.pattern.getText();
            }
            this.patternMatcher.setPattern(string);
        }

        public boolean isSubFilter(ItemsFilter itemsFilter) {
            if (itemsFilter != null) {
                return this.patternMatcher.isSubPattern(itemsFilter.patternMatcher);
            }
            return false;
        }

        public boolean equalsFilter(ItemsFilter itemsFilter) {
            return itemsFilter != null && itemsFilter.patternMatcher.equalsPattern(this.patternMatcher);
        }

        public boolean isCamelCasePattern() {
            return this.patternMatcher.getMatchRule() == 128;
        }

        public String getPattern() {
            return this.patternMatcher.getPattern();
        }

        public int getMatchRule() {
            return this.patternMatcher.getMatchRule();
        }

        protected boolean matches(String string) {
            return this.patternMatcher.matches(string);
        }

        public boolean matchesRawNamePattern(Object object) {
            int n;
            String string = this.patternMatcher.getPattern();
            String string2 = FilteredItemsSelectionDialog.this.getElementName(object);
            if (string2 == null) {
                return false;
            }
            int n2 = string2.length();
            if (n2 < (n = string.length())) {
                return false;
            }
            int n3 = n - 1;
            while (n3 >= 0) {
                if (Character.toLowerCase(string.charAt(n3)) != Character.toLowerCase(string2.charAt(n3))) {
                    return false;
                }
                --n3;
            }
            return true;
        }

        public abstract boolean matchItem(Object var1);

        public abstract boolean isConsistentItem(Object var1);
    }

    private class ItemsListLabelProvider
    extends StyledCellLabelProvider
    implements ILabelProviderListener {
        private ILabelProvider provider;
        private ILabelDecorator selectionDecorator;
        private ListenerList listeners = new ListenerList();

        public ItemsListLabelProvider(ILabelProvider iLabelProvider, ILabelDecorator iLabelDecorator) {
            Assert.isNotNull((Object)iLabelProvider);
            this.provider = iLabelProvider;
            this.selectionDecorator = iLabelDecorator;
            this.setOwnerDrawEnabled(FilteredItemsSelectionDialog.showColoredLabels() && iLabelProvider instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider);
            iLabelProvider.addListener((ILabelProviderListener)this);
            if (iLabelDecorator != null) {
                iLabelDecorator.addListener((ILabelProviderListener)this);
            }
        }

        public void setSelectionDecorator(ILabelDecorator iLabelDecorator) {
            if (this.selectionDecorator != null) {
                this.selectionDecorator.removeListener((ILabelProviderListener)this);
                this.selectionDecorator.dispose();
            }
            this.selectionDecorator = iLabelDecorator;
            if (this.selectionDecorator != null) {
                this.selectionDecorator.addListener((ILabelProviderListener)this);
            }
        }

        public ILabelDecorator getSelectionDecorator() {
            return this.selectionDecorator;
        }

        public void setProvider(ILabelProvider iLabelProvider) {
            Assert.isNotNull((Object)iLabelProvider);
            this.provider.removeListener((ILabelProviderListener)this);
            this.provider.dispose();
            this.provider = iLabelProvider;
            if (this.provider != null) {
                this.provider.addListener((ILabelProviderListener)this);
            }
            this.setOwnerDrawEnabled(FilteredItemsSelectionDialog.showColoredLabels() && this.provider instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider);
        }

        private Image getImage(Object object) {
            if (object instanceof ItemsListSeparator) {
                return WorkbenchImages.getImage("IMG_OBJ_SEPARATOR");
            }
            return this.provider.getImage(object);
        }

        private boolean isSelected(Object object) {
            if (object != null && FilteredItemsSelectionDialog.this.currentSelection != null) {
                int n = 0;
                while (n < FilteredItemsSelectionDialog.this.currentSelection.length) {
                    if (object.equals(FilteredItemsSelectionDialog.this.currentSelection[n])) {
                        return true;
                    }
                    ++n;
                }
            }
            return false;
        }

        private String getText(Object object) {
            if (object instanceof ItemsListSeparator) {
                return this.getSeparatorLabel(((ItemsListSeparator)object).getName());
            }
            String string = this.provider.getText(object);
            if (this.selectionDecorator != null && this.isSelected(object)) {
                return this.selectionDecorator.decorateText(string.toString(), object);
            }
            return string;
        }

        private StyledString getStyledText(Object object, DelegatingStyledCellLabelProvider.IStyledLabelProvider iStyledLabelProvider) {
            StyledString styledString = iStyledLabelProvider.getStyledText(object);
            if (this.selectionDecorator != null && this.isSelected(object)) {
                String string = this.selectionDecorator.decorateText(styledString.getString(), object);
                return StyledCellLabelProvider.styleDecoratedString((String)string, null, (StyledString)styledString);
            }
            return styledString;
        }

        public void update(ViewerCell viewerCell) {
            Object object = viewerCell.getElement();
            if (!(object instanceof ItemsListSeparator) && this.provider instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider) {
                DelegatingStyledCellLabelProvider.IStyledLabelProvider iStyledLabelProvider = (DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.provider;
                StyledString styledString = this.getStyledText(object, iStyledLabelProvider);
                viewerCell.setText(styledString.getString());
                viewerCell.setStyleRanges(styledString.getStyleRanges());
                viewerCell.setImage(iStyledLabelProvider.getImage(object));
            } else {
                viewerCell.setText(this.getText(object));
                viewerCell.setImage(this.getImage(object));
            }
            viewerCell.setFont(this.getFont(object));
            viewerCell.setForeground(this.getForeground(object));
            viewerCell.setBackground(this.getBackground(object));
            super.update(viewerCell);
        }

        private String getSeparatorLabel(String string) {
            Rectangle rectangle = FilteredItemsSelectionDialog.this.list.getTable().getBounds();
            int n = ((FilteredItemsSelectionDialog)FilteredItemsSelectionDialog.this).list.getTable().computeTrim((int)0, (int)0, (int)0, (int)0).width;
            int n2 = WorkbenchImages.getImage((String)"IMG_OBJ_SEPARATOR").getBounds().width;
            int n3 = rectangle.width - n - n2;
            GC gC = new GC((Drawable)FilteredItemsSelectionDialog.this.list.getTable());
            gC.setFont(FilteredItemsSelectionDialog.this.list.getTable().getFont());
            int n4 = gC.getAdvanceWidth('-');
            int n5 = gC.textExtent((String)string).x;
            gC.dispose();
            StringBuffer stringBuffer = new StringBuffer();
            int n6 = (n3 - n5) / n4 / 2 - 2;
            int n7 = 0;
            while (n7 < n6) {
                stringBuffer.append('-');
                ++n7;
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(stringBuffer);
            stringBuffer2.append(" " + string + " ");
            stringBuffer2.append(stringBuffer);
            return stringBuffer2.toString().trim();
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
            this.listeners.add((Object)iLabelProviderListener);
        }

        public void dispose() {
            this.provider.removeListener((ILabelProviderListener)this);
            this.provider.dispose();
            if (this.selectionDecorator != null) {
                this.selectionDecorator.removeListener((ILabelProviderListener)this);
                this.selectionDecorator.dispose();
            }
            super.dispose();
        }

        public boolean isLabelProperty(Object object, String string) {
            if (this.provider.isLabelProperty(object, string)) {
                return true;
            }
            return this.selectionDecorator != null && this.selectionDecorator.isLabelProperty(object, string);
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
            this.listeners.remove((Object)iLabelProviderListener);
        }

        private Color getBackground(Object object) {
            if (object instanceof ItemsListSeparator) {
                return null;
            }
            if (this.provider instanceof IColorProvider) {
                return ((IColorProvider)this.provider).getBackground(object);
            }
            return null;
        }

        private Color getForeground(Object object) {
            if (object instanceof ItemsListSeparator) {
                return Display.getCurrent().getSystemColor(18);
            }
            if (this.provider instanceof IColorProvider) {
                return ((IColorProvider)this.provider).getForeground(object);
            }
            return null;
        }

        private Font getFont(Object object) {
            if (object instanceof ItemsListSeparator) {
                return null;
            }
            if (this.provider instanceof IFontProvider) {
                return ((IFontProvider)this.provider).getFont(object);
            }
            return null;
        }

        public void labelProviderChanged(LabelProviderChangedEvent labelProviderChangedEvent) {
            Object[] objectArray = this.listeners.getListeners();
            int n = 0;
            while (n < this.listeners.size()) {
                ((ILabelProviderListener)objectArray[n]).labelProviderChanged(labelProviderChangedEvent);
                ++n;
            }
        }
    }

    private class ItemsListSeparator {
        private String name;

        public ItemsListSeparator(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }
    }

    private class NullContentProvider
    implements IContentProvider {
        private NullContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private class RefreshCacheJob
    extends Job {
        private RefreshJob refreshJob;

        public RefreshCacheJob() {
            super(WorkbenchMessages.FilteredItemsSelectionDialog_cacheRefreshJob);
            this.refreshJob = new RefreshJob();
            this.setSystem(true);
        }

        public void cancelAll() {
            this.cancel();
            this.refreshJob.cancel();
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            if (iProgressMonitor.isCanceled()) {
                return new Status(8, WorkbenchPlugin.PI_WORKBENCH, 8, FilteredItemsSelectionDialog.EMPTY_STRING, null);
            }
            if (FilteredItemsSelectionDialog.this != null) {
                GranualProgressMonitor granualProgressMonitor = new GranualProgressMonitor(iProgressMonitor);
                FilteredItemsSelectionDialog.this.reloadCache(true, (IProgressMonitor)granualProgressMonitor);
            }
            if (!iProgressMonitor.isCanceled()) {
                this.refreshJob.schedule();
            }
            return new Status(0, "org.eclipse.ui", 0, FilteredItemsSelectionDialog.EMPTY_STRING, null);
        }

        protected void canceling() {
            super.canceling();
            FilteredItemsSelectionDialog.this.contentProvider.stopReloadingCache();
        }
    }

    private class RefreshJob
    extends UIJob {
        public RefreshJob() {
            super(FilteredItemsSelectionDialog.this.getParentShell().getDisplay(), WorkbenchMessages.FilteredItemsSelectionDialog_refreshJob);
            this.setSystem(true);
        }

        @Override
        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            if (iProgressMonitor.isCanceled()) {
                return new Status(0, WorkbenchPlugin.PI_WORKBENCH, 0, FilteredItemsSelectionDialog.EMPTY_STRING, null);
            }
            if (FilteredItemsSelectionDialog.this != null) {
                FilteredItemsSelectionDialog.this.refresh();
            }
            return new Status(0, "org.eclipse.ui", 0, FilteredItemsSelectionDialog.EMPTY_STRING, null);
        }
    }

    private class RefreshProgressMessageJob
    extends UIJob {
        private GranualProgressMonitor progressMonitor;

        public RefreshProgressMessageJob() {
            super(FilteredItemsSelectionDialog.this.getParentShell().getDisplay(), WorkbenchMessages.FilteredItemsSelectionDialog_progressRefreshJob);
            this.setSystem(true);
        }

        @Override
        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            if (!FilteredItemsSelectionDialog.this.progressLabel.isDisposed()) {
                FilteredItemsSelectionDialog.this.progressLabel.setText(this.progressMonitor != null ? this.progressMonitor.getMessage() : FilteredItemsSelectionDialog.EMPTY_STRING);
            }
            if (this.progressMonitor == null || this.progressMonitor.isDone()) {
                return new Status(8, "org.eclipse.ui", 8, FilteredItemsSelectionDialog.EMPTY_STRING, null);
            }
            this.schedule(500L);
            return new Status(0, "org.eclipse.ui", 0, FilteredItemsSelectionDialog.EMPTY_STRING, null);
        }

        public void scheduleProgressRefresh(GranualProgressMonitor granualProgressMonitor) {
            this.progressMonitor = granualProgressMonitor;
            this.schedule(200L);
        }
    }

    private class RemoveHistoryItemAction
    extends Action {
        public RemoveHistoryItemAction() {
            super(WorkbenchMessages.FilteredItemsSelectionDialog_removeItemsFromHistoryAction);
        }

        public void run() {
            List list = ((StructuredSelection)FilteredItemsSelectionDialog.this.list.getSelection()).toList();
            FilteredItemsSelectionDialog.this.removeSelectedItems(list);
        }
    }

    protected static abstract class SelectionHistory {
        private static final String DEFAULT_ROOT_NODE_NAME = "historyRootNode";
        private static final String DEFAULT_INFO_NODE_NAME = "infoNode";
        private static final int MAX_HISTORY_SIZE = 60;
        private final Set historyList = Collections.synchronizedSet(new LinkedHashSet(){
            private static final long serialVersionUID = 0L;

            @Override
            public boolean add(Object object) {
                if (this.size() >= 60) {
                    Iterator iterator = this.iterator();
                    iterator.next();
                    iterator.remove();
                }
                return super.add(object);
            }
        });
        private final String rootNodeName;
        private final String infoNodeName;

        private SelectionHistory(String string, String string2) {
            this.rootNodeName = string;
            this.infoNodeName = string2;
        }

        public SelectionHistory() {
            this(DEFAULT_ROOT_NODE_NAME, DEFAULT_INFO_NODE_NAME);
        }

        public synchronized void accessed(Object object) {
            this.historyList.remove(object);
            this.historyList.add(object);
        }

        public synchronized boolean contains(Object object) {
            return this.historyList.contains(object);
        }

        public synchronized boolean isEmpty() {
            return this.historyList.isEmpty();
        }

        public synchronized boolean remove(Object object) {
            return this.historyList.remove(object);
        }

        public void load(IMemento iMemento) {
            XMLMemento xMLMemento = (XMLMemento)iMemento.getChild(this.rootNodeName);
            if (xMLMemento == null) {
                return;
            }
            IMemento[] iMementoArray = xMLMemento.getChildren(this.infoNodeName);
            int n = 0;
            while (n < iMementoArray.length) {
                IMemento iMemento2 = iMementoArray[n];
                Object object = this.restoreItemFromMemento(iMemento2);
                if (object != null) {
                    this.historyList.add(object);
                }
                ++n;
            }
        }

        public void save(IMemento iMemento) {
            IMemento iMemento2 = iMemento.createChild(this.rootNodeName);
            Object[] objectArray = this.getHistoryItems();
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                IMemento iMemento3 = iMemento2.createChild(this.infoNodeName);
                this.storeItemToMemento(object, iMemento3);
                ++n;
            }
        }

        public synchronized Object[] getHistoryItems() {
            return this.historyList.toArray();
        }

        protected abstract Object restoreItemFromMemento(IMemento var1);

        protected abstract void storeItemToMemento(Object var1, IMemento var2);
    }

    private class ToggleStatusLineAction
    extends Action {
        public ToggleStatusLineAction() {
            super(WorkbenchMessages.FilteredItemsSelectionDialog_toggleStatusAction, 2);
        }

        public void run() {
            FilteredItemsSelectionDialog.this.details.setVisible(this.isChecked());
        }
    }
}

