/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class FileSystemElement
implements IAdaptable {
    private String name;
    private Object fileSystemObject;
    private AdaptableList folders = null;
    private AdaptableList files = null;
    private boolean isDirectory = false;
    private FileSystemElement parent;
    private IWorkbenchAdapter workbenchAdapter = new IWorkbenchAdapter(){

        @Override
        public Object[] getChildren(Object object) {
            return FileSystemElement.this.getFolders().getChildren(object);
        }

        @Override
        public Object getParent(Object object) {
            return FileSystemElement.this.parent;
        }

        @Override
        public String getLabel(Object object) {
            return FileSystemElement.this.name;
        }

        @Override
        public ImageDescriptor getImageDescriptor(Object object) {
            if (FileSystemElement.this.isDirectory()) {
                return WorkbenchImages.getImageDescriptor("IMG_OBJ_FOLDER");
            }
            return WorkbenchPlugin.getDefault().getEditorRegistry().getImageDescriptor(FileSystemElement.this.name);
        }
    };

    public FileSystemElement(String string, FileSystemElement fileSystemElement, boolean bl) {
        this.name = string;
        this.parent = fileSystemElement;
        this.isDirectory = bl;
        if (fileSystemElement != null) {
            fileSystemElement.addChild(this);
        }
    }

    public void addChild(FileSystemElement fileSystemElement) {
        if (fileSystemElement.isDirectory()) {
            if (this.folders == null) {
                this.folders = new AdaptableList(1);
            }
            this.folders.add(fileSystemElement);
        } else {
            if (this.files == null) {
                this.files = new AdaptableList(1);
            }
            this.files.add(fileSystemElement);
        }
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IWorkbenchAdapter.class) {
            return this.workbenchAdapter;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, clazz);
    }

    public String getFileNameExtension() {
        int n = this.name.lastIndexOf(46);
        return n < 0 ? "" : this.name.substring(n + 1);
    }

    public AdaptableList getFiles() {
        if (this.files == null) {
            this.files = new AdaptableList(0);
        }
        return this.files;
    }

    public Object getFileSystemObject() {
        return this.fileSystemObject;
    }

    public AdaptableList getFolders() {
        if (this.folders == null) {
            this.folders = new AdaptableList(0);
        }
        return this.folders;
    }

    public FileSystemElement getParent() {
        return this.parent;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public void removeFolder(FileSystemElement fileSystemElement) {
        if (this.folders == null) {
            return;
        }
        this.folders.remove(fileSystemElement);
        fileSystemElement.setParent(null);
    }

    public void setFileSystemObject(Object object) {
        this.fileSystemObject = object;
    }

    public void setParent(FileSystemElement fileSystemElement) {
        this.parent = fileSystemElement;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isDirectory()) {
            stringBuffer.append("Folder(");
        } else {
            stringBuffer.append("File(");
        }
        stringBuffer.append(this.name).append(")");
        if (!this.isDirectory()) {
            return stringBuffer.toString();
        }
        stringBuffer.append(" folders: ");
        stringBuffer.append(this.folders);
        stringBuffer.append(" files: ");
        stringBuffer.append(this.files);
        return stringBuffer.toString();
    }
}

