/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.internal.WorkbenchMessages;

public class ElementTreeSelectionDialog
extends SelectionStatusDialog {
    private TreeViewer fViewer;
    private ILabelProvider fLabelProvider;
    private ITreeContentProvider fContentProvider;
    private ISelectionStatusValidator fValidator = null;
    private ViewerComparator fComparator;
    private boolean fAllowMultiple = true;
    private boolean fDoubleClickSelects = true;
    private String fEmptyListMessage = WorkbenchMessages.ElementTreeSelectionDialog_nothing_available;
    private IStatus fCurrStatus = new Status(0, "org.eclipse.ui", 0, "", null);
    private List fFilters;
    private Object fInput;
    private boolean fIsEmpty;
    private int fWidth = 60;
    private int fHeight = 18;

    public ElementTreeSelectionDialog(Shell shell, ILabelProvider iLabelProvider, ITreeContentProvider iTreeContentProvider) {
        super(shell);
        this.fLabelProvider = iLabelProvider;
        this.fContentProvider = iTreeContentProvider;
        this.setResult(new ArrayList(0));
        this.setStatusLineAboveButtons(true);
    }

    public void setInitialSelection(Object object) {
        this.setInitialSelections(new Object[]{object});
    }

    public void setEmptyListMessage(String string) {
        this.fEmptyListMessage = string;
    }

    public void setAllowMultiple(boolean bl) {
        this.fAllowMultiple = bl;
    }

    public void setDoubleClickSelects(boolean bl) {
        this.fDoubleClickSelects = bl;
    }

    public void setSorter(ViewerSorter viewerSorter) {
        this.fComparator = viewerSorter;
    }

    public void setComparator(ViewerComparator viewerComparator) {
        this.fComparator = viewerComparator;
    }

    public void addFilter(ViewerFilter viewerFilter) {
        if (this.fFilters == null) {
            this.fFilters = new ArrayList(4);
        }
        this.fFilters.add(viewerFilter);
    }

    public void setValidator(ISelectionStatusValidator iSelectionStatusValidator) {
        this.fValidator = iSelectionStatusValidator;
    }

    public void setInput(Object object) {
        this.fInput = object;
    }

    public void setSize(int n, int n2) {
        this.fWidth = n;
        this.fHeight = n2;
    }

    protected void updateOKStatus() {
        if (!this.fIsEmpty) {
            if (this.fValidator != null) {
                this.fCurrStatus = this.fValidator.validate(this.getResult());
                this.updateStatus(this.fCurrStatus);
            } else {
                this.fCurrStatus = new Status(0, "org.eclipse.ui", 0, "", null);
            }
        } else {
            this.fCurrStatus = new Status(4, "org.eclipse.ui", 4, this.fEmptyListMessage, null);
        }
        this.updateStatus(this.fCurrStatus);
    }

    public int open() {
        this.fIsEmpty = this.evaluateIfTreeEmpty(this.fInput);
        super.open();
        return this.getReturnCode();
    }

    private void access$superCreate() {
        super.create();
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    @Override
    protected void computeResult() {
        this.setResult(((IStructuredSelection)this.fViewer.getSelection()).toList());
    }

    @Override
    public void create() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                ElementTreeSelectionDialog.this.access$superCreate();
                ElementTreeSelectionDialog.this.fViewer.setSelection((ISelection)new StructuredSelection(ElementTreeSelectionDialog.this.getInitialElementSelections()), true);
                ElementTreeSelectionDialog.this.updateOKStatus();
            }
        });
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Label label = this.createMessageArea(composite2);
        TreeViewer treeViewer = this.createTreeViewer(composite2);
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        gridData.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
        Tree tree = treeViewer.getTree();
        tree.setLayoutData((Object)gridData);
        tree.setFont(composite.getFont());
        if (this.fIsEmpty) {
            label.setEnabled(false);
            tree.setEnabled(false);
        }
        return composite2;
    }

    protected TreeViewer createTreeViewer(Composite composite) {
        int n = 0x800 | (this.fAllowMultiple ? 2 : 4);
        this.fViewer = this.doCreateTreeViewer(composite, n);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ElementTreeSelectionDialog.this.access$setResult(((IStructuredSelection)selectionChangedEvent.getSelection()).toList());
                ElementTreeSelectionDialog.this.updateOKStatus();
            }
        });
        this.fViewer.setComparator(this.fComparator);
        if (this.fFilters != null) {
            int n2 = 0;
            while (n2 != this.fFilters.size()) {
                this.fViewer.addFilter((ViewerFilter)this.fFilters.get(n2));
                ++n2;
            }
        }
        if (this.fDoubleClickSelects) {
            Tree tree = this.fViewer.getTree();
            tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    ElementTreeSelectionDialog.this.updateOKStatus();
                    if (ElementTreeSelectionDialog.this.fCurrStatus.isOK()) {
                        ElementTreeSelectionDialog.this.access$superButtonPressed(0);
                    }
                }
            });
        }
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                ISelection iSelection;
                ElementTreeSelectionDialog.this.updateOKStatus();
                if (!(ElementTreeSelectionDialog.this.fDoubleClickSelects && ElementTreeSelectionDialog.this.fCurrStatus.isOK() || !((iSelection = doubleClickEvent.getSelection()) instanceof IStructuredSelection))) {
                    Object object = ((IStructuredSelection)iSelection).getFirstElement();
                    if (ElementTreeSelectionDialog.this.fViewer.getExpandedState(object)) {
                        ElementTreeSelectionDialog.this.fViewer.collapseToLevel(object, 1);
                    } else {
                        ElementTreeSelectionDialog.this.fViewer.expandToLevel(object, 1);
                    }
                }
            }
        });
        this.fViewer.setInput(this.fInput);
        return this.fViewer;
    }

    protected TreeViewer doCreateTreeViewer(Composite composite, int n) {
        return new TreeViewer(new Tree(composite, n));
    }

    protected TreeViewer getTreeViewer() {
        return this.fViewer;
    }

    private boolean evaluateIfTreeEmpty(Object object) {
        Object[] objectArray = this.fContentProvider.getElements(object);
        if (objectArray.length > 0 && this.fFilters != null) {
            int n = 0;
            while (n < this.fFilters.size()) {
                ViewerFilter viewerFilter = (ViewerFilter)this.fFilters.get(n);
                objectArray = viewerFilter.filter((Viewer)this.fViewer, object, objectArray);
                ++n;
            }
        }
        return objectArray.length == 0;
    }

    protected void access$superButtonPressed(int n) {
        super.buttonPressed(n);
    }

    protected void access$setResult(List list) {
        super.setResult(list);
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        if (this.getReturnCode() == 1) {
            this.setResult(null);
        }
    }
}

