/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.registry.EditorRegistry;

public class EditorSelectionDialog
extends Dialog {
    private EditorDescriptor selectedEditor;
    private EditorDescriptor hiddenSelectedEditor;
    private int hiddenTableTopIndex;
    private Button externalButton;
    private Table editorTable;
    private Button browseExternalEditorsButton;
    private Button internalButton;
    private Button okButton;
    protected static final String STORE_ID_INTERNAL_EXTERNAL = "EditorSelectionDialog.STORE_ID_INTERNAL_EXTERNAL";
    private String message = WorkbenchMessages.EditorSelection_chooseAnEditor;
    private IEditorDescriptor[] externalEditors;
    private IEditorDescriptor[] internalEditors;
    private IEditorDescriptor[] editorsToFilter;
    private DialogListener listener = new DialogListener();
    private ResourceManager resourceManager;
    private TableViewer editorTableViewer;
    private static final String[] Executable_Filters = Util.isWindows() ? new String[]{"*.exe", "*.bat", "*.*"} : new String[]{"*"};
    private static final int TABLE_WIDTH = 200;

    public EditorSelectionDialog(Shell shell) {
        super(shell);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)shell.getDisplay()));
    }

    protected void buttonPressed(int n) {
        if (n == 0) {
            this.saveWidgetValues();
        }
        super.buttonPressed(n);
    }

    public boolean close() {
        boolean bl = super.close();
        this.resourceManager.dispose();
        this.resourceManager = null;
        return bl;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(WorkbenchMessages.EditorSelection_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.editor_selection_dialog_context");
    }

    protected Control createDialogArea(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = (Composite)super.createDialogArea(composite);
        ((GridLayout)composite2.getLayout()).numColumns = 2;
        Label label = new Label(composite2, 64);
        label.setText(this.message);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 200;
        label.setLayoutData((Object)gridData);
        label.setFont(font);
        this.internalButton = new Button(composite2, 16400);
        this.internalButton.setText(WorkbenchMessages.EditorSelection_internal);
        this.internalButton.addListener(13, (Listener)this.listener);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.internalButton.setLayoutData((Object)gridData);
        this.internalButton.setFont(font);
        this.externalButton = new Button(composite2, 16400);
        this.externalButton.setText(WorkbenchMessages.EditorSelection_external);
        this.externalButton.addListener(13, (Listener)this.listener);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.externalButton.setLayoutData((Object)gridData);
        this.externalButton.setFont(font);
        this.editorTable = new Table(composite2, 2052);
        gridData = new GridData();
        gridData.widthHint = this.convertHorizontalDLUsToPixels(200);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        this.editorTable.setLayoutData((Object)gridData);
        this.editorTable.setFont(font);
        gridData.heightHint = this.editorTable.getItemHeight() * 12;
        this.editorTableViewer = new TableViewer(this.editorTable);
        this.editorTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.editorTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                IEditorDescriptor iEditorDescriptor = (IEditorDescriptor)object;
                return TextProcessor.process((String)iEditorDescriptor.getLabel(), (String)".");
            }

            public Image getImage(Object object) {
                IEditorDescriptor iEditorDescriptor = (IEditorDescriptor)object;
                return (Image)EditorSelectionDialog.this.resourceManager.get((DeviceResourceDescriptor)iEditorDescriptor.getImageDescriptor());
            }
        });
        this.editorTable.addListener(13, (Listener)this.listener);
        this.editorTable.addListener(14, (Listener)this.listener);
        this.editorTable.addListener(8, (Listener)this.listener);
        this.browseExternalEditorsButton = new Button(composite2, 8);
        this.browseExternalEditorsButton.setText(WorkbenchMessages.EditorSelection_browse);
        this.browseExternalEditorsButton.addListener(13, (Listener)this.listener);
        gridData = new GridData();
        int n = this.convertHorizontalDLUsToPixels(61);
        gridData.widthHint = Math.max(n, this.browseExternalEditorsButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.browseExternalEditorsButton.setLayoutData((Object)gridData);
        this.browseExternalEditorsButton.setFont(font);
        this.restoreWidgetValues();
        this.fillEditorTable();
        this.updateEnableState();
        return composite2;
    }

    protected void fillEditorTable() {
        boolean bl;
        EditorDescriptor editorDescriptor = null;
        int n = 0;
        boolean bl2 = this.internalButton.getSelection();
        boolean bl3 = bl = this.editorTableViewer.getInput() == this.getInternalEditors();
        if (bl2 != bl) {
            editorDescriptor = this.hiddenSelectedEditor;
            n = this.hiddenTableTopIndex;
            if (this.editorTable.getSelectionIndex() != -1) {
                this.hiddenSelectedEditor = (EditorDescriptor)this.editorTable.getSelection()[0].getData();
                this.hiddenTableTopIndex = this.editorTable.getTopIndex();
            }
        }
        this.editorTableViewer.setInput((Object)(bl2 ? this.getInternalEditors() : this.getExternalEditors()));
        if (editorDescriptor != null) {
            this.editorTable.setTopIndex(n);
            this.editorTableViewer.setSelection((ISelection)new StructuredSelection((Object)editorDescriptor), true);
        } else {
            this.editorTable.setTopIndex(0);
            this.editorTable.setSelection(0);
            this.editorTable.deselectAll();
        }
        this.editorTable.setFocus();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings iDialogSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection("EditorSelectionDialog");
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection("EditorSelectionDialog");
        }
        return iDialogSettings2;
    }

    protected IEditorDescriptor[] getExternalEditors() {
        if (this.externalEditors == null) {
            Composite composite;
            Shell shell = this.getShell();
            if (!shell.isVisible() && (composite = shell.getParent()) != null) {
                shell = composite;
            }
            composite = new Cursor((Device)shell.getDisplay(), 1);
            shell.setCursor((Cursor)composite);
            EditorRegistry editorRegistry = (EditorRegistry)WorkbenchPlugin.getDefault().getEditorRegistry();
            this.externalEditors = editorRegistry.getSortedEditorsFromOS();
            this.externalEditors = this.filterEditors(this.externalEditors);
            shell.setCursor(null);
            composite.dispose();
        }
        return this.externalEditors;
    }

    protected IEditorDescriptor[] filterEditors(IEditorDescriptor[] iEditorDescriptorArray) {
        if (iEditorDescriptorArray == null || iEditorDescriptorArray.length < 1) {
            return iEditorDescriptorArray;
        }
        if (this.editorsToFilter == null || this.editorsToFilter.length < 1) {
            return iEditorDescriptorArray;
        }
        ArrayList<IEditorDescriptor> arrayList = new ArrayList<IEditorDescriptor>();
        int n = 0;
        while (n < iEditorDescriptorArray.length) {
            boolean bl = true;
            int n2 = 0;
            while (n2 < this.editorsToFilter.length) {
                if (iEditorDescriptorArray[n].getId().equals(this.editorsToFilter[n2].getId())) {
                    bl = false;
                }
                ++n2;
            }
            if (bl) {
                arrayList.add(iEditorDescriptorArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new IEditorDescriptor[arrayList.size()]);
    }

    protected IEditorDescriptor[] getInternalEditors() {
        if (this.internalEditors == null) {
            EditorRegistry editorRegistry = (EditorRegistry)WorkbenchPlugin.getDefault().getEditorRegistry();
            this.internalEditors = editorRegistry.getSortedEditorsFromPlugins();
            this.internalEditors = this.filterEditors(this.internalEditors);
        }
        return this.internalEditors;
    }

    public IEditorDescriptor getSelectedEditor() {
        return this.selectedEditor;
    }

    protected void promptForExternalEditor() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 0x10009000);
        fileDialog.setFilterExtensions(Executable_Filters);
        String string = fileDialog.open();
        if (string != null) {
            EditorDescriptor editorDescriptor = EditorDescriptor.createForProgram(string);
            TableItem tableItem = new TableItem(this.editorTable, 0);
            tableItem.setData((Object)editorDescriptor);
            tableItem.setText(editorDescriptor.getLabel());
            Image image = (Image)this.resourceManager.get((DeviceResourceDescriptor)editorDescriptor.getImageDescriptor());
            tableItem.setImage(image);
            this.editorTable.setSelection(new TableItem[]{tableItem});
            this.editorTable.showSelection();
            this.editorTable.setFocus();
            this.selectedEditor = editorDescriptor;
            IEditorDescriptor[] iEditorDescriptorArray = new IEditorDescriptor[this.externalEditors.length + 1];
            System.arraycopy(this.externalEditors, 0, iEditorDescriptorArray, 0, this.externalEditors.length);
            iEditorDescriptorArray[iEditorDescriptorArray.length - 1] = editorDescriptor;
            this.externalEditors = iEditorDescriptorArray;
        }
    }

    protected void handleDoubleClickEvent() {
        this.buttonPressed(0);
    }

    protected void restoreWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        boolean bl = iDialogSettings.getBoolean(STORE_ID_INTERNAL_EXTERNAL);
        this.internalButton.setSelection(!bl);
        this.externalButton.setSelection(bl);
    }

    protected void saveWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        iDialogSettings.put(STORE_ID_INTERNAL_EXTERNAL, !this.internalButton.getSelection());
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setEditorsToFilter(IEditorDescriptor[] iEditorDescriptorArray) {
        this.editorsToFilter = iEditorDescriptorArray;
    }

    protected void updateEnableState() {
        boolean bl = this.externalButton.getSelection();
        this.browseExternalEditorsButton.setEnabled(bl);
        this.updateOkButton();
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.okButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton.setEnabled(false);
    }

    protected void updateOkButton() {
        if (this.okButton == null) {
            return;
        }
        if (this.editorTable.getSelectionCount() == 0) {
            this.okButton.setEnabled(false);
            return;
        }
        this.okButton.setEnabled(this.selectedEditor != null);
    }

    protected boolean isResizable() {
        return true;
    }

    private class DialogListener
    implements Listener {
        private DialogListener() {
        }

        public void handleEvent(Event event) {
            if (event.type == 8) {
                EditorSelectionDialog.this.handleDoubleClickEvent();
                return;
            }
            if (event.widget == EditorSelectionDialog.this.externalButton) {
                EditorSelectionDialog.this.fillEditorTable();
            } else if (event.widget == EditorSelectionDialog.this.browseExternalEditorsButton) {
                EditorSelectionDialog.this.promptForExternalEditor();
            } else if (event.widget == EditorSelectionDialog.this.editorTable) {
                if (EditorSelectionDialog.this.editorTable.getSelectionIndex() != -1) {
                    EditorSelectionDialog.this.selectedEditor = (EditorDescriptor)EditorSelectionDialog.this.editorTable.getSelection()[0].getData();
                } else {
                    EditorSelectionDialog.this.selectedEditor = null;
                    EditorSelectionDialog.this.okButton.setEnabled(false);
                }
            }
            EditorSelectionDialog.this.updateEnableState();
        }
    }
}

