/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.internal.WorkbenchMessages;

public class CheckedTreeSelectionDialog
extends SelectionStatusDialog {
    private CheckboxTreeViewer fViewer;
    private ILabelProvider fLabelProvider;
    private ITreeContentProvider fContentProvider;
    private ISelectionStatusValidator fValidator = null;
    private ViewerComparator fComparator;
    private String fEmptyListMessage = WorkbenchMessages.CheckedTreeSelectionDialog_nothing_available;
    private IStatus fCurrStatus = new Status(0, "org.eclipse.ui", 0, "", null);
    private List fFilters;
    private Object fInput;
    private boolean fIsEmpty;
    private int fWidth = 60;
    private int fHeight = 18;
    private boolean fContainerMode;
    private Object[] fExpandedElements;

    public CheckedTreeSelectionDialog(Shell shell, ILabelProvider iLabelProvider, ITreeContentProvider iTreeContentProvider) {
        super(shell);
        this.fLabelProvider = iLabelProvider;
        this.fContentProvider = iTreeContentProvider;
        this.setResult(new ArrayList(0));
        this.setStatusLineAboveButtons(true);
        this.fContainerMode = false;
        this.fExpandedElements = null;
    }

    public void setContainerMode(boolean bl) {
        this.fContainerMode = bl;
    }

    public void setInitialSelection(Object object) {
        this.setInitialSelections(new Object[]{object});
    }

    public void setEmptyListMessage(String string) {
        this.fEmptyListMessage = string;
    }

    public void setSorter(ViewerSorter viewerSorter) {
        this.fComparator = viewerSorter;
    }

    public void setComparator(ViewerComparator viewerComparator) {
        this.fComparator = viewerComparator;
    }

    public void addFilter(ViewerFilter viewerFilter) {
        if (this.fFilters == null) {
            this.fFilters = new ArrayList(4);
        }
        this.fFilters.add(viewerFilter);
    }

    public void setValidator(ISelectionStatusValidator iSelectionStatusValidator) {
        this.fValidator = iSelectionStatusValidator;
    }

    public void setInput(Object object) {
        this.fInput = object;
    }

    public void setExpandedElements(Object[] objectArray) {
        this.fExpandedElements = objectArray;
    }

    public void setSize(int n, int n2) {
        this.fWidth = n;
        this.fHeight = n2;
    }

    protected void updateOKStatus() {
        if (!this.fIsEmpty) {
            if (this.fValidator != null) {
                this.fCurrStatus = this.fValidator.validate(this.fViewer.getCheckedElements());
                this.updateStatus(this.fCurrStatus);
            } else if (!this.fCurrStatus.isOK()) {
                this.fCurrStatus = new Status(0, "org.eclipse.ui", 0, "", null);
            }
        } else {
            this.fCurrStatus = new Status(4, "org.eclipse.ui", 0, this.fEmptyListMessage, null);
        }
        this.updateStatus(this.fCurrStatus);
    }

    public int open() {
        this.fIsEmpty = this.evaluateIfTreeEmpty(this.fInput);
        super.open();
        return this.getReturnCode();
    }

    private void access$superCreate() {
        super.create();
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    @Override
    protected void computeResult() {
        this.setResult(Arrays.asList(this.fViewer.getCheckedElements()));
    }

    @Override
    public void create() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                CheckedTreeSelectionDialog.this.access$superCreate();
                CheckedTreeSelectionDialog.this.fViewer.setCheckedElements(CheckedTreeSelectionDialog.this.getInitialElementSelections().toArray());
                if (CheckedTreeSelectionDialog.this.fExpandedElements != null) {
                    CheckedTreeSelectionDialog.this.fViewer.setExpandedElements(CheckedTreeSelectionDialog.this.fExpandedElements);
                }
                CheckedTreeSelectionDialog.this.updateOKStatus();
            }
        });
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Label label = this.createMessageArea(composite2);
        CheckboxTreeViewer checkboxTreeViewer = this.createTreeViewer(composite2);
        Composite composite3 = this.createSelectionButtons(composite2);
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        gridData.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
        Tree tree = checkboxTreeViewer.getTree();
        tree.setLayoutData((Object)gridData);
        tree.setFont(composite.getFont());
        if (this.fIsEmpty) {
            label.setEnabled(false);
            tree.setEnabled(false);
            composite3.setEnabled(false);
        }
        return composite2;
    }

    protected CheckboxTreeViewer createTreeViewer(Composite composite) {
        this.fViewer = this.fContainerMode ? new ContainerCheckedTreeViewer(composite, 2048) : new CheckboxTreeViewer(composite, 2048);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                CheckedTreeSelectionDialog.this.updateOKStatus();
            }
        });
        this.fViewer.setComparator(this.fComparator);
        if (this.fFilters != null) {
            int n = 0;
            while (n != this.fFilters.size()) {
                this.fViewer.addFilter((ViewerFilter)this.fFilters.get(n));
                ++n;
            }
        }
        this.fViewer.setInput(this.fInput);
        return this.fViewer;
    }

    protected CheckboxTreeViewer getTreeViewer() {
        return this.fViewer;
    }

    protected Composite createSelectionButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 131072);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite2.setLayout((Layout)gridLayout);
        composite2.setFont(composite.getFont());
        GridData gridData = new GridData(640);
        gridData.grabExcessHorizontalSpace = true;
        composite2.setLayoutData((Object)gridData);
        Button button = this.createButton(composite2, 18, WorkbenchMessages.CheckedTreeSelectionDialog_select_all, false);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object[] objectArray = CheckedTreeSelectionDialog.this.fContentProvider.getElements(CheckedTreeSelectionDialog.this.fInput);
                if (CheckedTreeSelectionDialog.this.fContainerMode) {
                    CheckedTreeSelectionDialog.this.fViewer.setCheckedElements(objectArray);
                } else {
                    int n = 0;
                    while (n < objectArray.length) {
                        CheckedTreeSelectionDialog.this.fViewer.setSubtreeChecked(objectArray[n], true);
                        ++n;
                    }
                }
                CheckedTreeSelectionDialog.this.updateOKStatus();
            }
        };
        button.addSelectionListener((SelectionListener)selectionAdapter);
        Button button2 = this.createButton(composite2, 19, WorkbenchMessages.CheckedTreeSelectionDialog_deselect_all, false);
        selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CheckedTreeSelectionDialog.this.fViewer.setCheckedElements(new Object[0]);
                CheckedTreeSelectionDialog.this.updateOKStatus();
            }
        };
        button2.addSelectionListener((SelectionListener)selectionAdapter);
        return composite2;
    }

    private boolean evaluateIfTreeEmpty(Object object) {
        Object[] objectArray = this.fContentProvider.getElements(object);
        if (objectArray.length > 0 && this.fFilters != null) {
            int n = 0;
            while (n < this.fFilters.size()) {
                ViewerFilter viewerFilter = (ViewerFilter)this.fFilters.get(n);
                objectArray = viewerFilter.filter((Viewer)this.fViewer, object, objectArray);
                ++n;
            }
        }
        return objectArray.length == 0;
    }
}

