/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public abstract class AbstractElementListSelectionDialog
extends SelectionStatusDialog {
    private ILabelProvider fRenderer;
    private boolean fIgnoreCase = true;
    private boolean fIsMultipleSelection = false;
    private boolean fMatchEmptyString = true;
    private boolean fAllowDuplicates = true;
    private Label fMessage;
    protected FilteredList fFilteredList;
    private Text fFilterText;
    private ISelectionStatusValidator fValidator;
    private String fFilter = null;
    private String fEmptyListMessage = "";
    private String fEmptySelectionMessage = "";
    private int fWidth = 60;
    private int fHeight = 18;
    private Object[] fSelection = new Object[0];

    protected AbstractElementListSelectionDialog(Shell shell, ILabelProvider iLabelProvider) {
        super(shell);
        this.fRenderer = iLabelProvider;
    }

    protected void handleDefaultSelected() {
        if (this.validateCurrentSelection()) {
            this.buttonPressed(0);
        }
    }

    public void setIgnoreCase(boolean bl) {
        this.fIgnoreCase = bl;
    }

    public boolean isCaseIgnored() {
        return this.fIgnoreCase;
    }

    public void setMatchEmptyString(boolean bl) {
        this.fMatchEmptyString = bl;
    }

    public void setMultipleSelection(boolean bl) {
        this.fIsMultipleSelection = bl;
    }

    public void setAllowDuplicates(boolean bl) {
        this.fAllowDuplicates = bl;
    }

    public void setSize(int n, int n2) {
        this.fWidth = n;
        this.fHeight = n2;
    }

    public void setEmptyListMessage(String string) {
        this.fEmptyListMessage = string;
    }

    public void setEmptySelectionMessage(String string) {
        this.fEmptySelectionMessage = string;
    }

    public void setValidator(ISelectionStatusValidator iSelectionStatusValidator) {
        this.fValidator = iSelectionStatusValidator;
    }

    protected void setListElements(Object[] objectArray) {
        Assert.isNotNull((Object)((Object)this.fFilteredList));
        this.fFilteredList.setElements(objectArray);
        this.handleElementsChanged();
    }

    protected void handleElementsChanged() {
        boolean bl = !this.fFilteredList.isEmpty();
        this.fMessage.setEnabled(bl);
        this.fFilteredList.setEnabled(bl);
        this.updateOkState();
    }

    public void setFilter(String string) {
        if (this.fFilterText == null) {
            this.fFilter = string;
        } else {
            this.fFilterText.setText(string);
        }
    }

    public String getFilter() {
        if (this.fFilteredList == null) {
            return this.fFilter;
        }
        return this.fFilteredList.getFilter();
    }

    protected int[] getSelectionIndices() {
        Assert.isNotNull((Object)((Object)this.fFilteredList));
        return this.fFilteredList.getSelectionIndices();
    }

    protected int getSelectionIndex() {
        Assert.isNotNull((Object)((Object)this.fFilteredList));
        return this.fFilteredList.getSelectionIndex();
    }

    protected void setSelection(Object[] objectArray) {
        Assert.isNotNull((Object)((Object)this.fFilteredList));
        this.fFilteredList.setSelection(objectArray);
    }

    protected Object[] getSelectedElements() {
        Assert.isNotNull((Object)((Object)this.fFilteredList));
        return this.fFilteredList.getSelection();
    }

    public Object[] getFoldedElements(int n) {
        Assert.isNotNull((Object)((Object)this.fFilteredList));
        return this.fFilteredList.getFoldedElements(n);
    }

    @Override
    protected Label createMessageArea(Composite composite) {
        Label label = super.createMessageArea(composite);
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = false;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        label.setLayoutData((Object)gridData);
        this.fMessage = label;
        return label;
    }

    protected void handleSelectionChanged() {
        this.validateCurrentSelection();
    }

    protected boolean validateCurrentSelection() {
        Assert.isNotNull((Object)((Object)this.fFilteredList));
        Object[] objectArray = this.getSelectedElements();
        Object object = objectArray.length > 0 ? (this.fValidator != null ? this.fValidator.validate(objectArray) : new Status(0, "org.eclipse.ui", 0, "", null)) : (this.fFilteredList.isEmpty() ? new Status(4, "org.eclipse.ui", 4, this.fEmptyListMessage, null) : new Status(4, "org.eclipse.ui", 4, this.fEmptySelectionMessage, null));
        this.updateStatus((IStatus)object);
        return object.isOK();
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    protected FilteredList createFilteredList(Composite composite) {
        int n = 0xB00 | (this.fIsMultipleSelection ? 2 : 4);
        FilteredList filteredList = new FilteredList(composite, n, this.fRenderer, this.fIgnoreCase, this.fAllowDuplicates, this.fMatchEmptyString);
        GridData gridData = new GridData();
        gridData.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        gridData.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        filteredList.setLayoutData(gridData);
        filteredList.setFont(composite.getFont());
        filteredList.setFilter(this.fFilter == null ? "" : this.fFilter);
        filteredList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                AbstractElementListSelectionDialog.this.handleDefaultSelected();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                AbstractElementListSelectionDialog.this.handleWidgetSelected();
            }
        });
        this.fFilteredList = filteredList;
        return filteredList;
    }

    private void handleWidgetSelected() {
        Object[] objectArray = this.fFilteredList.getSelection();
        if (objectArray.length != this.fSelection.length) {
            this.fSelection = objectArray;
            this.handleSelectionChanged();
        } else {
            int n = 0;
            while (n != objectArray.length) {
                if (!objectArray[n].equals(this.fSelection[n])) {
                    this.fSelection = objectArray;
                    this.handleSelectionChanged();
                    break;
                }
                ++n;
            }
        }
    }

    protected Text createFilterText(Composite composite) {
        Text text = new Text(composite, 2048);
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = false;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        text.setLayoutData((Object)gridData);
        text.setFont(composite.getFont());
        text.setText(this.fFilter == null ? "" : this.fFilter);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                AbstractElementListSelectionDialog.this.fFilteredList.setFilter(AbstractElementListSelectionDialog.this.fFilterText.getText());
            }
        };
        text.addListener(24, listener);
        text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 0x1000002) {
                    AbstractElementListSelectionDialog.this.fFilteredList.setFocus();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.fFilterText = text;
        return text;
    }

    public int open() {
        super.open();
        return this.getReturnCode();
    }

    private void access$superCreate() {
        super.create();
    }

    @Override
    public void create() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractElementListSelectionDialog.this.access$superCreate();
                Assert.isNotNull((Object)((Object)AbstractElementListSelectionDialog.this.fFilteredList));
                if (AbstractElementListSelectionDialog.this.fFilteredList.isEmpty()) {
                    AbstractElementListSelectionDialog.this.handleEmptyList();
                } else {
                    AbstractElementListSelectionDialog.this.validateCurrentSelection();
                    AbstractElementListSelectionDialog.this.fFilterText.selectAll();
                    AbstractElementListSelectionDialog.this.fFilterText.setFocus();
                }
            }
        });
    }

    protected void handleEmptyList() {
        this.fMessage.setEnabled(false);
        this.fFilterText.setEnabled(false);
        this.fFilteredList.setEnabled(false);
        this.updateOkState();
    }

    protected void updateOkState() {
        Button button = this.getOkButton();
        if (button != null) {
            button.setEnabled(this.getSelectedElements().length != 0);
        }
    }

    protected ISelectionStatusValidator getValidator() {
        return this.fValidator;
    }
}

