/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.databinding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.NativePropertyListener;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.list.SimpleListProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;

public class WorkbenchProperties {
    public static IValueProperty adaptedValue(Class clazz) {
        return WorkbenchProperties.adaptedValue(clazz, Platform.getAdapterManager());
    }

    static IValueProperty adaptedValue(Class clazz, IAdapterManager iAdapterManager) {
        return new AdaptedValueProperty(clazz, iAdapterManager);
    }

    public static IValueProperty singleSelection() {
        return WorkbenchProperties.singleSelection(null, false);
    }

    public static IValueProperty singleSelection(String string, boolean bl) {
        return new SingleSelectionProperty(string, bl);
    }

    public static IListProperty multipleSelection() {
        return WorkbenchProperties.multipleSelection(null, false);
    }

    public static IListProperty multipleSelection(String string, boolean bl) {
        return new MultiSelectionProperty(string, bl);
    }

    static final class AdaptedValueProperty
    extends SimpleValueProperty {
        private final Class adapter;
        private final IAdapterManager adapterManager;

        private AdaptedValueProperty(Class clazz, IAdapterManager iAdapterManager) {
            this.adapter = clazz;
            this.adapterManager = iAdapterManager;
        }

        public Object getValueType() {
            return this.adapter;
        }

        protected Object doGetValue(Object object) {
            if (this.adapter.isInstance(object)) {
                return object;
            }
            return this.adapterManager.getAdapter(object, this.adapter);
        }

        protected void doSetValue(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }

        public INativePropertyListener adaptListener(ISimplePropertyListener iSimplePropertyListener) {
            return null;
        }
    }

    static class MultiSelectionProperty
    extends SimpleListProperty {
        private final String partId;
        private final boolean post;

        MultiSelectionProperty(String string, boolean bl) {
            this.partId = string;
            this.post = bl;
        }

        public INativePropertyListener adaptListener(ISimplePropertyListener iSimplePropertyListener) {
            return new SelectionServiceListener((IProperty)this, iSimplePropertyListener, this.partId, this.post);
        }

        public Object getElementType() {
            return Object.class;
        }

        protected List doGetList(Object object) {
            ISelection iSelection = this.partId != null ? ((ISelectionService)object).getSelection(this.partId) : ((ISelectionService)object).getSelection();
            if (iSelection instanceof IStructuredSelection) {
                return new ArrayList(((IStructuredSelection)iSelection).toList());
            }
            return Collections.EMPTY_LIST;
        }

        protected void doSetList(Object object, List list, ListDiff listDiff) {
            throw new UnsupportedOperationException();
        }
    }

    static class SelectionServiceListener
    extends NativePropertyListener
    implements ISelectionListener {
        private final String partId;
        private final boolean post;

        public SelectionServiceListener(IProperty iProperty, ISimplePropertyListener iSimplePropertyListener, String string, boolean bl) {
            super(iProperty, iSimplePropertyListener);
            this.partId = string;
            this.post = bl;
        }

        protected void doAddTo(Object object) {
            ISelectionService iSelectionService = (ISelectionService)object;
            if (this.post) {
                if (this.partId != null) {
                    iSelectionService.addPostSelectionListener(this.partId, this);
                } else {
                    iSelectionService.addPostSelectionListener(this);
                }
            } else if (this.partId != null) {
                iSelectionService.addSelectionListener(this.partId, this);
            } else {
                iSelectionService.addSelectionListener(this);
            }
        }

        protected void doRemoveFrom(Object object) {
            ISelectionService iSelectionService = (ISelectionService)object;
            if (this.post) {
                if (this.partId != null) {
                    iSelectionService.removePostSelectionListener(this.partId, this);
                } else {
                    iSelectionService.removePostSelectionListener(this);
                }
            } else if (this.partId != null) {
                iSelectionService.removeSelectionListener(this.partId, this);
            } else {
                iSelectionService.removeSelectionListener(this);
            }
        }

        @Override
        public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
            this.fireChange(iWorkbenchPart, null);
        }
    }

    static class SingleSelectionProperty
    extends SimpleValueProperty {
        private final String partId;
        private final boolean post;

        SingleSelectionProperty(String string, boolean bl) {
            this.partId = string;
            this.post = bl;
        }

        public INativePropertyListener adaptListener(ISimplePropertyListener iSimplePropertyListener) {
            return new SelectionServiceListener((IProperty)this, iSimplePropertyListener, this.partId, this.post);
        }

        protected Object doGetValue(Object object) {
            ISelection iSelection = this.partId != null ? ((ISelectionService)object).getSelection(this.partId) : ((ISelectionService)object).getSelection();
            if (iSelection instanceof IStructuredSelection) {
                return ((IStructuredSelection)iSelection).getFirstElement();
            }
            return null;
        }

        protected void doSetValue(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }

        public Object getValueType() {
            return Object.class;
        }
    }
}

