/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.contexts;

import java.util.Set;
import org.eclipse.ui.contexts.IContextManager;
import org.eclipse.ui.internal.util.Util;

public final class ContextManagerEvent {
    private final IContextManager contextManager;
    private final boolean definedContextIdsChanged;
    private final boolean enabledContextIdsChanged;
    private final Set previouslyDefinedContextIds;
    private final Set previouslyEnabledContextIds;

    public ContextManagerEvent(IContextManager iContextManager, boolean bl, boolean bl2, Set set, Set set2) {
        if (iContextManager == null) {
            throw new NullPointerException();
        }
        if (!bl && set != null) {
            throw new IllegalArgumentException();
        }
        if (!bl2 && set2 != null) {
            throw new IllegalArgumentException();
        }
        this.previouslyDefinedContextIds = bl ? Util.safeCopy(set, String.class) : null;
        this.previouslyEnabledContextIds = bl2 ? Util.safeCopy(set2, String.class) : null;
        this.contextManager = iContextManager;
        this.definedContextIdsChanged = bl;
        this.enabledContextIdsChanged = bl2;
    }

    public IContextManager getContextManager() {
        return this.contextManager;
    }

    public Set getPreviouslyDefinedContextIds() {
        return this.previouslyDefinedContextIds;
    }

    public Set getPreviouslyEnabledContextIds() {
        return this.previouslyEnabledContextIds;
    }

    public boolean haveDefinedContextIdsChanged() {
        return this.definedContextIdsChanged;
    }

    public boolean haveEnabledContextIdsChanged() {
        return this.enabledContextIdsChanged;
    }
}

