/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.commands;

import java.util.Map;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.internal.util.Util;

public final class HandlerEvent {
    private final boolean attributeValuesByNameChanged;
    private final IHandler handler;
    private Map previousAttributeValuesByName;
    private final Map originalPreviousAttributeValuesByName;

    public HandlerEvent(IHandler iHandler, boolean bl, Map map) {
        if (iHandler == null) {
            throw new NullPointerException();
        }
        if (!bl && map != null) {
            throw new IllegalArgumentException();
        }
        this.originalPreviousAttributeValuesByName = bl ? map : null;
        this.handler = iHandler;
        this.attributeValuesByNameChanged = bl;
    }

    public IHandler getHandler() {
        return this.handler;
    }

    public Map getPreviousAttributeValuesByName() {
        if (this.originalPreviousAttributeValuesByName == null) {
            return null;
        }
        if (this.previousAttributeValuesByName == null) {
            this.previousAttributeValuesByName = Util.safeCopy(this.originalPreviousAttributeValuesByName, String.class, Object.class, false, true);
        }
        return this.previousAttributeValuesByName;
    }

    public boolean haveAttributeValuesByNameChanged() {
        return this.attributeValuesByNameChanged;
    }
}

